/*!
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2015
 * @version 4.3.1
 *
 * File input styled for Bootstrap 3.0 that utilizes HTML5 File Input's advanced features including the FileReader API.
 *
 * The plugin drastically enhances the HTML file input to preview multiple files on the client before upload. In
 * addition it provides the ability to preview content of images, text, videos, audio, html, flash and other objects.
 * It also offers the ability to upload and delete files using AJAX, and add files in batches (i.e. preview, append,
 * or remove before upload).
 *
 * Author: Kartik Visweswaran
 * Copyright: 2015, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */!function(e){"use strict";"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof module&&module.exports?module.exports=e(require("jquery")):e(window.jQuery)}(function(e){"use strict";e.fn.fileinputLocales={};var i,t,a,r,n,l,o,s,d,c,p,u,f,v,g,m,h,w,b,C,x,y,T,F,E,I,$,k,P,S,D,U,A,j,L,z,O,R,M,N,B,Z,H,W,q,_,V,K,X,J,Q,Y,G,ee;i=".fileinput",t=window.URL||window.webkitURL,a=function(e,i,t){return void 0!==e&&(t?e===i:e.match(i))},r=function(e){if("Microsoft Internet Explorer"!==navigator.appName)return!1;if(10===e)return new RegExp("msie\\s"+e,"i").test(navigator.userAgent);var i,t=document.createElement("div");return t.innerHTML="<!--[if IE "+e+"]> <i></i> <![endif]-->",i=t.getElementsByTagName("i").length,document.body.appendChild(t),t.parentNode.removeChild(t),i},n=function(){return new RegExp("Edge/[0-9]+","i").test(navigator.userAgent)},l=function(e,t,a,r){var n=r?t:t.split(" ").join(i+" ")+i;e.off(n).on(n,a)},o={data:{},init:function(e){var i=e.initialPreview,t=e.id;i.length>0&&!K(i)&&(i=i.split(e.initialPreviewDelimiter)),o.data[t]={content:i,config:e.initialPreviewConfig,tags:e.initialPreviewThumbTags,delimiter:e.initialPreviewDelimiter,template:e.previewGenericTemplate,msg:function(i){return e.getMsgSelected(i)},initId:e.previewInitId,footer:e.getLayoutTemplate("footer").replace(/\{progress}/g,e.renderThumbProgress()),isDelete:e.initialPreviewShowDelete,caption:e.initialCaption,actions:function(i,t,a,r,n){return e.renderFileActions(i,t,a,r,n)}}},fetch:function(e){return o.data[e].content.filter(function(e){return null!==e})},count:function(e,i){return o.data[e]&&o.data[e].content?i?o.data[e].content.length:o.fetch(e).length:0},get:function(i,t,a){var r,n,l="init_"+t,s=o.data[i],d=s.config[t],c=s.initId+"-"+l,p=" file-preview-initial";return a=void 0===a?!0:a,null===s.content[t]?"":(V(d)||V(d.frameClass)||(p+=" "+d.frameClass),r=s.template.replace(/\{previewId}/g,c).replace(/\{frameClass}/g,p).replace(/\{fileindex}/g,l).replace(/\{content}/g,s.content[t]).replace(/\{footer}/g,o.footer(i,t,a)),s.tags.length&&s.tags[t]&&(r=G(r,s.tags[t])),V(d)||V(d.frameAttr)||(n=e(document.createElement("div")).html(r),n.find(".file-preview-initial").attr(d.frameAttr),r=n.html(),n.remove()),r)},add:function(i,t,a,r,n){var l,s=e.extend(!0,{},o.data[i]);return K(t)||(t=t.split(s.delimiter)),n?(l=s.content.push(t)-1,s.config[l]=a,s.tags[l]=r):(l=t.length,s.content=t,s.config=a,s.tags=r),o.data[i]=s,l},set:function(i,t,a,r,n){var l,s,d=e.extend(!0,{},o.data[i]);if(t&&t.length&&(K(t)||(t=t.split(d.delimiter)),s=t.filter(function(e){return null!==e}),s.length)){if(void 0===d.content&&(d.content=[]),void 0===d.config&&(d.config=[]),void 0===d.tags&&(d.tags=[]),n){for(l=0;l<t.length;l++)t[l]&&d.content.push(t[l]);for(l=0;l<a.length;l++)a[l]&&d.config.push(a[l]);for(l=0;l<r.length;l++)r[l]&&d.tags.push(r[l])}else d.content=t,d.config=a,d.tags=r;o.data[i]=d}},unset:function(e,i){var t=o.count(e);if(t){if(1===t)return o.data[e].content=[],void(o.data[e].config=[]);o.data[e].content[i]=null,o.data[e].config[i]=null}},out:function(e){var i,t="",a=o.data[e],r=o.count(e,!0);if(0===r)return{content:"",caption:""};for(var n=0;r>n;n++)t+=o.get(e,n);return i=a.msg(o.count(e)),{content:t,caption:i}},footer:function(e,i,t){var a=o.data[e];if(t=void 0===t?!0:t,0===a.config.length||V(a.config[i]))return"";var r=a.config[i],n=X("caption",r)?r.caption:"",l=X("width",r)?r.width:"auto",s=X("url",r)?r.url:!1,d=X("key",r)?r.key:null,c=s===!1&&t,p=a.isDelete?a.actions(!1,!0,c,s,d):"",u=a.footer.replace(/\{actions}/g,p);return u.replace(/\{caption}/g,n).replace(/\{width}/g,l).replace(/\{indicator}/g,"").replace(/\{indicatorTitle}/g,"")}},s=function(e,i){return i=i||0,"number"==typeof e?e:("string"==typeof e&&(e=parseFloat(e)),isNaN(e)?i:e)},d=function(){return!(!window.File||!window.FileReader)},c=function(){var e=document.createElement("div");return!r(9)&&!n()&&(void 0!==e.draggable||void 0!==e.ondragstart&&void 0!==e.ondrop)},p=function(){return d()&&window.FormData},u=function(e,i){e.removeClass(i).addClass(i)},f='style="width:{width};height:{height};"',v='      <param name="controller" value="true" />\n      <param name="allowFullScreen" value="true" />\n      <param name="allowScriptAccess" value="always" />\n      <param name="autoPlay" value="false" />\n      <param name="autoStart" value="false" />\n      <param name="quality" value="high" />\n',g='<div class="file-preview-other">\n   <span class="{previewFileIconClass}">{previewFileIcon}</span>\n</div>',m={removeIcon:'<i class="glyphicon glyphicon-trash text-danger"></i>',removeClass:"btn btn-xs btn-default",removeTitle:"Remove file",uploadIcon:'<i class="glyphicon glyphicon-upload text-info"></i>',uploadClass:"btn btn-xs btn-default",uploadTitle:"Upload file",indicatorNew:'<i class="glyphicon glyphicon-hand-down text-warning"></i>',indicatorSuccess:'<i class="glyphicon glyphicon-ok-sign text-success"></i>',indicatorError:'<i class="glyphicon glyphicon-exclamation-sign text-danger"></i>',indicatorLoading:'<i class="glyphicon glyphicon-hand-up text-muted"></i>',indicatorNewTitle:"Not uploaded yet",indicatorSuccessTitle:"Uploaded",indicatorErrorTitle:"Upload Error",indicatorLoadingTitle:"Uploading ..."},h='{preview}\n<div class="kv-upload-progress hide"></div>\n<div class="input-group {class}">\n   {caption}\n   <div class="input-group-btn">\n       {remove}\n       {cancel}\n       {upload}\n       {browse}\n   </div>\n</div>',w='{preview}\n<div class="kv-upload-progress hide"></div>\n{remove}\n{cancel}\n{upload}\n{browse}\n',b='<div class="file-preview {class}">\n    {close}    <div class="{dropClass}">\n    <div class="file-preview-thumbnails">\n    </div>\n    <div class="clearfix"></div>    <div class="file-preview-status text-center text-success"></div>\n    <div class="kv-fileinput-error"></div>\n    </div>\n</div>',x='<div class="close fileinput-remove">&times;</div>\n',C='<span class="glyphicon glyphicon-file kv-caption-icon"></span>',y='<div tabindex="500" class="form-control file-caption {class}">\n   <div class="file-caption-name"></div>\n</div>\n',T='<button type="{type}" tabindex="500" title="{title}" class="{css}" {status}>{icon}{label}</button>',F='<a href="{href}" tabindex="500" title="{title}" class="{css}" {status}>{icon}{label}</a>',E='<div tabindex="500" class="{css}" {status}>{icon}{label}</div>',I='<div id="{id}" class="file-preview-detail-modal modal fade" tabindex="-1">\n  <div class="modal-dialog modal-lg">\n    <div class="modal-content">\n      <div class="modal-header">\n        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n        <h3 class="modal-title">{heading} <small>{title}</small></h3>\n      </div>\n      <div class="modal-body">\n           <pre>{body}</pre>\n      </div>\n    </div>\n  </div>\n</div>',$='<div class="progress">\n    <div class="{class}" role="progressbar" aria-valuenow="{percent}" aria-valuemin="0" aria-valuemax="100" style="width:{percent}%;">\n        {percent}%\n     </div>\n</div>',k='<div class="file-thumbnail-footer">\n    <div class="file-footer-caption" title="{caption}">{caption}</div>\n    {progress} {actions}\n</div>',P='<div class="file-actions">\n    <div class="file-footer-buttons">\n        {upload}{delete}{other}    </div>\n    <div class="file-upload-indicator" title="{indicatorTitle}">{indicator}</div>\n    <div class="clearfix"></div>\n</div>',S='<button type="button" class="kv-file-remove {removeClass}" title="{removeTitle}" {dataUrl}{dataKey}>{removeIcon}</button>\n',D='<button type="button" class="kv-file-upload {uploadClass}" title="{uploadTitle}">   {uploadIcon}\n</button>\n',U='<button type="button" class="btn btn-default btn-xs btn-block" title="{zoomTitle}: {caption}" onclick="{dialog}">\n   {zoomInd}\n</button>\n',A='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   {content}\n   {footer}\n</div>\n',j='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n    <object class="file-object" data="{data}" type="{type}" width="{width}" height="{height}">\n       '+g+"\n    </object>\n   {footer}\n</div>",L='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   <img src="{data}" class="file-preview-image" title="{caption}" alt="{caption}" '+f+">\n   {footer}\n</div>\n",z='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   <pre class="file-preview-text" title="{caption}" '+f+">{data}</pre>\n   {zoom}\n   {footer}\n</div>",O='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+f+'>\n   <video width="{width}" height="{height}" controls>\n       <source src="{data}" type="{type}">\n       '+g+"\n   </video>\n   {footer}\n</div>\n",R='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+f+'>\n   <audio controls>\n       <source src="{data}" type="{type}">\n       '+g+"\n   </audio>\n   {footer}\n</div>",M='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+f+'>\n   <object class="file-object" type="application/x-shockwave-flash" width="{width}" height="{height}" data="{data}">\n'+v+"       "+g+"\n   </object>\n   {footer}\n</div>\n",N='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+f+'>\n   <object class="file-object" data="{data}" type="{type}" width="{width}" height="{height}">\n       <param name="movie" value="{caption}" />\n'+v+"         "+g+"\n   </object>\n   {footer}\n</div>",B='<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+f+'>\n   <div class="file-preview-other-frame">\n   '+g+'\n   </div>\n   <div class="file-preview-other-footer">{footer}</div>\n</div>',Z={main1:h,main2:w,preview:b,close:x,zoom:U,icon:C,caption:y,modal:I,progress:$,footer:k,actions:P,actionDelete:S,actionUpload:D,btnDefault:T,btnLink:F,btnBrowse:E},H={generic:A,html:j,image:L,text:z,video:O,audio:R,flash:M,object:N,other:B},W=["image","html","text","video","audio","flash","object"],q={image:{width:"auto",height:"160px"},html:{width:"213px",height:"160px"},text:{width:"160px",height:"136px"},video:{width:"213px",height:"160px"},audio:{width:"213px",height:"80px"},flash:{width:"213px",height:"160px"},object:{width:"160px",height:"160px"},other:{width:"160px",height:"160px"}},_={image:function(e,i){return a(e,"image.*")||a(i,/\.(gif|png|jpe?g)$/i)},html:function(e,i){return a(e,"text/html")||a(i,/\.(htm|html)$/i)},text:function(e,i){return a(e,"text.*")||a(e,/\.(xml|javascript)$/i)||a(i,/\.(txt|md|csv|nfo|ini|json|php|js|css)$/i)},video:function(e,i){return a(e,"video.*")&&(a(e,/(ogg|mp4|mp?g|webm|3gp)$/i)||a(i,/\.(og?|mp4|webm|mp?g|3gp)$/i))},audio:function(e,i){return a(e,"audio.*")&&(a(e,/(ogg|mp3|mp?g|wav)$/i)||a(i,/\.(og?|mp3|mp?g|wav)$/i))},flash:function(e,i){return a(e,"application/x-shockwave-flash",!0)||a(i,/\.(swf)$/i)},object:function(e,i){return a(e,"application/pdf",!0)||a(i,/\.(pdf)$/i)},other:function(){return!0}},V=function(i,t){return void 0===i||null===i||0===i.length||t&&""===e.trim(i)},K=function(e){return Array.isArray(e)||"[object Array]"===Object.prototype.toString.call(e)},X=function(e,i){return"object"==typeof i&&e in i},J=function(i,t,a){return V(i)||V(i[t])?a:e(i[t])},Q=function(){return Math.round((new Date).getTime()+100*Math.random())},Y=function(e){return e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&apos;")},G=function(i,t){var a=i;return t?(e.each(t,function(e,i){"function"==typeof i&&(i=i()),a=a.split(e).join(i)}),a):a},ee=function(i,t){var a=this;a.$element=e(i),a.validate()&&(a.isPreviewable=d(),a.isIE9=r(9),a.isIE10=r(10),a.isPreviewable||a.isIE9?(a.init(t),a.listen()):a.$element.removeClass("file-loading"))},ee.prototype={constructor:ee,validate:function(){var e,i=this;return"file"===i.$element.attr("type")?!0:(e='<div class="help-block alert alert-warning"><h4>Invalid Input Type</h4>You must set an input <code>type = file</code> for <b>bootstrap-fileinput</b> plugin to initialize.</div>',i.$element.after(e),!1)},init:function(i){var t,a=this,r=a.$element;e.each(i,function(e,i){switch(e){case"minFileCount":case"maxFileCount":case"maxFileSize":a[e]=s(i);break;default:a[e]=i}}),a.fileInputCleared=!1,a.fileBatchCompleted=!0,a.isPreviewable||(a.showPreview=!1),a.uploadFileAttr=V(r.attr("name"))?"file_data":r.attr("name"),a.reader=null,a.formdata={},a.clearStack(),a.uploadCount=0,a.uploadStatus={},a.uploadLog=[],a.uploadAsyncCount=0,a.loadedImages=[],a.totalImagesCount=0,a.ajaxRequests=[],a.isError=!1,a.ajaxAborted=!1,a.cancelling=!1,t=a.getLayoutTemplate("progress"),a.progressTemplate=t.replace("{class}",a.progressClass),a.progressCompleteTemplate=t.replace("{class}",a.progressCompleteClass),a.progressErrorTemplate=t.replace("{class}",a.progressErrorClass),a.dropZoneEnabled=c()&&a.dropZoneEnabled,a.isDisabled=a.$element.attr("disabled")||a.$element.attr("readonly"),a.isUploadable=p()&&!V(a.uploadUrl),a.slug="function"==typeof i.slugCallback?i.slugCallback:a.slugDefault,a.mainTemplate=a.showCaption?a.getLayoutTemplate("main1"):a.getLayoutTemplate("main2"),a.captionTemplate=a.getLayoutTemplate("caption"),a.previewGenericTemplate=a.getPreviewTemplate("generic"),a.resizeImage&&(a.maxImageWidth||a.maxImageHeight)&&(a.imageCanvas=document.createElement("canvas"),a.imageCanvasContext=a.imageCanvas.getContext("2d")),V(a.$element.attr("id"))&&a.$element.attr("id",Q()),void 0===a.$container?a.$container=a.createContainer():a.refreshContainer(),a.$dropZone=a.$container.find(".file-drop-zone"),a.$progress=a.$container.find(".kv-upload-progress"),a.$btnUpload=a.$container.find(".fileinput-upload"),a.$captionContainer=J(i,"elCaptionContainer",a.$container.find(".file-caption")),a.$caption=J(i,"elCaptionText",a.$container.find(".file-caption-name")),a.$previewContainer=J(i,"elPreviewContainer",a.$container.find(".file-preview")),a.$preview=J(i,"elPreviewImage",a.$container.find(".file-preview-thumbnails")),a.$previewStatus=J(i,"elPreviewStatus",a.$container.find(".file-preview-status")),a.$errorContainer=J(i,"elErrorContainer",a.$previewContainer.find(".kv-fileinput-error")),V(a.msgErrorClass)||u(a.$errorContainer,a.msgErrorClass),a.$errorContainer.hide(),a.fileActionSettings=e.extend(!0,m,i.fileActionSettings),a.previewInitId="preview-"+Q(),a.id=a.$element.attr("id"),o.init(a),a.initPreview(!0),a.initPreviewDeletes(),a.options=i,a.setFileDropZoneTitle(),a.$element.removeClass("file-loading"),a.$element.attr("disabled")&&a.disable()},parseError:function(i,t,a){var r=this,n=e.trim(t+""),l="."===n.slice(-1)?"":".",o=void 0!==i.responseJSON&&void 0!==i.responseJSON.error?i.responseJSON.error:i.responseText;return r.cancelling&&r.msgUploadAborted&&(n=r.msgUploadAborted),r.showAjaxErrorDetails&&o?(o=e.trim(o.replace(/\n\s*\n/g,"\n")),o=o.length>0?"<pre>"+o+"</pre>":"",n+=l+o):n+=l,r.cancelling=!1,a?"<b>"+a+": </b>"+n:n},raise:function(i,t){var a=this,r=e.Event(i);if(void 0!==t?a.$element.trigger(r,t):a.$element.trigger(r),r.isDefaultPrevented())return!1;if(!r.result)return r.result;switch(i){case"filebatchuploadcomplete":case"filebatchuploadsuccess":case"fileuploaded":case"fileclear":case"filecleared":case"filereset":case"fileerror":case"filefoldererror":case"fileuploaderror":case"filebatchuploaderror":case"filedeleteerror":case"filecustomerror":case"filesuccessremove":break;default:a.ajaxAborted=r.result}return!0},getLayoutTemplate:function(e){var i=this,t=X(e,i.layoutTemplates)?i.layoutTemplates[e]:Z[e];return V(i.customLayoutTags)?t:G(t,i.customLayoutTags)},getPreviewTemplate:function(e){var i=this,t=X(e,i.previewTemplates)?i.previewTemplates[e]:H[e];return V(i.customPreviewTags)?t:G(t,i.customPreviewTags)},parseFilePreviewIcon:function(i,t){var a,r=this,n=r.previewFileIcon;return t&&t.indexOf(".")>-1&&(a=t.split(".").pop(),r.previewFileIconSettings&&r.previewFileIconSettings[a]&&(n=r.previewFileIconSettings[a]),r.previewFileExtSettings&&e.each(r.previewFileExtSettings,function(e,i){r.previewFileIconSettings[e]&&i(a)&&(n=r.previewFileIconSettings[e])})),i.indexOf("{previewFileIcon}")>-1?i.replace(/\{previewFileIconClass}/g,r.previewFileIconClass).replace(/\{previewFileIcon}/g,n):i},getOutData:function(e,i,t){var a=this;return e=e||{},i=i||{},t=t||a.filestack.slice(0)||{},{form:a.formdata,files:t,filenames:a.filenames,extra:a.getExtraData(),response:i,reader:a.reader,jqXHR:e}},listen:function(){var i=this,t=i.$element,a=t.closest("form"),r=i.$container;l(t,"change",e.proxy(i.change,i)),l(i.$btnFile,"click",e.proxy(i.browse,i)),l(a,"reset",e.proxy(i.reset,i)),l(r.find(".fileinput-remove:not([disabled])"),"click",e.proxy(i.clear,i)),l(r.find(".fileinput-cancel"),"click",e.proxy(i.cancel,i)),i.initDragDrop(),i.isUploadable||l(a,"submit",e.proxy(i.submitForm,i)),l(i.$container.find(".fileinput-upload"),"click",e.proxy(i.uploadClick,i))},zoneDragDropInit:function(e){e.stopPropagation(),e.preventDefault()},zoneDragEnter:function(i){var t=this,a=e.inArray("Files",i.originalEvent.dataTransfer.types)>-1;return t.zoneDragDropInit(i),t.isDisabled||!a?(i.originalEvent.dataTransfer.effectAllowed="none",void(i.originalEvent.dataTransfer.dropEffect="none")):void u(t.$dropZone,"file-highlighted")},zoneDragLeave:function(e){var i=this;i.zoneDragDropInit(e),i.isDisabled||i.$dropZone.removeClass("file-highlighted")},zoneDrop:function(e){var i=this;e.preventDefault(),i.isDisabled||V(e.originalEvent.dataTransfer.files)||(i.change(e,"dragdrop"),i.$dropZone.removeClass("file-highlighted"))},initDragDrop:function(){var i=this,t=i.$dropZone;i.isUploadable&&i.dropZoneEnabled&&i.showPreview&&(l(t,"dragenter dragover",e.proxy(i.zoneDragEnter,i)),l(t,"dragleave",e.proxy(i.zoneDragLeave,i)),l(t,"drop",e.proxy(i.zoneDrop,i)),l(e(document),"dragenter dragover drop",i.zoneDragDropInit))},browse:function(e){var i=this;i.raise("filebrowse"),e&&e.isDefaultPrevented()||(i.isError&&!i.isUploadable&&i.clear(),i.$captionContainer.focus())},uploadClick:function(e){var i,t=this,a=t.$container.find(".fileinput-upload"),r=!a.hasClass("disabled")&&V(a.attr("disabled"));if(!e||!e.isDefaultPrevented()){if(!t.isUploadable)return void(r&&"submit"!==a.attr("type")&&(i=a.closest("form"),i.length&&i.trigger("submit"),e.preventDefault()));e.preventDefault(),r&&t.upload()}},submitForm:function(){var e=this,i=e.$element,t=i.get(0).files;return t&&e.minFileCount>0&&e.getFileCount(t.length)<e.minFileCount?(e.noFilesError({}),!1):!e.abort({})},abort:function(i){var t,a=this;return a.ajaxAborted&&"object"==typeof a.ajaxAborted&&void 0!==a.ajaxAborted.message?(t=e.extend(!0,{},a.getOutData(),i),t.abortData=a.ajaxAborted.data||{},t.abortMessage=a.ajaxAborted.message,a.cancel(),a.setProgress(100,a.$progress,a.msgCancelled),a.showUploadError(a.ajaxAborted.message,t,"filecustomerror"),!0):!1},setProgressCancelled:function(){var e=this;e.setProgress(100,e.$progress,e.msgCancelled)},setProgress:function(e,i,t){var a=this,r=Math.min(e,100),n=100>r?a.progressTemplate:t?a.progressErrorTemplate:a.progressCompleteTemplate;i=i||a.$progress,V(n)||(i.html(n.replace(/\{percent}/g,r)),t&&i.find('[role="progressbar"]').html(t))},lock:function(){var e=this;e.resetErrors(),e.disable(),e.showRemove&&u(e.$container.find(".fileinput-remove"),"hide"),e.showCancel&&e.$container.find(".fileinput-cancel").removeClass("hide"),e.raise("filelock",[e.filestack,e.getExtraData()])},unlock:function(e){var i=this;void 0===e&&(e=!0),i.enable(),i.showCancel&&u(i.$container.find(".fileinput-cancel"),"hide"),i.showRemove&&i.$container.find(".fileinput-remove").removeClass("hide"),e&&i.resetFileStack(),i.raise("fileunlock",[i.filestack,i.getExtraData()])},resetFileStack:function(){var i=this,t=0,a=[],r=[];i.getThumbs().each(function(){var n=e(this),l=n.attr("data-fileindex"),o=i.filestack[l];-1!==l&&(void 0!==o?(a[t]=o,r[t]=i.getFileName(o),n.attr({id:i.previewInitId+"-"+t,"data-fileindex":t}),t++):n.attr({id:"uploaded-"+Q(),"data-fileindex":"-1"}))}),i.filestack=a,i.filenames=r},destroy:function(){var e=this,t=e.$container;t.find(".file-drop-zone").off(),e.$element.insertBefore(t).off(i).removeData(),t.off().remove()},refresh:function(i){var t=this,a=t.$element;i=i?e.extend(!0,{},t.options,i):t.options,t.destroy(),a.fileinput(i),a.val()&&a.trigger("change.fileinput")},setFileDropZoneTitle:function(){var e=this,i=e.$container.find(".file-drop-zone");i.find("."+e.dropZoneTitleClass).remove(),e.isUploadable&&e.showPreview&&0!==i.length&&!(e.getFileStack().length>0)&&e.dropZoneEnabled&&(0===i.find(".file-preview-frame").length&&V(e.defaultPreviewContent)&&i.prepend('<div class="'+e.dropZoneTitleClass+'">'+e.dropZoneTitle+"</div>"),e.$container.removeClass("file-input-new"),u(e.$container,"file-input-ajax-new"))},errorsExist:function(){var i,t=this;return t.$errorContainer.find("li").length?!0:(i=e(document.createElement("div")).html(t.$errorContainer.html()),i.find("span.kv-error-close").remove(),i.find("ul").remove(),e.trim(i.text()).length?!0:!1)},getMsgSelected:function(e){var i=this,t=1===e?i.fileSingle:i.filePlural;return i.msgSelected.replace("{n}",e).replace("{files}",t)},renderThumbProgress:function(){return'<div class="file-thumb-progress hide">'+this.progressTemplate.replace(/\{percent}/g,"0")+"</div>"},renderFileFooter:function(e,i){var t,a,r=this,n=r.fileActionSettings,l=r.getLayoutTemplate("footer");return r.isUploadable?(t=l.replace(/\{actions}/g,r.renderFileActions(!0,!0,!1,!1,!1)),a=t.replace(/\{caption}/g,e).replace(/\{width}/g,i).replace(/\{progress}/g,r.renderThumbProgress()).replace(/\{indicator}/g,n.indicatorNew).replace(/\{indicatorTitle}/g,n.indicatorNewTitle)):a=l.replace(/\{actions}/g,"").replace(/\{caption}/g,e).replace(/\{progress}/g,"").replace(/\{width}/g,i).replace(/\{indicator}/g,"").replace(/\{indicatorTitle}/g,""),a=G(a,r.previewThumbTags)},renderFileActions:function(e,i,t,a,r){if(!e&&!i)return"";var n=this,l=a===!1?"":' data-url="'+a+'"',o=r===!1?"":' data-key="'+r+'"',s=n.getLayoutTemplate("actionDelete"),d="",c=n.getLayoutTemplate("actions"),p=n.otherActionButtons.replace(/\{dataKey}/g,o),u=n.fileActionSettings,f=t?u.removeClass+" disabled":u.removeClass;return s=s.replace(/\{removeClass}/g,f).replace(/\{removeIcon}/g,u.removeIcon).replace(/\{removeTitle}/g,u.removeTitle).replace(/\{dataUrl}/g,l).replace(/\{dataKey}/g,o),e&&(d=n.getLayoutTemplate("actionUpload").replace(/\{uploadClass}/g,u.uploadClass).replace(/\{uploadIcon}/g,u.uploadIcon).replace(/\{uploadTitle}/g,u.uploadTitle)),c.replace(/\{delete}/g,s).replace(/\{upload}/g,d).replace(/\{other}/g,p)},setThumbStatus:function(e,i){var t=this;if(t.showPreview){var a="indicator"+i,r=a+"Title",n="file-preview-"+i.toLowerCase(),l=e.find(".file-upload-indicator"),o=t.fileActionSettings;e.removeClass("file-preview-success file-preview-error file-preview-loading"),"Error"===i&&e.find(".kv-file-upload").attr("disabled",!0),l.html(o[a]),l.attr("title",o[r]),e.addClass(n)}},clearPreview:function(){var e=this,i=e.showUploadedThumbs?e.$preview.find(".file-preview-frame:not(.file-preview-success)"):e.$preview.find(".file-preview-frame");i.remove(),e.$preview.find(".file-preview-frame").length&&e.showPreview||e.resetUpload(),e.validateDefaultPreview()},initPreview:function(e){var i,t=this,a=t.initialCaption||"";return o.count(t.id)?(i=o.out(t.id),a=e&&t.initialCaption?t.initialCaption:i.caption,t.$preview.html(i.content),t.setCaption(a),void(V(i.content)||t.$container.removeClass("file-input-new"))):(t.clearPreview(),void(e?t.setCaption(a):t.initCaption()))},initPreviewDeletes:function(){var i=this,t=i.deleteExtraData||{},a=function(){var e=i.isUploadable?o.count(i.id):i.$element.get(0).files.length;0!==i.$preview.find(".kv-file-remove").length||e||(i.reset(),i.initialCaption="")};i.$preview.find(".kv-file-remove").each(function(){var r=e(this),n=r.data("url")||i.deleteUrl,s=r.data("key");if(!V(n)&&void 0!==s){var d,c,p,f,v=r.closest(".file-preview-frame"),g=o.data[i.id],m=v.data("fileindex");m=parseInt(m.replace("init_","")),p=V(g.config)&&V(g.config[m])?null:g.config[m],f=V(p)||V(p.extra)?t:p.extra,"function"==typeof f&&(f=f()),c={id:r.attr("id"),key:s,extra:f},d=e.extend(!0,{},{url:n,type:"POST",dataType:"json",data:e.extend(!0,{},{key:s},f),beforeSend:function(e){i.ajaxAborted=!1,i.raise("filepredelete",[s,e,f]),i.ajaxAborted?e.abort():(u(v,"file-uploading"),u(r,"disabled"))},success:function(e,t,n){var l,d;return V(e)||V(e.error)?(o.unset(i.id,m),l=o.count(i.id),d=l>0?i.getMsgSelected(l):"",i.raise("filedeleted",[s,n,f]),i.setCaption(d),v.removeClass("file-uploading").addClass("file-deleted"),void v.fadeOut("slow",function(){i.clearObjects(v),v.remove(),a(),l||0!==i.getFileStack().length||(i.setCaption(""),i.reset())})):(c.jqXHR=n,c.response=e,i.showError(e.error,c,"filedeleteerror"),v.removeClass("file-uploading"),r.removeClass("disabled"),void a())},error:function(e,t,r){var n=i.parseError(e,r);c.jqXHR=e,c.response={},i.showError(n,c,"filedeleteerror"),v.removeClass("file-uploading"),a()}},i.ajaxDeleteSettings),l(r,"click",function(){return i.validateMinCount()?void e.ajax(d):!1})}})},clearObjects:function(i){i.find("video audio").each(function(){this.pause(),e(this).remove()}),i.find("img object div").each(function(){e(this).remove()})},clearFileInput:function(){var i,t,a,r=this,n=r.$element;V(n.val())||(r.isIE9||r.isIE10?(i=n.closest("form"),t=e(document.createElement("form")),a=e(document.createElement("div")),n.before(a),i.length?i.after(t):a.after(t),t.append(n).trigger("reset"),a.before(n).remove(),t.remove()):n.val(""),r.fileInputCleared=!0)},resetUpload:function(){var e=this;e.uploadCache={content:[],config:[],tags:[],append:!0},e.uploadCount=0,e.uploadStatus={},e.uploadLog=[],e.uploadAsyncCount=0,e.loadedImages=[],e.totalImagesCount=0,e.$btnUpload.removeAttr("disabled"),e.setProgress(0),u(e.$progress,"hide"),e.resetErrors(!1),e.ajaxAborted=!1,e.ajaxRequests=[],e.resetCanvas()},resetCanvas:function(){var e=this;e.canvas&&e.imageCanvasContext&&e.imageCanvasContext.clearRect(0,0,e.canvas.width,e.canvas.height)},cancel:function(){var i,t=this,a=t.ajaxRequests,r=a.length;if(r>0)for(i=0;r>i;i+=1)t.cancelling=!0,a[i].abort();t.setProgressCancelled(),t.getThumbs().each(function(){var i=e(this),a=i.attr("data-fileindex");i.removeClass("file-uploading"),void 0!==t.filestack[a]&&(i.find(".kv-file-upload").removeClass("disabled").removeAttr("disabled"),i.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled")),t.unlock()})},cleanMemory:function(e){var i=e.is("img")?e.attr("src"):e.find("source").attr("src");t.revokeObjectURL(i)},hasInitialPreview:function(){var e=this;return!e.overwriteInitial&&o.count(e.id)},clear:function(){var i,t=this;t.$btnUpload.removeAttr("disabled"),t.getThumbs().find("video,audio,img").each(function(){t.cleanMemory(e(this))}),t.resetUpload(),t.clearStack(),t.clearFileInput(),t.resetErrors(!0),t.raise("fileclear"),t.hasInitialPreview()?(t.showFileIcon(),t.resetPreview(),t.initPreviewDeletes(),t.$container.removeClass("file-input-new")):(t.getThumbs().each(function(){t.clearObjects(e(this))}),t.isUploadable&&(o.data[t.id]={}),t.$preview.html(""),i=!t.overwriteInitial&&t.initialCaption.length>0?t.initialCaption:"",t.setCaption(i),t.$caption.attr("title",""),u(t.$container,"file-input-new"),t.validateDefaultPreview()),0===t.$container.find(".file-preview-frame").length&&(t.initCaption()||t.$captionContainer.find(".kv-caption-icon").hide()),t.hideFileIcon(),t.raise("filecleared"),t.$captionContainer.focus(),t.setFileDropZoneTitle()},resetPreview:function(){var e,i,t=this;o.count(t.id)?(e=o.out(t.id),t.$preview.html(e.content),i=t.initialCaption?t.initialCaption:e.caption,t.setCaption(i)):(t.clearPreview(),t.initCaption())},clearDefaultPreview:function(){var e=this;e.$preview.find(".file-default-preview").remove()},validateDefaultPreview:function(){var e=this;e.showPreview&&!V(e.defaultPreviewContent)&&(e.$preview.html('<div class="file-default-preview">'+e.defaultPreviewContent+"</div>"),e.$container.removeClass("file-input-new"))},resetPreviewThumbs:function(e){var i,t=this;return e?(t.clearPreview(),void t.clearStack()):void(t.hasInitialPreview()?(i=o.out(t.id),t.$preview.html(i.content),t.setCaption(i.caption),t.initPreviewDeletes()):t.clearPreview())},reset:function(){var e=this;e.resetPreview(),e.$container.find(".fileinput-filename").text(""),e.raise("filereset"),u(e.$container,"file-input-new"),(e.$preview.find(".file-preview-frame").length||e.isUploadable&&e.dropZoneEnabled)&&e.$container.removeClass("file-input-new"),e.setFileDropZoneTitle(),e.clearStack(),e.formdata={}},disable:function(){var e=this;e.isDisabled=!0,e.raise("filedisabled"),e.$element.attr("disabled","disabled"),e.$container.find(".kv-fileinput-caption").addClass("file-caption-disabled"),e.$container.find(".btn-file, .fileinput-remove, .fileinput-upload, .file-preview-frame button").attr("disabled",!0),e.initDragDrop()},enable:function(){var e=this;e.isDisabled=!1,e.raise("fileenabled"),e.$element.removeAttr("disabled"),e.$container.find(".kv-fileinput-caption").removeClass("file-caption-disabled"),e.$container.find(".btn-file, .fileinput-remove, .fileinput-upload, .file-preview-frame button").removeAttr("disabled"),e.initDragDrop()},getThumbs:function(e){return e=e||"",this.$preview.find(".file-preview-frame:not(.file-preview-initial)"+e)},getExtraData:function(e,i){var t=this,a=t.uploadExtraData;return"function"==typeof t.uploadExtraData&&(a=t.uploadExtraData(e,i)),a},uploadExtra:function(i,t){var a=this,r=a.getExtraData(i,t);0!==r.length&&e.each(r,function(e,i){a.formdata.append(e,i)})},setAsyncUploadStatus:function(i,t,a){var r=this,n=0;r.setProgress(t,e("#"+i).find(".file-thumb-progress")),r.uploadStatus[i]=t,e.each(r.uploadStatus,function(e,i){n+=i}),r.setProgress(Math.ceil(n/a))},initXhr:function(e,i,t){var a=this;return e.upload&&e.upload.addEventListener("progress",function(e){var r=0,n=e.loaded||e.position,l=e.total;e.lengthComputable&&(r=Math.ceil(n/l*100)),i?a.setAsyncUploadStatus(i,r,t):a.setProgress(Math.ceil(r))},!1),e},ajaxSubmit:function(i,t,a,r,n,l){var o,s=this;s.raise("filepreajax",[n,l]),s.uploadExtra(n,l),o=e.extend(!0,{},{xhr:function(){var i=e.ajaxSettings.xhr();return s.initXhr(i,n,s.getFileStack().length)},url:s.uploadUrl,type:"POST",dataType:"json",data:s.formdata,cache:!1,processData:!1,contentType:!1,beforeSend:i,success:t,complete:a,error:r},s.ajaxSettings),s.ajaxRequests.push(e.ajax(o))},initUploadSuccess:function(i,t,a){var r,n,l,s,d,c,p,u,f=this;f.showPreview&&"object"==typeof i&&!e.isEmptyObject(i)&&void 0!==i.initialPreview&&i.initialPreview.length>0&&(f.hasInitData=!0,d=i.initialPreview||[],c=i.initialPreviewConfig||[],p=i.initialPreviewThumbTags||[],r=void 0===i.append||i.append?!0:!1,f.overwriteInitial=!1,void 0!==t?a?(u=t.attr("data-fileindex"),f.uploadCache.content[u]=d[0],f.uploadCache.config[u]=c[0],f.uploadCache.tags[u]=p[0],f.uploadCache.append=r):(l=o.add(f.id,d,c[0],p[0],r),n=o.get(f.id,l,!1),s=e(n).hide(),t.after(s).fadeOut("slow",function(){s.fadeIn("slow").css("display:inline-block"),f.initPreviewDeletes(),f.clearFileInput(),t.remove()})):(o.set(f.id,d,c,p,r),f.initPreview(),f.initPreviewDeletes()))},initSuccessThumbs:function(){var i=this;i.showPreview&&i.getThumbs(".file-preview-success").each(function(){var t=e(this),a=t.find(".kv-file-remove");a.removeAttr("disabled"),l(a,"click",function(){var e=i.raise("filesuccessremove",[t.attr("id"),t.data("fileindex")]);i.cleanMemory(t),e!==!1&&t.fadeOut("slow",function(){t.remove(),i.$preview.find(".file-preview-frame").length||i.reset()})})})},checkAsyncComplete:function(){var i,t,a=this;for(t=0;t<a.filestack.length;t++)if(a.filestack[t]&&(i=a.previewInitId+"-"+t,-1===e.inArray(i,a.uploadLog)))return!1;return a.uploadAsyncCount===a.uploadLog.length;
},uploadSingle:function(i,t,a){var r,n,l,s,d,c,p,f,v,g,m=this,h=m.getFileStack().length,w=new FormData,b=m.previewInitId+"-"+i,C=m.filestack.length>0||!e.isEmptyObject(m.uploadExtraData),x={id:b,index:i};m.formdata=w,m.showPreview&&(n=e("#"+b+":not(.file-preview-initial)"),s=n.find(".kv-file-upload"),d=n.find(".kv-file-remove"),e("#"+b).find(".file-thumb-progress").removeClass("hide")),0===h||!C||s&&s.hasClass("disabled")||m.abort(x)||(g=function(e,i){m.updateStack(e,void 0),m.uploadLog.push(i),m.checkAsyncComplete()&&(m.fileBatchCompleted=!0)},l=function(){m.fileBatchCompleted&&setTimeout(function(){m.showPreview&&(o.set(m.id,m.uploadCache.content,m.uploadCache.config,m.uploadCache.tags,m.uploadCache.append),m.hasInitData&&(m.initPreview(),m.initPreviewDeletes())),m.unlock(),m.clearFileInput(),m.raise("filebatchuploadcomplete",[m.filestack,m.getExtraData()]),m.uploadCount=0,m.uploadStatus={},m.uploadLog=[],m.setProgress(100)},100)},c=function(t){r=m.getOutData(t),m.fileBatchCompleted=!1,m.showPreview&&(n.hasClass("file-preview-success")||(m.setThumbStatus(n,"Loading"),u(n,"file-uploading")),s.attr("disabled",!0),d.attr("disabled",!0)),a||m.lock(),m.raise("filepreupload",[r,b,i]),e.extend(!0,x,r),m.abort(x)&&(t.abort(),m.setProgressCancelled())},p=function(t,l,o){r=m.getOutData(o,t),e.extend(!0,x,r),setTimeout(function(){V(t)||V(t.error)?(m.showPreview&&(m.setThumbStatus(n,"Success"),s.hide(),m.initUploadSuccess(t,n,a)),m.raise("fileuploaded",[r,b,i]),a?g(i,b):m.updateStack(i,void 0)):(m.showUploadError(t.error,x),m.setPreviewError(n,i),a&&g(i,b))},100)},f=function(){setTimeout(function(){m.showPreview&&(s.removeAttr("disabled"),d.removeAttr("disabled"),n.removeClass("file-uploading")),a?l():(m.unlock(!1),m.clearFileInput()),m.initSuccessThumbs()},100)},v=function(r,l,o){var s=m.parseError(r,o,a?t[i].name:null);setTimeout(function(){a&&g(i,b),m.uploadStatus[b]=100,m.setPreviewError(n,i),e.extend(!0,x,m.getOutData(r)),m.showUploadError(s,x)},100)},w.append(m.uploadFileAttr,t[i],m.filenames[i]),w.append("file_id",i),m.ajaxSubmit(c,p,f,v,b,i))},uploadBatch:function(){var i,t,a,r,n,l=this,o=l.filestack,s=o.length,d={},c=l.filestack.length>0||!e.isEmptyObject(l.uploadExtraData);l.formdata=new FormData,0!==s&&c&&!l.abort(d)&&(n=function(){e.each(o,function(e){l.updateStack(e,void 0)}),l.clearFileInput()},i=function(i){l.lock();var t=l.getOutData(i);l.showPreview&&l.getThumbs().each(function(){var i=e(this),t=i.find(".kv-file-upload"),a=i.find(".kv-file-remove");i.hasClass("file-preview-success")||(l.setThumbStatus(i,"Loading"),u(i,"file-uploading")),t.attr("disabled",!0),a.attr("disabled",!0)}),l.raise("filebatchpreupload",[t]),l.abort(t)&&(i.abort(),l.setProgressCancelled())},t=function(i,t,a){var r=l.getOutData(a,i),o=l.getThumbs(),s=0,d=V(i)||V(i.errorkeys)?[]:i.errorkeys;V(i)||V(i.error)?(l.raise("filebatchuploadsuccess",[r]),n(),l.showPreview?(o.each(function(){var i=e(this),t=i.find(".kv-file-upload");i.find(".kv-file-upload").hide(),l.setThumbStatus(i,"Success"),i.removeClass("file-uploading"),t.removeAttr("disabled")}),l.initUploadSuccess(i)):l.reset()):(l.showPreview&&(o.each(function(){var i=e(this),t=i.find(".kv-file-remove"),a=i.find(".kv-file-upload");return i.removeClass("file-uploading"),a.removeAttr("disabled"),t.removeAttr("disabled"),0===d.length?void l.setPreviewError(i):(-1!==e.inArray(s,d)?l.setPreviewError(i):(i.find(".kv-file-upload").hide(),l.setThumbStatus(i,"Success"),l.updateStack(s,void 0)),void s++)}),l.initUploadSuccess(i)),l.showUploadError(i.error,r,"filebatchuploaderror"))},r=function(){l.setProgress(100),l.unlock(),l.initSuccessThumbs(),l.clearFileInput(),l.raise("filebatchuploadcomplete",[l.filestack,l.getExtraData()])},a=function(i,t,a){var r=l.getOutData(i),n=l.parseError(i,a);l.showUploadError(n,r,"filebatchuploaderror"),l.uploadFileCount=s-1,l.showPreview&&(l.getThumbs().each(function(){var i=e(this),t=i.attr("data-fileindex");i.removeClass("file-uploading"),void 0!==l.filestack[t]&&l.setPreviewError(i)}),l.getThumbs().removeClass("file-uploading"),l.getThumbs(" .kv-file-upload").removeAttr("disabled"),l.getThumbs(" .kv-file-delete").removeAttr("disabled"))},e.each(o,function(e,i){V(o[e])||l.formdata.append(l.uploadFileAttr,i,l.filenames[e])}),l.ajaxSubmit(i,t,r,a))},uploadExtraOnly:function(){var e,i,t,a,r=this,n={};r.formdata=new FormData,r.abort(n)||(e=function(e){r.lock();var i=r.getOutData(e);r.raise("filebatchpreupload",[i]),r.setProgress(50),n.data=i,n.xhr=e,r.abort(n)&&(e.abort(),r.setProgressCancelled())},i=function(e,i,t){var a=r.getOutData(t,e);V(e)||V(e.error)?(r.raise("filebatchuploadsuccess",[a]),r.clearFileInput(),r.initUploadSuccess(e)):r.showUploadError(e.error,a,"filebatchuploaderror")},t=function(){r.setProgress(100),r.unlock(),r.clearFileInput(),r.raise("filebatchuploadcomplete",[r.filestack,r.getExtraData()])},a=function(e,i,t){var a=r.getOutData(e),l=r.parseError(e,t);n.data=a,r.showUploadError(l,a,"filebatchuploaderror")},r.ajaxSubmit(e,i,t,a))},upload:function(){var i,t,a,r=this,n=r.getFileStack().length,l={},o=!e.isEmptyObject(r.getExtraData());if(r.minFileCount>0&&r.getFileCount(n)<r.minFileCount)return void r.noFilesError(l);if(r.isUploadable&&!r.isDisabled&&(0!==n||o)){if(r.resetUpload(),r.$progress.removeClass("hide"),r.uploadCount=0,r.uploadStatus={},r.uploadLog=[],r.lock(),r.setProgress(2),0===n&&o)return void r.uploadExtraOnly();if(a=r.filestack.length,r.hasInitData=!1,r.uploadAsync){for(t=r.getOutData(),r.raise("filebatchpreupload",[t]),r.fileBatchCompleted=!1,r.uploadCache={content:[],config:[],tags:[],append:!0},r.uploadAsyncCount=r.getFileStack().length,i=0;a>i;i++)r.uploadCache.content[i]=null,r.uploadCache.config[i]=null,r.uploadCache.tags[i]=null;for(i=0;a>i;i++)void 0!==r.filestack[i]&&r.uploadSingle(i,r.filestack,!0)}else r.uploadBatch()}},initFileActions:function(){var i=this;i.showPreview&&(i.$preview.find(".kv-file-remove").each(function(){var t,a,r,n,s=e(this),d=s.closest(".file-preview-frame"),c=d.attr("id"),p=d.attr("data-fileindex");l(s,"click",function(){return n=i.raise("filepreremove",[c,p]),n!==!1&&i.validateMinCount()?(t=d.hasClass("file-preview-error"),i.cleanMemory(d),void d.fadeOut("slow",function(){i.updateStack(p,void 0),i.clearObjects(d),d.remove(),c&&t&&i.$errorContainer.find('li[data-file-id="'+c+'"]').fadeOut("fast",function(){e(this).remove(),i.errorsExist()||i.resetErrors()});var n=i.getFileStack(!0),l=n.length,s=o.count(i.id),u=i.showPreview&&i.$preview.find(".file-preview-frame").length;i.clearFileInput(),0!==l||0!==s||u?(a=s+l,r=a>1?i.getMsgSelected(a):n[0]?i.getFileNames()[0]:"",i.setCaption(r)):i.reset(),i.raise("fileremoved",[c,p])})):!1})}),i.$preview.find(".kv-file-upload").each(function(){var t=e(this);l(t,"click",function(){var e=t.closest(".file-preview-frame"),a=e.attr("data-fileindex");e.hasClass("file-preview-error")||i.uploadSingle(a,i.filestack,!1)})}))},hideFileIcon:function(){this.overwriteInitial&&this.$captionContainer.find(".kv-caption-icon").hide()},showFileIcon:function(){this.$captionContainer.find(".kv-caption-icon").show()},addError:function(e){var i=this,t=i.$errorContainer;e&&t.length&&(t.html(i.errorCloseButton+e),l(t.find(".kv-error-close"),"click",function(){t.fadeOut("slow")}))},resetErrors:function(e){var i=this,t=i.$errorContainer;i.isError=!1,i.$container.removeClass("has-error"),t.html(""),e?t.fadeOut("slow"):t.hide()},showFolderError:function(e){var i,t=this,a=t.$errorContainer;e&&(i=t.msgFoldersNotAllowed.replace(/\{n}/g,e),t.addError(i),u(t.$container,"has-error"),a.fadeIn(800),t.raise("filefoldererror",[e,i]))},showUploadError:function(e,i,t){var a=this,r=a.$errorContainer,n=t||"fileuploaderror",l=i&&i.id?'<li data-file-id="'+i.id+'">'+e+"</li>":"<li>"+e+"</li>";return 0===r.find("ul").length?a.addError("<ul>"+l+"</ul>"):r.find("ul").append(l),r.fadeIn(800),a.raise(n,[i,e]),a.$container.removeClass("file-input-new"),u(a.$container,"has-error"),!0},showError:function(e,i,t){var a=this,r=a.$errorContainer,n=t||"fileerror";return i=i||{},i.reader=a.reader,a.addError(e),r.fadeIn(800),a.raise(n,[i,e]),a.isUploadable||a.clearFileInput(),a.$container.removeClass("file-input-new"),u(a.$container,"has-error"),a.$btnUpload.attr("disabled",!0),!0},noFilesError:function(e){var i=this,t=i.minFileCount>1?i.filePlural:i.fileSingle,a=i.msgFilesTooLess.replace("{n}",i.minFileCount).replace("{files}",t),r=i.$errorContainer;i.addError(a),i.isError=!0,i.updateFileDetails(0),r.fadeIn(800),i.raise("fileerror",[e,a]),i.clearFileInput(),u(i.$container,"has-error")},errorHandler:function(e,i){var t=this,a=e.target.error;a.code===a.NOT_FOUND_ERR?t.showError(t.msgFileNotFound.replace("{name}",i)):a.code===a.SECURITY_ERR?t.showError(t.msgFileSecured.replace("{name}",i)):a.code===a.NOT_READABLE_ERR?t.showError(t.msgFileNotReadable.replace("{name}",i)):a.code===a.ABORT_ERR?t.showError(t.msgFilePreviewAborted.replace("{name}",i)):t.showError(t.msgFilePreviewError.replace("{name}",i))},parseFileType:function(e){var i,t,a,r,n=this;for(r=0;r<W.length;r+=1)if(a=W[r],i=X(a,n.fileTypeSettings)?n.fileTypeSettings[a]:_[a],t=i(e.type,e.name)?a:"",!V(t))return t;return"other"},previewDefault:function(i,a,r){if(this.showPreview){var n=this,l="",o=i?i.name:"",s=t.createObjectURL(i),d=a.slice(a.lastIndexOf("-")+1),c=n.previewSettings.other||q.other,p=n.renderFileFooter(i.name,c.width),u=n.parseFilePreviewIcon(n.getPreviewTemplate("other"),o);r===!0&&(n.isUploadable||(p+='<div class="file-other-error" title="'+n.fileActionSettings.indicatorErrorTitle+'">'+n.fileActionSettings.indicatorError+"</div>")),n.clearDefaultPreview(),n.$preview.append("\n"+u.replace(/\{previewId}/g,a).replace(/\{frameClass}/g,l).replace(/\{fileindex}/g,d).replace(/\{caption}/g,n.slug(i.name)).replace(/\{width}/g,c.width).replace(/\{height}/g,c.height).replace(/\{type}/g,i.type).replace(/\{data}/g,s).replace(/\{footer}/g,p)),r===!0&&n.isUploadable&&n.setThumbStatus(e("#"+a),"Error")}},previewFile:function(e,i,t,a,r){if(this.showPreview){var n,l,o,s=this,d=s.parseFileType(i),c=i?i.name:"",p=s.slug(c),u=s.allowedPreviewTypes,f=s.allowedPreviewMimeTypes,v=s.getPreviewTemplate(d),g=u&&u.indexOf(d)>=0,m=X(d,s.previewSettings)?s.previewSettings[d]:q[d],h=f&&-1!==f.indexOf(i.type),w=s.renderFileFooter(p,m.width),b="",C=a.slice(a.lastIndexOf("-")+1);g||h?(v=s.parseFilePreviewIcon(v,c.split(".").pop()),"text"===d?(l=Y(t.target.result),o="text-"+Q(),n=v.replace(/\{zoom}/g,s.getLayoutTemplate("zoom")),b=s.getLayoutTemplate("modal").replace("{id}",o).replace(/\{title}/g,p).replace(/\{body}/g,l).replace(/\{heading}/g,s.msgZoomModalHeading),n=n.replace(/\{previewId}/g,a).replace(/\{caption}/g,p).replace(/\{width}/g,m.width).replace(/\{height}/g,m.height).replace(/\{frameClass}/g,"").replace(/\{zoomInd}/g,s.zoomIndicator).replace(/\{footer}/g,w).replace(/\{fileindex}/g,C).replace(/\{type}/g,i.type).replace(/\{zoomTitle}/g,s.msgZoomTitle).replace(/\{dialog}/g,"$('#"+o+"').modal('show')").replace(/\{data}/g,l)+b):n=v.replace(/\{previewId}/g,a).replace(/\{caption}/g,p).replace(/\{frameClass}/g,"").replace(/\{type}/g,i.type).replace(/\{fileindex}/g,C).replace(/\{width}/g,m.width).replace(/\{height}/g,m.height).replace(/\{footer}/g,w).replace(/\{data}/g,r),s.clearDefaultPreview(),s.$preview.append("\n"+n),s.validateImage(e,a,p,i.type)):s.previewDefault(i,a)}},slugDefault:function(e){return V(e)?"":String(e).replace(/[\-\[\]\/\{}:;#%=\(\)\*\+\?\\\^\$\|<>&"']/g,"_")},readFiles:function(i){this.reader=new FileReader;var r,n=this,l=n.$element,o=n.$preview,s=n.reader,d=n.$previewContainer,c=n.$previewStatus,p=n.msgLoading,u=n.msgProgress,f=n.previewInitId,v=i.length,g=n.fileTypeSettings,m=n.filestack.length,h=function(t,a,l,o){var s=e.extend(!0,{},n.getOutData({},{},i),{id:l,index:o}),d={id:l,index:o,file:a,files:i};return n.previewDefault(a,l,!0),n.isUploadable&&n.addToStack(void 0),setTimeout(r(o+1),100),n.initFileActions(),n.removeFromPreviewOnError&&e("#"+l).remove(),n.isUploadable?n.showUploadError(t,s):n.showError(t,d)};n.loadedImages=[],n.totalImagesCount=0,e.each(i,function(e,i){var t=n.fileTypeSettings.image||_.image;t&&t(i.type)&&n.totalImagesCount++}),r=function(e){if(V(l.attr("multiple"))&&(v=1),e>=v)return n.isUploadable&&n.filestack.length>0?n.raise("filebatchselected",[n.getFileStack()]):n.raise("filebatchselected",[i]),d.removeClass("file-thumb-loading"),void c.html("");var w,b,C,x,y,T,F=m+e,E=f+"-"+F,I=i[e],$=n.slug(I.name),k=(I.size||0)/1e3,P="",S=t.createObjectURL(I),D=0,U=n.allowedFileTypes,A=V(U)?"":U.join(", "),j=n.allowedFileExtensions,L=V(j)?"":j.join(", ");if(V(j)||(P=new RegExp("\\.("+j.join("|")+")$","i")),k=k.toFixed(2),n.maxFileSize>0&&k>n.maxFileSize)return x=n.msgSizeTooLarge.replace("{name}",$).replace("{size}",k).replace("{maxSize}",n.maxFileSize),void(n.isError=h(x,I,E,e));if(!V(U)&&K(U)){for(C=0;C<U.length;C+=1)y=U[C],b=g[y],T=void 0!==b&&b(I.type,$),D+=V(T)?0:T.length;if(0===D)return x=n.msgInvalidFileType.replace("{name}",$).replace("{types}",A),void(n.isError=h(x,I,E,e))}return 0!==D||V(j)||!K(j)||V(P)||(T=a($,P),D+=V(T)?0:T.length,0!==D)?n.showPreview?(o.length>0&&void 0!==FileReader?(c.html(p.replace("{index}",e+1).replace("{files}",v)),d.addClass("file-thumb-loading"),s.onerror=function(e){n.errorHandler(e,$)},s.onload=function(i){n.previewFile(e,I,i,E,S),n.initFileActions()},s.onloadend=function(){x=u.replace("{index}",e+1).replace("{files}",v).replace("{percent}",50).replace("{name}",$),setTimeout(function(){c.html(x),n.updateFileDetails(v),r(e+1)},100),n.raise("fileloaded",[I,E,e,s])},s.onprogress=function(i){if(i.lengthComputable){var t=i.loaded/i.total*100,a=Math.ceil(t);x=u.replace("{index}",e+1).replace("{files}",v).replace("{percent}",a).replace("{name}",$),setTimeout(function(){c.html(x)},100)}},w=X("text",g)?g.text:_.text,w(I.type,$)?s.readAsText(I,n.textEncoding):s.readAsArrayBuffer(I)):(n.previewDefault(I,E),setTimeout(function(){r(e+1),n.updateFileDetails(v)},100),n.raise("fileloaded",[I,E,e,s])),void n.addToStack(I)):(n.addToStack(I),setTimeout(r(e+1),100),void n.raise("fileloaded",[I,E,e,s])):(x=n.msgInvalidFileExtension.replace("{name}",$).replace("{extensions}",L),void(n.isError=h(x,I,E,e)))},r(0),n.updateFileDetails(v,!1)},updateFileDetails:function(e){var i=this,t=i.$element,a=i.getFileStack(),r=t[0].files[0]&&t[0].files[0].name||a.length&&a[0].name||"",n=i.slug(r),l=i.isUploadable?a.length:e,s=o.count(i.id)+l,d=l>1?i.getMsgSelected(s):n;i.isError?(i.$previewContainer.removeClass("file-thumb-loading"),i.$previewStatus.html(""),i.$captionContainer.find(".kv-caption-icon").hide()):i.showFileIcon(),i.setCaption(d,i.isError),i.$container.removeClass("file-input-new file-input-ajax-new"),1===arguments.length&&i.raise("fileselect",[e,n]),o.count(i.id)&&i.initPreviewDeletes()},validateMinCount:function(){var e=this,i=e.isUploadable?e.getFileStack().length:e.$element.get(0).files.length;return e.validateInitialCount&&e.minFileCount>0&&e.getFileCount(i-1)<e.minFileCount?(e.noFilesError({}),!1):!0},getFileCount:function(e){var i=this,t=0;return i.validateInitialCount&&!i.overwriteInitial&&(t=o.count(i.id),e+=t),e},change:function(i){var t=this,a=t.$element;if(!t.isUploadable&&V(a.val())&&t.fileInputCleared)return void(t.fileInputCleared=!1);t.fileInputCleared=!1;var r,n,l,s,d,c,p=arguments.length>1,u=t.isUploadable,f=0,v=p?i.originalEvent.dataTransfer.files:a.get(0).files,g=t.filestack.length,m=V(a.attr("multiple")),h=m&&g>0,w=0,b=function(i,a,r,n){var l=e.extend(!0,{},t.getOutData({},{},v),{id:r,index:n}),o={id:r,index:n,file:a,files:v};return t.isUploadable?t.showUploadError(i,l):t.showError(i,o)};if(t.reader=null,t.resetUpload(),t.hideFileIcon(),t.isUploadable&&t.$container.find(".file-drop-zone ."+t.dropZoneTitleClass).remove(),p)for(r=[];v[f];)s=v[f],s.type||s.size%4096!==0?r.push(s):w++,f++;else r=void 0===i.target.files?i.target&&i.target.value?[{name:i.target.value.replace(/^.+\\/,"")}]:[]:i.target.files;if(V(r)||0===r.length)return u||t.clear(),t.showFolderError(w),void t.raise("fileselectnone");if(t.resetErrors(),c=r.length,l=t.getFileCount(t.isUploadable?t.getFileStack().length+c:c),t.maxFileCount>0&&l>t.maxFileCount){if(!t.autoReplace||c>t.maxFileCount)return d=t.autoReplace&&c>t.maxFileCount?c:l,n=t.msgFilesTooMany.replace("{m}",t.maxFileCount).replace("{n}",d),t.isError=b(n,null,null,null),t.$captionContainer.find(".kv-caption-icon").hide(),t.setCaption("",!0),void t.$container.removeClass("file-input-new file-input-ajax-new");l>t.maxFileCount&&t.resetPreviewThumbs(u)}else!u||h?(t.resetPreviewThumbs(!1),h&&t.clearStack()):!u||0!==g||o.count(t.id)&&!t.overwriteInitial||t.resetPreviewThumbs(!0);t.isPreviewable?t.readFiles(r):t.updateFileDetails(1),t.showFolderError(w)},getFileName:function(e){return e&&e.name?this.slug(e.name):void 0},getFileNames:function(e){var i=this;return i.filenames.filter(function(i){return e?void 0!==i:void 0!==i&&null!==i})},getFileStack:function(e){var i=this;return i.filestack.filter(function(i){return e?void 0!==i:void 0!==i&&null!==i})},clearStack:function(){var e=this;e.filestack=[],e.filenames=[]},updateStack:function(e,i){var t=this;t.filestack[e]=i,t.filenames[e]=t.getFileName(i)},addToStack:function(e){var i=this;i.filestack.push(e),i.filenames.push(i.getFileName(e))},setPreviewError:function(e,i,t){var a=this;i&&a.updateStack(i,t),a.removeFromPreviewOnError?e.remove():a.setThumbStatus(e,"Error")},checkDimensions:function(e,i,t,a,r,n,l){var o,s,d,c,p=this,u="Small"===i?"min":"max",f=p[u+"Image"+n];!V(f)&&t.length&&(d=t[0],s="Width"===n?d.naturalWidth||d.width:d.naturalHeight||d.height,c="Small"===i?s>=f:f>=s,c||(o=p["msgImage"+n+i].replace("{name}",r).replace("{size}",f),p.showUploadError(o,l),p.setPreviewError(a,e,null)))},validateImage:function(e,i,a,r){var n,o,s,d=this,c=d.$preview,p=c.find("#"+i),u=p.find("img");a=a||"Untitled",u.length&&l(u,"load",function(){o=p.width(),s=c.width(),o>s&&(u.css("width","100%"),p.css("width","97%")),n={ind:e,id:i},d.checkDimensions(e,"Small",u,p,a,"Width",n),d.checkDimensions(e,"Small",u,p,a,"Height",n),d.resizeImage||(d.checkDimensions(e,"Large",u,p,a,"Width",n),d.checkDimensions(e,"Large",u,p,a,"Height",n)),d.raise("fileimageloaded",[i]),d.loadedImages.push({ind:e,img:u,thumb:p,pid:i,typ:r}),d.validateAllImages(),t.revokeObjectURL(u.attr("src"))})},validateAllImages:function(){var e,i,t,a,r,n,l,o=this,s={};if(o.loadedImages.length===o.totalImagesCount&&(o.raise("fileimagesloaded"),o.resizeImage)){for(l=o.isUploadable?o.showUploadError:o.showError,e=0;e<o.loadedImages.length;e++)i=o.loadedImages[e],t=i.img,a=i.thumb,r=i.pid,n=i.ind,s={id:r,index:n},o.getResizedImage(t[0],i.typ,r,n)||(l(o.msgImageResizeError,s,"fileimageresizeerror"),o.setPreviewError(a,n));o.raise("fileimagesresized")}},getResizedImage:function(e,i,t,a){var r,n,l=this,o=e.naturalWidth,s=e.naturalHeight,d=1,c=l.maxImageWidth||o,p=l.maxImageHeight||s,u=o&&s,f=l.imageCanvas,v=l.imageCanvasContext;if(!u)return!1;if(o===c&&s===p)return!0;i=i||l.resizeDefaultImageType,r=o>c,n=s>p,d="width"===l.resizePreference?r?c/o:n?p/s:1:n?p/s:r?c/o:1,l.resetCanvas(),o*=d,s*=d,f.width=o,f.height=s;try{return v.drawImage(e,0,0,o,s),f.toBlob(function(e){l.raise("fileimageresized",[t,a]),l.filestack[a]=e},i,l.resizeQuality),!0}catch(g){return!1}},initCaption:function(){var e=this,i=e.initialCaption||"";return e.overwriteInitial||V(i)?(e.$caption.html(""),!1):(e.setCaption(i),!0)},setCaption:function(i,t){var a,r,n,l,o=this,s=o.getFileStack();if(o.$caption.length){if(t)a=e("<div>"+o.msgValidationError+"</div>").text(),n=s.length,l=n?1===n&&s[0]?o.getFileNames()[0]:o.getMsgSelected(n):o.getMsgSelected(o.msgNo),r='<span class="'+o.msgValidationErrorClass+'">'+o.msgValidationErrorIcon+(V(i)?l:i)+"</span>";else{if(V(i))return;a=e("<div>"+i+"</div>").text(),r=o.getLayoutTemplate("icon")+a}o.$caption.html(r),o.$caption.attr("title",a),o.$captionContainer.find(".file-caption-ellipsis").attr("title",a)}},initBrowse:function(e){var i=this;i.$btnFile=e.find(".btn-file"),i.$btnFile.append(i.$element)},createContainer:function(){var i=this,t=e(document.createElement("div")).attr({"class":"file-input file-input-new"}).html(i.renderMain());return i.$element.before(t),i.initBrowse(t),t},refreshContainer:function(){var e=this,i=e.$container;i.before(e.$element),i.html(e.renderMain()),e.initBrowse(i)},renderMain:function(){var e=this,i=e.isUploadable&&e.dropZoneEnabled?" file-drop-zone":"file-drop-disabled",t=e.showClose?e.getLayoutTemplate("close"):"",a=e.showPreview?e.getLayoutTemplate("preview").replace(/\{class}/g,e.previewClass).replace(/\{dropClass}/g,i):"",r=e.isDisabled?e.captionClass+" file-caption-disabled":e.captionClass,n=e.captionTemplate.replace(/\{class}/g,r+" kv-fileinput-caption");return e.mainTemplate.replace(/\{class}/g,e.mainClass).replace(/\{preview}/g,a).replace(/\{close}/g,t).replace(/\{caption}/g,n).replace(/\{upload}/g,e.renderButton("upload")).replace(/\{remove}/g,e.renderButton("remove")).replace(/\{cancel}/g,e.renderButton("cancel")).replace(/\{browse}/g,e.renderButton("browse"))},renderButton:function(e){var i=this,t=i.getLayoutTemplate("btnDefault"),a=i[e+"Class"],r=i[e+"Title"],n=i[e+"Icon"],l=i[e+"Label"],o=i.isDisabled?" disabled":"",s="button";switch(e){case"remove":if(!i.showRemove)return"";break;case"cancel":if(!i.showCancel)return"";a+=" hide";break;case"upload":if(!i.showUpload)return"";i.isUploadable&&!i.isDisabled?t=i.getLayoutTemplate("btnLink").replace("{href}",i.uploadUrl):s="submit";break;case"browse":t=i.getLayoutTemplate("btnBrowse");break;default:return""}return a+="browse"===e?" btn-file":" fileinput-"+e+" fileinput-"+e+"-button",V(l)||(l=' <span class="'+i.buttonLabelClass+'">'+l+"</span>"),t.replace("{type}",s).replace("{css}",a).replace("{title}",r).replace("{status}",o).replace("{icon}",n).replace("{label}",l)}},e.fn.fileinput=function(i){if(d()||r(9)){var t=Array.apply(null,arguments),a=[];switch(t.shift(),this.each(function(){var r,n=e(this),l=n.data("fileinput"),o="object"==typeof i&&i,s=o.language||n.data("language")||"en",d={};l||("en"===s||V(e.fn.fileinputLocales[s])||(d=e.fn.fileinputLocales[s]),r=e.extend(!0,{},e.fn.fileinput.defaults,e.fn.fileinputLocales.en,d,o,n.data()),l=new ee(this,r),n.data("fileinput",l)),"string"==typeof i&&a.push(l[i].apply(l,t))}),a.length){case 0:return this;case 1:return a[0];default:return a}}},e.fn.fileinput.defaults={language:"en",showCaption:!0,showPreview:!0,showRemove:!0,showUpload:!0,showCancel:!0,showClose:!0,showUploadedThumbs:!0,autoReplace:!1,mainClass:"",previewClass:"",captionClass:"",mainTemplate:null,initialCaption:"",initialPreview:[],initialPreviewDelimiter:"*$$*",initialPreviewConfig:[],initialPreviewThumbTags:[],previewThumbTags:{},initialPreviewShowDelete:!0,removeFromPreviewOnError:!1,deleteUrl:"",deleteExtraData:{},overwriteInitial:!0,layoutTemplates:Z,previewTemplates:H,allowedPreviewTypes:W,allowedPreviewMimeTypes:null,allowedFileTypes:null,allowedFileExtensions:null,defaultPreviewContent:null,customLayoutTags:{},customPreviewTags:{},previewSettings:q,fileTypeSettings:_,previewFileIcon:'<i class="glyphicon glyphicon-file"></i>',previewFileIconClass:"file-icon-4x",previewFileIconSettings:{},previewFileExtSettings:{},buttonLabelClass:"hidden-xs",browseIcon:'<i class="glyphicon glyphicon-folder-open"></i>',browseClass:"btn btn-primary",removeIcon:'<i class="glyphicon glyphicon-trash"></i>',removeClass:"btn btn-default",cancelIcon:'<i class="glyphicon glyphicon-ban-circle"></i>',cancelClass:"btn btn-default",uploadIcon:'<i class="glyphicon glyphicon-upload"></i>',uploadClass:"btn btn-default",uploadUrl:null,uploadAsync:!0,uploadExtraData:{},minImageWidth:null,minImageHeight:null,maxImageWidth:null,maxImageHeight:null,resizeImage:!1,resizePreference:"width",resizeQuality:.92,resizeDefaultImageType:"image/jpeg",maxFileSize:0,minFileCount:0,maxFileCount:0,validateInitialCount:!1,msgValidationErrorClass:"text-danger",msgValidationErrorIcon:'<i class="glyphicon glyphicon-exclamation-sign"></i> ',msgErrorClass:"file-error-message",progressThumbClass:"progress-bar progress-bar-success progress-bar-striped active",progressClass:"progress-bar progress-bar-success progress-bar-striped active",progressCompleteClass:"progress-bar progress-bar-success",progressErrorClass:"progress-bar progress-bar-danger",previewFileType:"image",zoomIndicator:'<i class="glyphicon glyphicon-zoom-in"></i>',elCaptionContainer:null,elCaptionText:null,elPreviewContainer:null,elPreviewImage:null,elPreviewStatus:null,elErrorContainer:null,errorCloseButton:'<span class="close kv-error-close">&times;</span>',slugCallback:null,dropZoneEnabled:!0,dropZoneTitleClass:"file-drop-zone-title",fileActionSettings:{},otherActionButtons:"",textEncoding:"UTF-8",ajaxSettings:{},ajaxDeleteSettings:{},showAjaxErrorDetails:!0},e.fn.fileinputLocales.en={fileSingle:"file",filePlural:"files",browseLabel:"Browse &hellip;",removeLabel:"Remove",removeTitle:"Clear selected files",cancelLabel:"Cancel",cancelTitle:"Abort ongoing upload",uploadLabel:"Upload",uploadTitle:"Upload selected files",msgNo:"No",msgCancelled:"Cancelled",msgZoomTitle:"View details",msgZoomModalHeading:"Detailed Preview",msgSizeTooLarge:'File "{name}" (<b>{size} KB</b>) exceeds maximum allowed upload size of <b>{maxSize} KB</b>.',msgFilesTooLess:"You must select at least <b>{n}</b> {files} to upload.",msgFilesTooMany:"Number of files selected for upload <b>({n})</b> exceeds maximum allowed limit of <b>{m}</b>.",msgFileNotFound:'File "{name}" not found!',msgFileSecured:'Security restrictions prevent reading the file "{name}".',msgFileNotReadable:'File "{name}" is not readable.',msgFilePreviewAborted:'File preview aborted for "{name}".',msgFilePreviewError:'An error occurred while reading the file "{name}".',msgInvalidFileType:'Invalid type for file "{name}". Only "{types}" files are supported.',msgInvalidFileExtension:'Invalid extension for file "{name}". Only "{extensions}" files are supported.',msgUploadAborted:"The file upload was aborted",msgValidationError:"Validation Error",msgLoading:"Loading file {index} of {files} &hellip;",msgProgress:"Loading file {index} of {files} - {name} - {percent}% completed.",msgSelected:"{n} {files} selected",msgFoldersNotAllowed:"Drag & drop files only! {n} folder(s) dropped were skipped.",msgImageWidthSmall:'Width of image file "{name}" must be at least {size} px.',msgImageHeightSmall:'Height of image file "{name}" must be at least {size} px.',msgImageWidthLarge:'Width of image file "{name}" cannot exceed {size} px.',msgImageHeightLarge:'Height of image file "{name}" cannot exceed {size} px.',msgImageResizeError:"Could not get the image dimensions to resize.",msgImageResizeException:"Error while resizing the image.<pre>{errors}</pre>",dropZoneTitle:"Drag & drop files here &hellip;"},e.fn.fileinput.Constructor=ee,e(document).ready(function(){var i=e("input.file[type=file]");i.length&&i.fileinput()})});