/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueFloat;

public class CssNumber
extends CssValue
implements CssValueFloat {
    ApplContext ac;
    Float value;
    boolean isInt = false;

    public CssNumber() {
    }

    public CssNumber(ApplContext ac, float value) {
        this.ac = ac;
        this.value = new Float(value);
    }

    public CssNumber(float value) {
        this.value = new Float(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String s, ApplContext ac) {
        try {
            new Integer(s);
            this.isInt = true;
        }
        catch (NumberFormatException e) {
            this.isInt = false;
        }
        finally {
            this.value = new Float(s);
        }
        this.ac = ac;
    }

    public Object get() {
        if (this.isInt) {
            return new Integer(this.value.intValue());
        }
        return this.value;
    }

    public float getValue() {
        return this.value.floatValue();
    }

    public int getInt() throws InvalidParamException {
        if (this.isInt) {
            return this.value.intValue();
        }
        throw new InvalidParamException("invalid-color", this.ac);
    }

    public boolean isInteger() {
        return this.isInt;
    }

    public CssLength getLength() throws InvalidParamException {
        float num = this.value.floatValue();
        if (num == 0.0f) {
            return new CssLength();
        }
        throw new InvalidParamException("zero", "length", this.ac);
    }

    public CssPercentage getPercentage() throws InvalidParamException {
        float num = this.value.floatValue();
        if (num == 0.0f) {
            return new CssPercentage();
        }
        throw new InvalidParamException("zero", this.value.toString(), "percentage", this.ac);
    }

    public CssTime getTime() throws InvalidParamException {
        float num = this.value.floatValue();
        if (num == 0.0f) {
            return new CssTime();
        }
        throw new InvalidParamException("zero", this.value.toString(), "time", this.ac);
    }

    public CssAngle getAngle() throws InvalidParamException {
        float num = this.value.floatValue();
        if (num == 0.0f) {
            return new CssAngle();
        }
        throw new InvalidParamException("zero", this.value.toString(), "angle", this.ac);
    }

    public CssFrequency getFrequency() throws InvalidParamException {
        float num = this.value.floatValue();
        if (num == 0.0f) {
            return new CssFrequency();
        }
        throw new InvalidParamException("zero", this.value.toString(), "frequency", this.ac);
    }

    public String toString() {
        if (this.isInt) {
            return this.value.intValue() + "";
        }
        return this.value.toString();
    }

    public boolean equals(Object value) {
        return value instanceof CssNumber && this.value.equals(((CssNumber)value).value);
    }
}

