/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssFouffa;
import org.w3c.css.parser.Errors;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

public class Frame {
    public ApplContext ac;
    private Errors errors;
    private Warnings warnings;
    private CssFouffa cssFouffa;
    private String sourceFile;
    private int line;

    public Frame(CssFouffa cssFouffa, String sourceFile) {
        this.sourceFile = sourceFile;
        this.cssFouffa = cssFouffa;
        this.errors = new Errors();
        this.warnings = new Warnings();
    }

    public Frame(CssFouffa cssFouffa, String sourceFile, int beginLine) {
        this.sourceFile = sourceFile;
        this.cssFouffa = cssFouffa;
        this.line = beginLine;
        this.errors = new Errors();
        this.warnings = new Warnings();
    }

    public void addError(CssError error) {
        error.sourceFile = this.getSourceFile();
        error.line = this.getLine();
        this.errors.addError(error);
    }

    public Errors getErrors() {
        return this.errors;
    }

    public void addWarning(String warningMessage) {
        this.warnings.addWarning(new Warning(this.getSourceFile(), this.getLine(), warningMessage, 0, this.ac));
    }

    public void addWarning(String warningMessage, String message) {
        this.warnings.addWarning(new Warning(this.getSourceFile(), this.getLine(), warningMessage, 0, message, "", this.ac));
    }

    public void addWarning(String warningMessage, String message1, String message2) {
        this.warnings.addWarning(new Warning(this.getSourceFile(), this.getLine(), warningMessage, 0, message1, message2, this.ac));
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public int getBeginLine() {
        return this.line;
    }

    public int getLine() {
        return this.line + this.cssFouffa.token.beginLine;
    }

    public void join(Frame frame) {
        this.errors.addErrors(frame.errors);
        this.warnings.addWarnings(frame.warnings);
    }
}

