/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetGenerator;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.SortedHashtable;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

public final class StyleSheetGeneratorHTML
implements CssPrinterStyle {
    StyleSheet style;
    SortedHashtable items;
    Warnings warnings;
    Errors errors;
    ApplContext ac;
    private CssSelectors selector;
    private CssProperty property;
    private PrintWriter out;
    private int warningLevel;
    private Utf8Properties general;
    private static Utf8Properties availableFormat;
    private static Utf8Properties availablePropertiesURL;
    private static Hashtable formats;

    public StyleSheetGeneratorHTML(ApplContext ac, String title, StyleSheet style, String document, int warningLevel) {
        this.ac = ac;
        this.style = style;
        this.general = new Utf8Properties(this.setDocumentBase(StyleSheetGeneratorHTML.getDocumentName(ac, document)));
        this.general.put("file-title", title);
        this.warnings = style.getWarnings();
        this.errors = style.getErrors();
        this.items = (SortedHashtable)style.getRules();
        this.warningLevel = warningLevel;
        this.general.put("errors-count", Integer.toString(this.errors.getErrorCount()));
        this.general.put("warnings-count", Integer.toString(this.warnings.getWarningCount()));
        this.general.put("rules-count", Integer.toString(this.items.size()));
        if (this.errors.getErrorCount() == 0) {
            this.desactivateError();
        }
        if (this.errors.getErrorCount() != 0 || !title.startsWith("http://")) {
            this.general.put("no-errors", "");
        }
        if (this.warnings.getWarningCount() == 0 || warningLevel == -1) {
            this.general.put("go-warnings", "");
            this.general.put("warnings", "");
        }
        if (this.items.size() == 0) {
            this.general.put("go-rules", "");
            this.general.put("rules", "");
            this.general.put("no-errors", "");
        } else {
            this.general.put("no-rules", "");
        }
        if (this.errors.getErrorCount() != 0 || this.warnings.getWarningCount() != 0) {
            this.general.put("no-error-or-warning", "");
        }
        if (Util.onDebug) {
            this.general.list(System.err);
        }
        DateFormat df = null;
        if (ac.getLang() != null) {
            try {
                df = DateFormat.getDateTimeInstance(0, 0, new Locale(ac.getLang().substring(0, 2), "US"));
            }
            catch (Exception e) {
                df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
            }
        }
        if (df != null) {
            this.general.put("today", df.format(new Date()));
        } else {
            this.general.put("today", new Date().toString());
        }
    }

    public void desactivateError() {
        this.general.put("go-errors", "");
        this.general.put("errors", "");
    }

    public void print(PrintWriter out) {
        this.out = out;
        String output = this.processSimple("document");
        if (output != null) {
            out.println(output);
        } else {
            out.println(this.ac.getMsg().getGeneratorString("request"));
        }
        out.flush();
    }

    public void produceRule() {
        Object[] array = this.items.getSortedArray();
        for (int i = 0; i < array.length; ++i) {
            this.selector = (CssSelectors)array[i];
            if (this.selector.isEmpty()) continue;
            this.out.print(this.processStyle(this.general.getProperty("rule"), this.general));
        }
    }

    public void produceSelector(CssSelectors selectorLocal) {
        this.out.print(selectorLocal);
    }

    public void produceDeclaration() {
        this.selector.getStyle().print(this);
    }

    public void print(CssProperty property) {
        Utf8Properties prop = new Utf8Properties(this.general);
        prop.put("property-name", property.getPropertyName().toString());
        prop.put("property-value", property.toString());
        if (!property.getImportant()) {
            prop.put("important-style", "");
        }
        this.out.print(this.processStyle(prop.getProperty("declaration"), prop));
    }

    public void produceParseException(CssParseException error, StringBuffer ret) {
        String name;
        if (error.getContexts() != null && error.getContexts().size() != 0) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = error.getContexts().elements();
            while (e.hasMoreElements()) {
                Object t = e.nextElement();
                if (t == null) continue;
                buf.append(t);
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
            if (buf.length() != 0) {
                ret.append(this.ac.getMsg().getGeneratorString("context"));
                ret.append(" : <STRONG>").append(buf);
                ret.append("</STRONG> ");
            }
        }
        if ((name = error.getProperty()) != null && StyleSheetGeneratorHTML.getURLProperty(name) != null) {
            ret.append(this.ac.getMsg().getGeneratorString("property"));
            ret.append(" : <A HREF=\"");
            ret.append(StyleSheetGeneratorHTML.getURLProperty("@url-base"));
            ret.append(StyleSheetGeneratorHTML.getURLProperty(name)).append("\">");
            ret.append(name).append("</A>");
        }
        if (error.getException() != null && error.getMessage() != null) {
            ret.append("\n<DD>");
            if (error.isParseException()) {
                ret.append(this.queryReplace(error.getMessage())).append('\n');
            } else {
                Exception ex = error.getException();
                if (ex instanceof NumberFormatException) {
                    ret.append(this.ac.getMsg().getGeneratorString("invalid-number"));
                } else {
                    ret.append(this.queryReplace(ex.getMessage()));
                }
            }
            if (error.getSkippedString() != null) {
                ret.append(" : <STRONG>");
                ret.append(this.queryReplace(error.getSkippedString()));
                ret.append("</STRONG>\n");
            } else if (error.getExp() != null) {
                ret.append(" : ");
                ret.append(this.queryReplace(error.getExp().toStringFromStart()));
                ret.append("<STRONG>");
                ret.append(this.queryReplace(error.getExp().toString()));
                ret.append("</STRONG>\n");
            }
        } else {
            ret.append("\n<DD>");
            ret.append(this.ac.getMsg().getGeneratorString("unrecognize"));
            ret.append(" - <STRONG>");
            ret.append(this.queryReplace(error.getSkippedString()));
            ret.append("</STRONG>\n");
        }
    }

    public void produceError() {
        StringBuffer ret = new StringBuffer(1024);
        String oldSourceFile = null;
        try {
            if (this.errors.getErrorCount() != 0) {
                ret.append("\n<UL>");
                CssError[] error = this.errors.getErrors();
                for (int i = 0; i < error.length; ++i) {
                    Exception ex = error[i].getException();
                    String file = error[i].getSourceFile();
                    if (!file.equals(oldSourceFile)) {
                        oldSourceFile = file;
                        ret.append("\n<LI><DL> URI : <A TARGET=\"workspace\" HREF=\"");
                        ret.append(file).append("\">");
                        ret.append(file).append("</A>");
                    }
                    ret.append("\n<DT>");
                    ret.append(this.ac.getMsg().getGeneratorString("line"));
                    ret.append(": ").append(error[i].getLine());
                    ret.append(' ');
                    if (ex instanceof FileNotFoundException) {
                        ret.append("\n<DD>");
                        ret.append(this.ac.getMsg().getGeneratorString("not-found"));
                        ret.append("<STRONG>");
                        ret.append(ex.getMessage());
                        ret.append("</STRONG>\n");
                        continue;
                    }
                    if (ex instanceof CssParseException) {
                        this.produceParseException((CssParseException)ex, ret);
                        continue;
                    }
                    if (ex instanceof InvalidParamException) {
                        ret.append("\n<DD>");
                        ret.append(this.queryReplace(ex.getMessage())).append('\n');
                        continue;
                    }
                    if (ex instanceof IOException) {
                        String stringError = ex.toString();
                        int index = stringError.indexOf(58);
                        ret.append("\n<DD>");
                        ret.append(stringError.substring(0, index));
                        ret.append(" : <STRONG>");
                        ret.append(ex.getMessage()).append("<STRONG>\n");
                        continue;
                    }
                    if (error[i] instanceof CssErrorToken) {
                        CssErrorToken terror = (CssErrorToken)error[i];
                        ret.append("\n<DD>").append("   ");
                        ret.append(terror.getErrorDescription()).append(" : ");
                        ret.append(terror.getSkippedString()).append('\n');
                        continue;
                    }
                    ret.append("\n<DD>");
                    ret.append("<STRONG>Uncaught error</STRONG>");
                    ret.append(ex).append('\n');
                    if (!(ex instanceof NullPointerException)) continue;
                    ex.printStackTrace();
                }
                ret.append("</DL></UL>");
            }
            this.out.println(ret.toString());
        }
        catch (Exception e) {
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace();
        }
    }

    public void produceWarning() {
        StringBuffer ret = new StringBuffer(1024);
        String oldSourceFile = "";
        int oldLine = -1;
        String oldMessage = "";
        try {
            if (this.warnings.getWarningCount() != 0) {
                this.warnings.sort();
                ret.append("\n<UL>");
                Warning[] warning = this.warnings.getWarnings();
                for (int i = 0; i < warning.length; ++i) {
                    Warning warn = warning[i];
                    if (warn.getLevel() > this.warningLevel) continue;
                    if (!warn.getSourceFile().equals(oldSourceFile)) {
                        if (i != 0) {
                            ret.append("</DL>");
                        }
                        oldSourceFile = warn.getSourceFile();
                        ret.append("\n<LI><DL><DT> URI : <A TARGET=\"workspace\" HREF=\"");
                        ret.append(oldSourceFile).append("\">");
                        ret.append(oldSourceFile).append("</A>");
                    }
                    if (warn.getLine() == oldLine && warn.getWarningMessage().equals(oldMessage)) continue;
                    oldLine = warn.getLine();
                    oldMessage = warn.getWarningMessage();
                    ret.append("\n<DD><STRONG> Line : ");
                    ret.append(oldLine);
                    if (warn.getLevel() != 0) {
                        ret.append(" Level : ");
                        ret.append(warn.getLevel());
                    }
                    ret.append(" </STRONG> ");
                    ret.append(oldMessage);
                    if (warn.getContext() == null) continue;
                    ret.append(" : ").append(warn.getContext());
                }
                ret.append("</DL></UL>");
            }
            this.out.println(ret.toString());
        }
        catch (Exception e) {
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace();
        }
    }

    private String queryReplace(String s) {
        if (s != null) {
            int len = s.length();
            StringBuffer ret = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '<') {
                    ret.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    ret.append("&gt;");
                    continue;
                }
                ret.append(c);
            }
            return ret.toString();
        }
        return "[empty string]";
    }

    private final String processSimple(String s) {
        return this.processStyle(this.general.getProperty(s), this.general);
    }

    private String processStyle(String str, Utf8Properties prop) {
        try {
            int i = 0;
            while ((i = str.indexOf("<!-- #", i)) >= 0) {
                String value;
                int lastIndexOfEntity = str.indexOf("-->", i);
                String entity = str.substring(i + 6, lastIndexOfEntity - 1).toLowerCase();
                if (entity.equals("rule")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceRule();
                    continue;
                }
                if (entity.equals("selectors")) {
                    if (this.selector.getNext() != null) {
                        value = prop.getProperty(entity);
                        if (value != null) {
                            str = str.substring(0, i) + value + str.substring(lastIndexOfEntity + 3);
                            continue;
                        }
                        i += 6;
                        continue;
                    }
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceSelector(this.selector);
                    continue;
                }
                if (entity.equals("selector")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceSelector(this.selector);
                    continue;
                }
                if (entity.equals("declaration")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceDeclaration();
                    continue;
                }
                if (entity.equals("warning")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceWarning();
                    continue;
                }
                if (entity.equals("error")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceError();
                    continue;
                }
                if (entity.equals("hook-html-validator")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    if (this.style.getType().equals("text/html")) {
                        this.out.println(this.ac.getMsg().getGeneratorString("doc-html", this.general.get("file-title").toString()));
                        continue;
                    }
                    this.out.println(this.ac.getMsg().getGeneratorString("doc"));
                    continue;
                }
                value = prop.getProperty(entity);
                if (value != null) {
                    str = str.substring(0, i) + value + str.substring(lastIndexOfEntity + 3);
                    continue;
                }
                i += 6;
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static final void printAvailableFormat(PrintWriter out) {
        Enumeration<?> e = availableFormat.propertyNames();
        out.println(" -- listing available output format --");
        while (e.hasMoreElements()) {
            String key = ((String)e.nextElement()).toLowerCase();
            out.println("Format : " + key);
            out.println("   File : " + StyleSheetGeneratorHTML.getDocumentName(null, key));
        }
        out.flush();
    }

    private Utf8Properties setDocumentBase(String document) {
        Utf8Properties properties = (Utf8Properties)formats.get(document);
        if (properties == null) {
            properties = new Utf8Properties();
            try {
                URL url = StyleSheetGenerator.class.getResource(document);
                InputStream f = url.openStream();
                properties.load(f);
                f.close();
                properties.put("author", "www-validator-css");
                properties.put("author-email", "Email.html");
            }
            catch (Exception e) {
                System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load properties " + document);
                System.err.println("  " + e.toString());
                StyleSheetGeneratorHTML.printAvailableFormat(new PrintWriter(System.err));
            }
            formats.put(document, properties);
        }
        return new Utf8Properties(properties);
    }

    private static final String getDocumentName(ApplContext ac, String documentName) {
        documentName = documentName.toLowerCase();
        String document = null;
        if (ac != null && ac.getLang() != null) {
            StringTokenizer tokens = new StringTokenizer(ac.getLang(), ",");
            while (tokens.hasMoreTokens()) {
                String l = tokens.nextToken().trim().toLowerCase();
                document = availableFormat.getProperty(documentName + "." + l);
                if (document != null) break;
                int minusIndex = l.indexOf(45);
                if (minusIndex != -1) {
                    l = l.substring(0, minusIndex);
                    document = availableFormat.getProperty(documentName + "." + l);
                }
                if (document == null) continue;
                break;
            }
        }
        if (document == null) {
            document = availableFormat.getProperty(documentName);
        }
        if (document == null) {
            System.err.println("Unable to find " + documentName + " output format");
            return documentName;
        }
        return document;
    }

    private static final String getURLProperty(String name) {
        return availablePropertiesURL.getProperty(name);
    }

    static {
        InputStream f;
        URL url;
        formats = new Hashtable();
        availableFormat = new Utf8Properties();
        try {
            url = StyleSheetGenerator.class.getResource("format.properties");
            f = url.openStream();
            availableFormat.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load format properties ");
            System.err.println("  " + e.toString());
        }
        availablePropertiesURL = new Utf8Properties();
        try {
            url = StyleSheetGenerator.class.getResource("urls.properties");
            f = url.openStream();
            availablePropertiesURL.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load URLs properties ");
            System.err.println("  " + e.toString());
        }
    }
}

