/*
 * Decompiled with CFR 0.152.
 */
package html.tree;

import html.tree.SimpleTree;
import html.tree.Tree;
import html.tree.TreeListener;
import java.util.Vector;

public class ActiveTree
extends SimpleTree {
    Vector listeners = null;

    private final void checkListeners() {
        if (this.listeners == null) {
            this.listeners = new Vector(1, 1);
        }
    }

    public void addTreeListener(TreeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(listener);
        this.listeners.trimToSize();
    }

    public void removeTreeListener(TreeListener listener) {
        this.listeners.removeElement(listener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        } else {
            this.listeners.trimToSize();
        }
    }

    public void setParent(Tree parent) {
        super.setParent(parent);
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifySetParent(parent);
        }
    }

    public void enter() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifyEnter();
        }
    }

    public void exit() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifyExit();
        }
    }

    public void replace(Tree child, int rank) {
        super.replace(child, rank);
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifyReplace(child, rank);
        }
    }

    public void attach(Tree child, int rank) {
        super.attach(child, rank);
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifyAttach(child, rank);
        }
    }

    public void attach(Tree child, Tree after) {
        super.attach(child, after);
        if (this.listeners == null) {
            return;
        }
        int rank = this.indexOf(child);
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifyAttach(child, rank);
        }
    }

    public void detach(Tree child) {
        int rank = this.indexOf(child);
        super.detach(child);
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifyDetach(child, rank);
        }
    }

    public void move(Tree child, int rank) {
        int oldRank = this.indexOf(child);
        super.move(child, rank);
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            TreeListener l = (TreeListener)this.listeners.elementAt(i);
            l.notifyDetach(child, oldRank);
            l.notifyAttach(child, rank);
        }
    }
}

