/*
 * Decompiled with CFR 0.152.
 */
package html.tags;

import html.parser.Attributes;
import html.parser.Element;
import html.parser.JmlParser;
import html.parser.ParserException;
import html.parser.Tag;
import html.parser.TextElement;
import html.parser.XMLInputException;
import html.tags.HtmlInputStream;
import html.tags.HtmlParserListener;
import html.tags.HtmlStreamListener;
import html.tags.HtmlTree;
import html.tags.ParserFrame;
import html.tags.SimpleTagFactory;
import html.tags.TagFactory;
import html.tree.Tree;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.Util;

public class HtmlParser
extends JmlParser
implements Runnable,
HtmlStreamListener {
    URL url = null;
    URLConnection uc = null;
    HtmlTree current = null;
    HtmlTree top = null;
    Vector listeners = new Vector();
    ParserFrame parserFrame = new ParserFrame();
    TagFactory factory;
    String urlname;
    boolean in_error_recovery = false;
    Hashtable errorTagTable;
    TextElement proto = new TextElement();
    Element p = new Element("p", 0);

    public HtmlParser(ApplContext ac, String dtdName, String urlname, URLConnection uc) throws ParserException {
        super(dtdName);
        this.urlname = urlname;
        this.uc = uc;
        this.parserFrame.ac = ac;
        this.setFactory(new SimpleTagFactory());
    }

    public HtmlParser(ApplContext ac, String dtdName, String urlname) throws ParserException {
        super(dtdName);
        this.urlname = urlname;
        this.parserFrame.ac = ac;
        this.setFactory(new SimpleTagFactory());
    }

    public HtmlParser(ApplContext ac, String dtdName, TagFactory f) throws ParserException {
        super(dtdName);
        this.parserFrame.ac = ac;
        this.setFactory(new SimpleTagFactory());
    }

    public HtmlTree getRoot() {
        return this.top;
    }

    public void setFactory(TagFactory f) {
        this.factory = f;
    }

    public Tag makeTag(Element elem, Attributes atts) {
        HtmlTree tag = null;
        if (this.in_error_recovery) {
            tag = (HtmlTree)this.errorTagTable.get(elem.getName());
        }
        if (tag == null) {
            this.parserFrame.line = this.ln;
            tag = (HtmlTree)this.factory.create(elem.getName());
            tag.initialize(elem, atts, this.parserFrame);
        }
        return tag;
    }

    public void addParserListener(HtmlParserListener l) {
        this.listeners.addElement(l);
    }

    public void removeParserListener(HtmlParserListener l) {
        this.listeners.removeElement(l);
    }

    protected void startErrorRecovery() {
        this.errorTagTable = new Hashtable();
        this.in_error_recovery = true;
    }

    protected void endErrorRecovery() {
        this.in_error_recovery = false;
    }

    public void handleStartTag(Tag tag) {
        if (this.in_error_recovery) {
            this.current = (HtmlTree)tag;
            return;
        }
        try {
            if (this.top == null) {
                this.top = (HtmlTree)tag;
                this.current = (HtmlTree)tag;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    HtmlParserListener l = (HtmlParserListener)this.listeners.elementAt(i);
                    l.notifyCreateRoot(this.url, this.top);
                }
                this.current.enter();
            } else {
                if (this.current == null) {
                    this.current = this.top;
                }
                HtmlTree child = (HtmlTree)tag;
                if (this.current != null) {
                    this.current.attach((Tree)child, this.current.arity());
                    this.current = child;
                    this.current.enter();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.notifyActivity(this.ln, 0L);
    }

    public void handleEndTag(Tag tag) {
        if (this.in_error_recovery) {
            this.errorTagTable.put(tag.getElement().getName(), tag);
        } else if (this.current != null) {
            this.current.exit();
            this.current = (HtmlTree)this.current.getParent();
        }
    }

    public void handleText(byte[] text) {
        if (text.length == 1 && text[0] == 32) {
            return;
        }
        Attributes atts = new Attributes();
        atts.put("text", new String(text));
        HtmlTree tag = (HtmlTree)this.factory.create("text");
        this.parserFrame.line = this.ln;
        tag.initialize(this.proto, atts, this.parserFrame);
        if (this.current != null) {
            this.current.attach((Tree)tag, this.current.arity());
        }
    }

    public void handleEmptyTag(Tag tag) {
        if (this.current != null) {
            this.current.attach((Tree)((HtmlTree)tag), this.current.arity());
        } else {
            System.out.println("ERROR: " + tag + "has no parent");
        }
    }

    public void run() {
        InputStream input = null;
        input = this.uc == null ? this.makeInput(this.urlname) : this.makeInput();
        if (input != null) {
            input = new BufferedInputStream(input);
        }
        try {
            long tm = System.currentTimeMillis();
            if (Boolean.getBoolean("html.tags.verbose")) {
                System.out.println("[Parsing " + this.urlname + ']');
            }
            this.parse(input, this.dtd);
            tm = System.currentTimeMillis() - tm;
            if (Boolean.getBoolean("html.tags.verbose")) {
                System.out.println("[Parsed " + this.urlname + " in " + tm + "ms]");
            }
        }
        catch (XMLInputException e) {
            this.notifyFatalError(null, e, "");
        }
        catch (Exception e) {
            if (!Boolean.getBoolean("html.runningServlet")) {
                System.out.println("uncaught error while parsing");
                e.printStackTrace();
            }
            this.notifyFatalError(null, e, "");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlParserListener l = (HtmlParserListener)this.listeners.elementAt(i);
            l.notifyEnd(this.top, "text/html");
        }
        if (Boolean.getBoolean("html.tags.verbose")) {
            System.out.println("\n-------------------");
            System.out.println("[StyleSheet dump:]");
            this.parserFrame.styleSheetParser.getStyleSheet().dump();
            System.out.println("-------------------");
        }
    }

    public void notifyConnection(URLConnection cnx) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlParserListener l = (HtmlParserListener)this.listeners.elementAt(i);
            l.notifyConnection(cnx);
        }
    }

    InputStream makeInput(String urls) {
        InputStream in = null;
        try {
            if (urls.indexOf(58) > 0) {
                URLConnection urlC = null;
                urlC = HTTPURL.getConnection(new URL(null, urls), this.parserFrame.ac);
                this.parserFrame.url = this.url = urlC.getURL();
                in = urlC.getInputStream();
                HtmlInputStream hin = new HtmlInputStream(in);
                hin.addHtmlStreamListener(this);
                return hin;
            }
        }
        catch (Exception e) {
            if (!Util.servlet) {
                e.printStackTrace();
                System.out.println("failed to open: " + urls);
            }
            try {
                in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            in = null;
            this.notifyFatalError(null, e, "");
        }
        return null;
    }

    InputStream makeInput() {
        InputStream in = null;
        try {
            this.parserFrame.url = this.url = this.uc.getURL();
            in = this.uc.getInputStream();
            HtmlInputStream hin = new HtmlInputStream(in);
            hin.addHtmlStreamListener(this);
            return hin;
        }
        catch (Exception e) {
            if (!Util.servlet) {
                e.printStackTrace();
                System.out.println("failed to open: " + this.url);
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            in = null;
            this.notifyFatalError(null, e, "");
            return null;
        }
    }

    String makeURLName(String s) {
        System.out.println("makeURLName: " + s);
        if (s.indexOf(58) > 0) {
            return s;
        }
        return "file:" + s;
    }

    void notifyFatalError(HtmlTree root, Exception x, String s) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlParserListener l = (HtmlParserListener)this.listeners.elementAt(i);
            l.notifyFatalError(root, x, s);
        }
    }

    public void notifyActivity(int lines, long bytes) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlParserListener l = (HtmlParserListener)this.listeners.elementAt(i);
            l.notifyActivity(this.ln, bytes);
        }
    }
}

