/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.AttributeList;
import html.parser.Attributes;
import html.parser.DTD;
import html.parser.DTDConstants;
import html.parser.Element;
import html.parser.Entity;
import html.parser.HTMLOutputStream;
import html.parser.Tag;
import html.parser.TagStack;
import html.parser.UnknownTag;
import html.parser.XMLInputException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class Parser
implements DTDConstants {
    static final byte[] notext = new byte[0];
    byte[] text = new byte[1024];
    int textpos = 0;
    Tag last;
    boolean space;
    boolean verbose;
    HTMLOutputStream out;
    char[] str = new char[128];
    int strpos = 0;
    protected Properties props;
    protected DTD dtd;
    int ch;
    public int ln;
    InputStream in;
    Element recent;
    TagStack stack;

    protected Tag makeTag(Element elem, Attributes atts) {
        return new UnknownTag(elem, atts);
    }

    protected void handleIllegalTag(String name) {
        this.error("illegal.tag", name);
    }

    protected void handleText(byte[] text) throws IOException {
        if (this.verbose && this.out != null) {
            this.out.text(text);
        }
    }

    protected void handleComment(String str) throws IOException {
        if (this.verbose && this.out != null) {
            this.out.comment(str);
        }
    }

    protected void handleEmptyTag(Tag tag) throws IOException {
        if (this.verbose && this.out != null) {
            this.out.emptyTag(tag);
        }
    }

    protected void handleStartTag(Tag tag) throws IOException {
        if (this.verbose && this.out != null) {
            this.out.startTag(tag);
        }
    }

    protected void handleEndTag(Tag tag) throws IOException {
        if (this.verbose && this.out != null) {
            this.out.endTag(tag);
        }
    }

    void handleError(int ln, String msg) {
        if (Boolean.getBoolean("html.parser.debug")) {
            System.out.println("**** " + this.stack);
            System.out.println("line " + ln + ": error: " + msg);
            System.out.println();
        }
    }

    void handleText(Tag tag) throws IOException {
        byte[] newtext;
        if (tag.isBlock()) {
            this.space = false;
        }
        if (!(this.textpos != 0 || this.space && this.stack != null && !this.last.isBlock() && this.stack.advance(this.dtd.pcdata))) {
            this.last = tag;
            this.space = false;
            return;
        }
        if (this.space) {
            if (this.textpos + 1 > this.text.length) {
                newtext = new byte[this.text.length * 2];
                System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                this.text = newtext;
            }
            this.text[this.textpos++] = 32;
            this.space = false;
        }
        newtext = new byte[this.textpos];
        System.arraycopy(this.text, 0, newtext, 0, this.textpos);
        this.handleText(newtext);
        this.textpos = 0;
        this.last = tag;
        this.space = false;
    }

    void error(String err, String arg1, String arg2, String arg3) {
        int i;
        String str = DTD.props.getProperty("htmlerr." + err);
        if (str == null) {
            str = err;
        }
        while ((i = str.indexOf(37)) > 0) {
            str = str.substring(0, i) + arg1 + str.substring(i + 1);
            arg1 = arg2;
            arg2 = arg3;
        }
        this.handleError(this.ln, str);
    }

    void error(String err, String arg1, String arg2) {
        this.error(err, arg1, arg2, "?");
    }

    void error(String err, String arg1) {
        this.error(err, arg1, "?", "?");
    }

    void error(String err) {
        this.error(err, "?", "?", "?");
    }

    void startTag(Tag tag) throws IOException {
        this.handleText(tag);
        Element elem = tag.getElement();
        Attributes atts = tag.getAttributes();
        AttributeList a = elem.atts;
        while (a != null) {
            if (a.modifier == 2 && (atts == null || atts.get(a.name) == null)) {
                this.error("req.att", a.getName(), elem.getName());
            }
            a = a.next;
        }
        if (elem.isEmpty()) {
            this.handleEmptyTag(tag);
        } else {
            this.recent = elem;
            this.stack = new TagStack(tag, this.stack);
            this.handleStartTag(tag);
        }
    }

    void endTag(boolean omitted) throws IOException {
        this.handleText(this.stack.tag);
        if (omitted && !this.stack.elem.omitEnd()) {
            this.error("end.missing", this.stack.elem.getName());
        } else if (!this.stack.terminate()) {
            this.error("end.unexpected", this.stack.elem.getName());
        }
        this.handleEndTag(this.stack.tag);
        this.stack = this.stack.next;
        this.recent = this.stack != null ? this.stack.elem : null;
    }

    boolean legalElementContext(Element elem) throws IOException {
        Element next;
        if (this.stack == null) {
            if (elem != this.dtd.html) {
                this.startTag(this.makeTag(this.dtd.html, null));
                return this.legalElementContext(elem);
            }
            return true;
        }
        if (this.stack.advance(elem)) {
            return true;
        }
        if (this.stack.elem.omitEnd() && this.stack.terminate()) {
            TagStack s = this.stack.next;
            while (s != null) {
                if (s.advance(elem)) {
                    while (this.stack != s) {
                        this.endTag(true);
                    }
                    return true;
                }
                if (!s.elem.omitEnd() || !s.terminate()) break;
                s = s.next;
            }
        }
        if ((next = this.stack.first()) != null && next.omitStart()) {
            Tag t = this.makeTag(next, null);
            this.legalTagContext(t);
            this.startTag(t);
            return this.legalElementContext(elem);
        }
        if (this.stack.elem.omitEnd() && this.stack.terminate()) {
            this.endTag(true);
            return this.legalElementContext(elem);
        }
        return false;
    }

    void legalTagContext(Tag tag) throws IOException {
        if (this.legalElementContext(tag.getElement())) {
            return;
        }
        if (tag.isBlock() && this.stack != null && !this.stack.tag.isBlock()) {
            this.endTag(true);
            this.legalTagContext(tag);
            return;
        }
        this.error("tag.unexpected", tag.getElement().getName());
    }

    protected void startErrorRecovery() {
    }

    protected void endErrorRecovery() {
    }

    void errorContext() throws IOException {
        while (this.stack != null && this.stack.tag != this.dtd.body) {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
        if (this.stack == null) {
            this.legalElementContext(this.dtd.body);
            this.startTag(this.makeTag(this.dtd.body, null));
        }
    }

    void addString(int c) {
        if (this.strpos == this.str.length) {
            char[] newstr = new char[this.str.length * 2];
            System.arraycopy(this.str, 0, newstr, 0, this.str.length);
            this.str = newstr;
        }
        this.str[this.strpos++] = (char)c;
    }

    String getString(int pos) {
        char[] newstr = new char[this.strpos - pos];
        System.arraycopy(this.str, pos, newstr, 0, this.strpos - pos);
        this.strpos = pos;
        return new String(newstr);
    }

    void skipSpace() throws IOException {
        block5: while (true) {
            switch (this.ch) {
                case 10: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch != 13) continue block5;
                    this.ch = this.in.read();
                    continue block5;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch != 10) continue block5;
                    this.ch = this.in.read();
                    continue block5;
                }
                case 9: 
                case 32: {
                    this.ch = this.in.read();
                    continue block5;
                }
            }
            break;
        }
    }

    boolean parseIdentifier(boolean lower) throws IOException {
        switch (this.ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (lower) {
                    this.ch = 97 + (this.ch - 65);
                }
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                break;
            }
            default: {
                return false;
            }
        }
        block8: while (true) {
            this.addString(this.ch);
            this.ch = this.in.read();
            switch (this.ch) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (lower) {
                        this.ch = 97 + (this.ch - 65);
                    }
                }
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    private byte[] parseEntityReference() throws IOException {
        int pos = this.strpos;
        this.ch = this.in.read();
        if (this.ch == 35) {
            int n = 0;
            this.ch = this.in.read();
            if (this.ch >= 48 && this.ch <= 57) {
                while (this.ch >= 48 && this.ch <= 57) {
                    n = n * 10 + this.ch - 48;
                    this.ch = this.in.read();
                }
                switch (this.ch) {
                    case 10: {
                        ++this.ln;
                        this.ch = this.in.read();
                        if (this.ch != 13) break;
                        this.ch = this.in.read();
                        break;
                    }
                    case 13: {
                        ++this.ln;
                        this.ch = this.in.read();
                        if (this.ch != 10) break;
                        this.ch = this.in.read();
                        break;
                    }
                    case 59: {
                        this.ch = this.in.read();
                    }
                }
                byte[] data = new byte[]{(byte)(n & 0xFF)};
                return data;
            }
            this.addString(35);
            if (!this.parseIdentifier(false)) {
                this.error("ident.expected");
                this.strpos = pos;
                byte[] data = new byte[]{38, 35};
                return data;
            }
        } else if (!this.parseIdentifier(false)) {
            byte[] data = new byte[]{38};
            return data;
        }
        switch (this.ch) {
            case 10: {
                ++this.ln;
                this.ch = this.in.read();
                if (this.ch != 13) break;
                this.ch = this.in.read();
                break;
            }
            case 13: {
                ++this.ln;
                this.ch = this.in.read();
                if (this.ch != 10) break;
                this.ch = this.in.read();
                break;
            }
            case 59: {
                this.ch = this.in.read();
            }
        }
        String nm = this.getString(pos);
        Entity ent = this.dtd.getEntity(nm);
        if (ent == null || !ent.isGeneral()) {
            String str;
            if (this.props == null || (str = this.props.getProperty(nm)) == null) {
                this.error("invalid.entref", nm);
                return new byte[0];
            }
            byte[] b = str.getBytes();
            return b;
        }
        return ent.getData();
    }

    void parseComment() throws IOException {
        while (true) {
            int c = this.ch;
            switch (c) {
                case 45: {
                    this.ch = this.in.read();
                    if (this.ch != 45 || (this.ch = this.in.read()) != 62) break;
                    return;
                }
                case -1: {
                    this.error("eof.comment");
                    return;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch != 13) break;
                    this.ch = this.in.read();
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch == 10) {
                        this.ch = this.in.read();
                    }
                    c = 10;
                    break;
                }
                default: {
                    this.ch = this.in.read();
                }
            }
            this.addString(c);
        }
    }

    void parseLiteral(boolean replace) throws IOException {
        block7: while (true) {
            int c = this.ch;
            switch (c) {
                case -1: {
                    this.error("eof.literal", this.stack.elem.getName());
                    this.endTag(true);
                    return;
                }
                case 62: {
                    this.ch = this.in.read();
                    int i = this.textpos - (this.stack.elem.name.length() + 2);
                    int j = 0;
                    if (i < 0 || this.text[i++] != 60 || this.text[i] != 47) break;
                    while (++i < this.textpos && Character.toUpperCase((char)this.text[i]) == Character.toUpperCase(this.stack.elem.name.charAt(j++))) {
                    }
                    if (i != this.textpos) break;
                    this.textpos -= this.stack.elem.name.length() + 2;
                    if (this.textpos > 0 && this.text[this.textpos - 1] == 10) {
                        --this.textpos;
                    }
                    this.endTag(false);
                    return;
                }
                case 38: {
                    byte[] data = this.parseEntityReference();
                    if (this.textpos + data.length > this.text.length) {
                        byte[] newtext = new byte[Math.max(this.textpos + data.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                        this.text = newtext;
                    }
                    System.arraycopy(data, 0, this.text, this.textpos, data.length);
                    this.textpos += data.length;
                    continue block7;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch != 13) break;
                    this.ch = this.in.read();
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch == 10) {
                        this.ch = this.in.read();
                    }
                    c = 10;
                    break;
                }
                default: {
                    this.ch = this.in.read();
                }
            }
            if (this.textpos == this.text.length) {
                byte[] newtext = new byte[this.text.length * 2];
                System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                this.text = newtext;
            }
            this.text[this.textpos++] = (byte)(c & 0xFF);
        }
    }

    String parseAttributeValue(boolean lower) throws IOException {
        int delim = -1;
        switch (this.ch) {
            case 34: 
            case 39: {
                delim = this.ch;
                this.ch = this.in.read();
            }
        }
        while (true) {
            int c = this.ch;
            switch (c) {
                case 10: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch == 13) {
                        this.ch = this.in.read();
                    }
                    if (delim < 0) {
                        return this.getString(0);
                    }
                    c = 32;
                    break;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch == 10) {
                        this.ch = this.in.read();
                    }
                    if (delim < 0) {
                        return this.getString(0);
                    }
                    c = 32;
                    break;
                }
                case 9: {
                    c = 32;
                }
                case 32: {
                    this.ch = this.in.read();
                    if (delim >= 0) break;
                    return this.getString(0);
                }
                case 60: 
                case 62: {
                    if (delim < 0) {
                        return this.getString(0);
                    }
                    this.ch = this.in.read();
                    break;
                }
                case 34: 
                case 39: {
                    this.ch = this.in.read();
                    if (c != delim) break;
                    return this.getString(0);
                }
                case -1: {
                    return this.getString(0);
                }
                default: {
                    if (lower && c >= 65 && c <= 90) {
                        c = 97 + c - 65;
                    }
                    this.ch = this.in.read();
                }
            }
            this.addString(c);
        }
    }

    Attributes parseAttributeSpecificationList(Element elem) throws IOException {
        Attributes atts = null;
        block4: while (true) {
            this.skipSpace();
            switch (this.ch) {
                case -1: 
                case 47: 
                case 60: 
                case 62: {
                    return atts;
                }
                case 45: {
                    this.ch = this.in.read();
                    this.ch = this.in.read();
                    if (this.ch == 45) {
                        this.ch = this.in.read();
                        this.parseComment();
                        this.strpos = 0;
                        continue block4;
                    }
                    this.error("invalid.tagchar", "-", elem.getName());
                    this.ch = this.in.read();
                    continue block4;
                }
            }
            AttributeList att = null;
            String attname = null;
            String attvalue = null;
            if (this.parseIdentifier(true)) {
                attname = this.getString(0);
                this.skipSpace();
                if (this.ch == 61) {
                    this.ch = this.in.read();
                    this.skipSpace();
                    att = elem.getAttribute(attname);
                    attvalue = this.parseAttributeValue(att != null && att.type != 1 && att.type != 11);
                } else {
                    attvalue = attname;
                    att = elem.getAttributeByValue(attvalue);
                }
            } else {
                char[] str = new char[]{(char)this.ch};
                this.error("invalid.tagchar", new String(str), elem.getName());
                return atts;
            }
            if (att != null) {
                attname = att.getName();
            } else if (elem != this.dtd.app) {
                this.error("invalid.tagatt", attname, elem.getName());
            }
            if (atts == null) {
                atts = new Attributes();
            } else if (atts.get(attname) != null) {
                this.error("multi.tagatt", attname, elem.getName());
            }
            if (attvalue == null) {
                attvalue = att != null && att.value != null ? att.value : "";
            } else if (att != null && att.values != null && !att.values.contains(attvalue)) {
                this.error("invalid.tagattval", attname, elem.getName());
            }
            atts.append(attname, attvalue);
        }
    }

    void parseTag() throws IOException {
        Element elem = null;
        boolean net = false;
        String els = null;
        this.ch = this.in.read();
        switch (this.ch) {
            case 33: {
                this.ch = this.in.read();
                switch (this.ch) {
                    case 45: {
                        while (true) {
                            if (this.ch != 45 || (this.ch = this.in.read()) != 45) {
                                char[] data = new char[]{(char)this.ch};
                                this.error("invalid.commentchar", new String(data));
                                if (this.ch != 10 && this.ch != 13) {
                                    this.ch = this.in.read();
                                }
                            } else {
                                this.ch = this.in.read();
                                this.parseComment();
                                this.handleComment(this.getString(0));
                            }
                            this.skipSpace();
                            switch (this.ch) {
                                case 62: {
                                    this.ch = this.in.read();
                                }
                                case -1: {
                                    return;
                                }
                            }
                        }
                    }
                }
                this.error("invalid.markup");
                block38: while (true) {
                    switch (this.ch) {
                        case 62: {
                            this.ch = this.in.read();
                        }
                        case -1: {
                            return;
                        }
                        case 10: {
                            ++this.ln;
                            this.ch = this.in.read();
                            if (this.ch != 13) continue block38;
                            this.ch = this.in.read();
                            continue block38;
                        }
                        case 13: {
                            ++this.ln;
                            this.ch = this.in.read();
                            if (this.ch != 10) continue block38;
                            this.ch = this.in.read();
                            continue block38;
                        }
                    }
                    this.ch = this.in.read();
                }
            }
            case 47: {
                this.ch = this.in.read();
                switch (this.ch) {
                    case 62: {
                        this.ch = this.in.read();
                    }
                    case 60: {
                        if (this.recent == null) {
                            this.error("invalid.shortend");
                            return;
                        }
                        elem = this.recent;
                        break;
                    }
                    default: {
                        if (!this.parseIdentifier(true)) {
                            this.error("expected.endtagname");
                            return;
                        }
                        switch (this.ch) {
                            case 62: {
                                this.ch = this.in.read();
                            }
                            case 60: {
                                break;
                            }
                            default: {
                                this.error("expected", "'>'");
                            }
                        }
                        els = this.getString(0);
                        elem = this.dtd.findElement(els);
                        if (elem != null) break;
                        this.handleIllegalTag(els);
                        return;
                    }
                }
                if (this.textpos > 0 && this.text[this.textpos - 1] == 10) {
                    --this.textpos;
                }
                TagStack sp = this.stack;
                while (sp != null && elem != sp.elem) {
                    sp = sp.next;
                }
                if (sp == null) {
                    this.error("unmatched.endtag", elem.getName());
                    return;
                }
                while (this.stack != sp) {
                    this.endTag(true);
                }
                this.endTag(false);
                return;
            }
            case -1: {
                this.error("eof");
                return;
            }
        }
        if (!this.parseIdentifier(true)) {
            elem = this.recent;
            if (this.ch != 62 || elem == null) {
                this.error("expected.tagname");
                return;
            }
        } else {
            els = this.getString(0);
            elem = this.dtd.findElement(els);
        }
        Attributes atts = null;
        if (elem == null) {
            while (this.ch != 62) {
                this.ch = this.in.read();
                if (this.ch != -1) continue;
                this.error("eof");
                return;
            }
        } else {
            atts = this.parseAttributeSpecificationList(elem);
        }
        switch (this.ch) {
            case 47: {
                net = true;
            }
            case 62: {
                this.ch = this.in.read();
            }
            case 60: {
                break;
            }
            default: {
                this.error("expected", "'>'");
            }
        }
        if (elem != null && !elem.isEmpty()) {
            if (this.ch == 10) {
                ++this.ln;
                this.ch = this.in.read();
                if (this.ch == 13) {
                    this.ch = this.in.read();
                }
            } else if (this.ch == 13) {
                ++this.ln;
                this.ch = this.in.read();
                if (this.ch == 10) {
                    this.ch = this.in.read();
                }
            }
        }
        if (elem == null) {
            this.handleIllegalTag(els);
            return;
        }
        try {
            Tag tag = this.makeTag(elem, atts);
            this.legalTagContext(tag);
            this.startTag(tag);
        }
        catch (IOException x) {
            System.out.println("exiting abnormally");
            x.printStackTrace(System.out);
        }
        if (!elem.isEmpty()) {
            switch (elem.getType()) {
                case 1: {
                    this.parseLiteral(false);
                    break;
                }
                case 16: {
                    this.parseLiteral(true);
                    break;
                }
                default: {
                    this.stack.net = net;
                }
            }
        }
    }

    void parseContent() throws IOException {
        block9: while (true) {
            int c = this.ch;
            switch (c) {
                case 60: {
                    this.parseTag();
                    continue block9;
                }
                case 47: {
                    this.ch = this.in.read();
                    if (this.stack == null || !this.stack.net) break;
                    this.endTag(false);
                    continue block9;
                }
                case -1: {
                    return;
                }
                case 38: {
                    byte[] data;
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.isBlock()) {
                            this.space = false;
                        }
                    }
                    if (this.textpos + (data = this.parseEntityReference()).length + 1 > this.text.length) {
                        byte[] newtext = new byte[Math.max(this.textpos + data.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                        this.text = newtext;
                    }
                    if (this.space) {
                        this.space = false;
                        this.text[this.textpos++] = 32;
                    }
                    System.arraycopy(data, 0, this.text, this.textpos, data.length);
                    this.textpos += data.length;
                    continue block9;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch == 13) {
                        this.ch = this.in.read();
                    }
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                case 13: {
                    ++this.ln;
                    this.ch = this.in.read();
                    if (this.ch == 10) {
                        this.ch = this.in.read();
                    }
                    c = 10;
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                case 9: 
                case 32: {
                    this.ch = this.in.read();
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                default: {
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.isBlock()) {
                            this.space = false;
                        }
                    }
                    this.ch = this.in.read();
                }
            }
            if (this.textpos + 2 > this.text.length) {
                byte[] newtext = new byte[this.text.length * 2];
                System.arraycopy(this.text, 0, newtext, 0, this.text.length);
                this.text = newtext;
            }
            if (this.space) {
                this.text[this.textpos++] = 32;
                this.space = false;
            }
            this.text[this.textpos++] = (byte)(c & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(InputStream in, DTD dtd) throws IOException, Exception {
        if (in == null) {
            return;
        }
        this.in = in;
        this.dtd = dtd;
        this.ln = 1;
        boolean ready = false;
        if (in.markSupported()) {
            in.mark(in.available());
            int ch1 = in.read();
            while (ch1 != 60) {
                if (ch1 == -1) {
                    return;
                }
                ch1 = in.read();
            }
            while (!ready) {
                ch1 = in.read();
                int ch2 = in.read();
                if (ch1 != 33) {
                    ready = true;
                    continue;
                }
                if (ch2 == 45) {
                    while (ch2 != 60) {
                        if (ch2 == -1) {
                            return;
                        }
                        ch2 = in.read();
                    }
                    continue;
                }
                if (ch2 == 68) {
                    byte[] bity = new byte[50];
                    int got = in.read(bity);
                    String str = new String(bity);
                    if (str.toLowerCase().indexOf("octype") != -1 && str.toLowerCase().indexOf("xhtml") != -1) {
                        throw new XMLInputException(null);
                    }
                    ready = true;
                    continue;
                }
                ready = true;
            }
        }
        in.reset();
        boolean mustClose = true;
        try {
            try {
                this.ch = in.read();
                this.text = new byte[1024];
                this.str = new char[128];
                this.parseContent();
                while (this.stack != null) {
                    this.endTag(true);
                }
            }
            catch (IOException e) {
                this.errorContext();
                this.error("exception", e.getClass().getName());
                throw e;
            }
            catch (XMLInputException e) {
                mustClose = false;
                this.errorContext();
                this.error("exception", e.getClass().getName());
                throw e;
            }
            catch (Exception e) {
                this.errorContext();
                this.error("exception", e.getClass().getName());
                e.printStackTrace();
                throw e;
            }
            catch (ThreadDeath e) {
                this.errorContext();
                this.error("exception", e.getClass().getName());
                throw e;
            }
        }
        finally {
            while (this.stack != null) {
                this.handleEndTag(this.stack.tag);
                this.stack = this.stack.next;
            }
            this.text = null;
            this.str = null;
            if (mustClose) {
                in.close();
            }
        }
    }

    public static void main(String[] argv) throws IOException, Exception {
        int i;
        DTD.props = new Properties();
        try {
            URL url = Parser.class.getResource("Parser.properties");
            DTD.props.load(url.openStream());
        }
        catch (Exception e) {
            System.out.println("Failed to load properties...");
            System.exit(1);
        }
        DTD.props = new Properties(DTD.props);
        Parser p = new Parser();
        DTD dtd = null;
        for (i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-verbose")) {
                p.verbose = true;
                continue;
            }
            if (argv[i].equals("-dtd") && i + 1 < argv.length && dtd == null) {
                System.out.println("name == " + argv[i + 1]);
                dtd = DTD.getDTD(argv[++i]);
                continue;
            }
            if (!argv[i].startsWith("-")) break;
            System.out.println("invalid argument: " + argv[i]);
            System.exit(1);
        }
        if (dtd == null) {
            dtd = DTD.getDTD("html320");
        }
        if (p.verbose) {
            p.out = new HTMLOutputStream(System.out, dtd);
        }
        while (i < argv.length) {
            block10: {
                InputStream in;
                try {
                    in = argv[i].indexOf(58) > 0 ? new URL(null, argv[i]).openStream() : new BufferedInputStream(new FileInputStream(argv[i]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("failed to open: " + argv[i]);
                    break block10;
                }
                long tm = System.currentTimeMillis();
                System.out.println("----- Trace - 1 ------");
                p.parse(in, dtd);
                tm = System.currentTimeMillis() - tm;
                System.out.println("[Parsed " + argv[i] + " in " + tm + "ms]");
            }
            ++i;
        }
    }
}

