/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.AttributeList;
import html.parser.Attributes;
import html.parser.DTD;
import html.parser.DTDConstants;
import html.parser.Element;
import html.parser.Entity;
import html.parser.Tag;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HTMLOutputStream
extends FilterOutputStream
implements DTDConstants {
    DTD dtd;
    int col;
    int plain;
    int pre;
    boolean newline;
    boolean space;
    boolean eatspace;
    final int MAXCOL = 60;

    public HTMLOutputStream(OutputStream out, DTD dtd) {
        super(out);
        this.dtd = dtd;
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        this.col = c == 10 ? 0 : this.col + 1;
    }

    void write(String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.write(str.charAt(i));
        }
    }

    void writeEscaped(int c) throws IOException {
        switch (c) {
            case 60: {
                this.write("&lt;");
                break;
            }
            case 62: {
                this.write("&gt;");
                break;
            }
            case 38: {
                this.write("&amp;");
                break;
            }
            case 34: {
                this.write("&quot;");
                break;
            }
            default: {
                if (c < 32 || c > 127) {
                    Entity ent = this.dtd.getEntity(c);
                    this.write(38);
                    if (ent != null) {
                        this.write(ent.getName());
                    } else {
                        this.write(35);
                        this.write(String.valueOf(c));
                    }
                    this.write(59);
                    break;
                }
                this.write(c);
            }
        }
    }

    void writeText(int c) throws IOException {
        switch (c) {
            case 9: 
            case 10: 
            case 32: {
                if (this.pre == 0) {
                    this.space = !this.eatspace;
                } else {
                    this.write(c);
                }
                return;
            }
        }
        if (this.space) {
            this.write(this.newline || this.col >= 60 ? 10 : 32);
            this.space = false;
        }
        this.newline = false;
        this.eatspace = false;
        this.writeEscaped(c);
    }

    void writeTag(Element elem, Attributes atts) throws IOException {
        this.write(60);
        this.write(elem.getName());
        if (atts != null) {
            int natts = atts.length();
            block3: for (int i = 0; i < natts; ++i) {
                String attname = atts.getName(i);
                String attvalue = atts.get(i);
                AttributeList attlist = elem.getAttribute(attname);
                int type = attlist == null ? 1 : attlist.getType();
                this.write(32);
                this.write(attname);
                int len = attvalue.length();
                switch (type) {
                    case 4: 
                    case 7: 
                    case 9: 
                    case 12: 
                    case 14: {
                        int j;
                        this.write(61);
                        for (j = 0; j < len; ++j) {
                            this.writeEscaped(attvalue.charAt(j));
                        }
                        continue block3;
                    }
                    default: {
                        int j;
                        this.write(61);
                        this.write(34);
                        for (j = 0; j < len; ++j) {
                            this.writeEscaped(attvalue.charAt(j));
                        }
                        this.write(34);
                    }
                }
            }
        }
        this.write(62);
    }

    public void startTag(Tag tag) throws IOException {
        if (this.pre == 0 && (this.space || tag.isBlock()) && !this.eatspace) {
            this.write(10);
        }
        this.space = false;
        this.newline = false;
        this.writeTag(tag.getElement(), tag.getAttributes());
        if (this.pre == 0) {
            this.write(10);
        }
        if (tag.isPreformatted()) {
            ++this.pre;
        } else if (tag.getElement().getType() == 1) {
            ++this.plain;
        }
        this.eatspace = this.pre == 0 && tag.isBlock();
    }

    public void startTag(Element elem, Attributes atts) throws IOException {
        this.writeTag(elem, atts);
        this.write(10);
    }

    public void endTag(Tag tag) throws IOException {
        if (tag.isPreformatted()) {
            --this.pre;
        } else if (tag.getElement().getType() == 1) {
            --this.plain;
        }
        this.space = false;
        this.newline = false;
        if (this.pre == 0 && !this.eatspace) {
            this.write(10);
        }
        this.write(60);
        this.write(47);
        this.write(tag.getElement().getName());
        this.write(62);
        if (this.pre == 0) {
            if (tag.isBlock()) {
                this.write(10);
                this.eatspace = true;
            } else {
                this.newline = true;
            }
        }
    }

    public void endTag(Element elem) throws IOException {
        this.write(10);
        this.write(60);
        this.write(47);
        this.write(elem.getName());
        this.write(62);
    }

    public void emptyTag(Tag tag) throws IOException {
        if (this.pre == 0 && (this.space || this.newline || tag.isBlock()) && !this.eatspace) {
            this.write(10);
        }
        this.space = false;
        this.newline = false;
        this.eatspace = false;
        this.writeTag(tag.getElement(), tag.getAttributes());
        if (this.pre == 0) {
            if (tag.isBlock()) {
                this.write(10);
                this.eatspace = true;
            } else {
                this.newline = true;
            }
        }
    }

    public void emptyTag(Element elem, Attributes atts) throws IOException {
        this.writeTag(elem, atts);
    }

    public void text(byte[] data) throws IOException {
        this.text(data, 0, data.length);
    }

    public void text(byte[] data, int off, int len) throws IOException {
        if (this.plain == 0) {
            for (int i = 0; i < len; ++i) {
                this.writeText(data[i + off] & 0xFF);
            }
        } else {
            this.out.write(data, off, len);
        }
    }

    public void text(String str) throws IOException {
        if (this.plain == 0) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                this.writeText(str.charAt(i));
            }
        } else {
            this.write(str);
        }
    }

    public void comment(String str) throws IOException {
        if (this.newline) {
            this.write(10);
        }
        this.write(60);
        this.write(33);
        this.write(45);
        this.write(45);
        this.write(str);
        this.write(45);
        this.write(45);
        this.write(62);
        this.space = false;
        this.eatspace = false;
        this.newline = this.pre == 0;
    }
}

