/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.Element;

class ContentModel {
    int type;
    Object content;
    ContentModel next;

    ContentModel(Element content) {
        this.content = content;
    }

    ContentModel(int type, ContentModel content) {
        this.type = type;
        this.content = content;
    }

    public boolean empty() {
        switch (this.type) {
            case 42: 
            case 63: {
                return true;
            }
            case 43: 
            case 124: {
                ContentModel m = (ContentModel)this.content;
                while (m != null) {
                    if (m.empty()) {
                        return true;
                    }
                    m = m.next;
                }
                return false;
            }
            case 38: 
            case 44: {
                ContentModel m = (ContentModel)this.content;
                while (m != null) {
                    if (!m.empty()) {
                        return false;
                    }
                    m = m.next;
                }
                return true;
            }
        }
        return false;
    }

    public boolean first(Object token) {
        switch (this.type) {
            case 42: 
            case 43: 
            case 63: {
                return ((ContentModel)this.content).first(token);
            }
            case 44: {
                ContentModel m = (ContentModel)this.content;
                while (m != null) {
                    if (m.first(token)) {
                        return true;
                    }
                    if (!m.empty()) {
                        return false;
                    }
                    m = m.next;
                }
                return false;
            }
            case 38: 
            case 124: {
                ContentModel m = (ContentModel)this.content;
                while (m != null) {
                    if (m.first(token)) {
                        return true;
                    }
                    m = m.next;
                }
                return false;
            }
        }
        return this.content.equals(token);
    }

    public Element first() {
        switch (this.type) {
            case 38: 
            case 42: 
            case 63: 
            case 124: {
                return null;
            }
            case 43: 
            case 44: {
                return ((ContentModel)this.content).first();
            }
        }
        return (Element)this.content;
    }

    public String toString() {
        switch (this.type) {
            case 42: {
                return this.content + "*";
            }
            case 63: {
                return this.content + "?";
            }
            case 43: {
                return this.content + "+";
            }
            case 38: 
            case 44: 
            case 124: {
                char[] data = new char[]{' ', (char)this.type, ' '};
                String str = "";
                ContentModel m = (ContentModel)this.content;
                while (m != null) {
                    str = str + m;
                    if (m.next != null) {
                        str = str + new String(data);
                    }
                    m = m.next;
                }
                return "(" + str + ")";
            }
        }
        return this.content.toString();
    }
}

