/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.micp;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.w3c.www.protocol.http.micp.MICPReader;
import org.w3c.www.protocol.http.micp.Stats;

public class Probe
extends Panel
implements Runnable,
ActionListener {
    MICPReader reader = null;
    Stats stats = null;
    long refresh = 500L;
    Label hits = null;
    Label queries = null;
    Label url = null;
    Button exit = null;

    public Probe(InetAddress inetAddress, int n, long l) throws UnknownHostException, IOException {
        this.refresh = l;
        this.stats = new Stats();
        this.reader = new MICPReader(inetAddress, n, this.stats);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = -1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        Label label = new Label("queries");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.queries = new Label("0");
        this.queries.setBackground(Color.white);
        gridBagLayout.setConstraints(this.queries, gridBagConstraints2);
        this.add(this.queries);
        label = new Label("hits");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.hits = new Label("0");
        this.hits.setBackground(Color.white);
        gridBagLayout.setConstraints(this.hits, gridBagConstraints2);
        this.add(this.hits);
        label = new Label("url");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.url = new Label("0");
        this.url.setBackground(Color.white);
        gridBagLayout.setConstraints(this.url, gridBagConstraints2);
        this.add(this.url);
        this.exit = new Button("Exit");
        this.exit.addActionListener(this);
        gridBagLayout.setConstraints(this.exit, gridBagConstraints);
        this.add(this.exit);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exit) {
            System.out.println("Bye !");
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        InetAddress inetAddress = null;
        int n = -1;
        long l = 500L;
        int n2 = 330;
        int n3 = 130;
        try {
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4].equals("-a") && n4 + 1 < stringArray.length) {
                    inetAddress = InetAddress.getByName(stringArray[++n4]);
                } else if (stringArray[n4].equals("-p") && n4 + 1 < stringArray.length) {
                    n = Integer.parseInt(stringArray[++n4]);
                } else if (stringArray[n4].equals("-r") && n4 + 1 < stringArray.length) {
                    l = Long.parseLong(stringArray[++n4]);
                } else if (stringArray[n4].equals("-w") && n4 + 1 < stringArray.length) {
                    n2 = Integer.parseInt(stringArray[++n4]);
                } else if (stringArray[n4].equals("-h") && n4 + 1 < stringArray.length) {
                    n3 = Integer.parseInt(stringArray[++n4]);
                } else {
                    Probe.usage();
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            Probe.usage();
        }
        if (inetAddress == null || n == -1) {
            Probe.usage();
        }
        Probe probe = null;
        try {
            probe = new Probe(inetAddress, n, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        Frame frame = new Frame("mICP-Probe");
        frame.add("Center", probe);
        ((Component)frame).setSize(new Dimension(n2, n3));
        frame.show();
        new Thread(probe).start();
    }

    public void run() {
        while (true) {
            this.hits.setText(Integer.toString(this.stats.getHits()));
            this.queries.setText(Integer.toString(this.stats.getQueries()));
            this.url.setText(this.stats.getLastURL());
            this.tick();
        }
    }

    protected synchronized void tick() {
        try {
            this.wait(this.refresh);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void usage() {
        PrintStream printStream = System.out;
        printStream.println("Probe -a <addr> -p <port> -r <refresh> -w <width> -h <height>");
        printStream.println("\taddr: multicast group address");
        printStream.println("\tport: multicast port");
        printStream.println("\trefresh: refresh interval in ms");
        printStream.println("\twidth: width at startup (pixels)");
        printStream.println("\theight: height at startup (pixels)");
        System.exit(1);
    }
}

