/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.w3c.www.http.ChunkedOutputStream;
import org.w3c.www.http.HTTP;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.protocol.http.ConnectedEvent;
import org.w3c.www.protocol.http.ContinueEvent;
import org.w3c.www.protocol.http.HttpBasicConnection;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.HttpServer;
import org.w3c.www.protocol.http.HttpServerState;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestEvent;
import org.w3c.www.protocol.http.RequestObserver;

public class HttpBasicServer
extends HttpServer {
    private static final String STATE_CONNECTION = "org.w3c.www.protocol.http.HttpBasicServer.connection";
    private static final String PROTOCOL = "http";
    private static final boolean debug = false;
    protected static final int RQ_HTTP11 = 1;
    protected static final int RQ_HTTP11_TS = 2;
    protected static final int RQ_HTTP10 = 3;
    protected static final int RQ_HTTP10_KA = 4;
    protected static final int RQ_UNKNOWN = 5;
    protected HttpManager manager = null;
    protected String host = null;
    protected int port = -1;
    protected int timeout = 300000;
    protected int conn_timeout = 3000;
    boolean contacted = false;
    short major = (short)-1;
    short minor = (short)-1;
    boolean keepalive = false;
    InetAddress[] addrs = null;
    int addrptr = 0;
    Date lookupLimit = null;
    protected int connid = 0;

    HttpBasicServer() {
    }

    protected HttpBasicConnection allocateConnection() throws IOException {
        Object object;
        HttpBasicConnection httpBasicConnection;
        block14: {
            httpBasicConnection = null;
            try {
                this.updateHostAddr();
            }
            catch (HttpException httpException) {
                if (this.addrs != null) break block14;
                throw new IOException(httpException.getMessage());
            }
        }
        int n = 0;
        while (n < this.addrs.length) {
            object = null;
            int n2 = this.addrptr;
            while ((object = this.addrs[n2]) == null && (n2 = (n2 + 1) % this.addrs.length) != this.addrptr) {
            }
            this.addrptr = (this.addrptr + 1) % this.addrs.length;
            if (object == null) {
                throw new IOException("Host " + this.host + " resolved to a null" + " InetAddr");
            }
            try {
                int n3;
                HttpBasicServer httpBasicServer = this;
                synchronized (httpBasicServer) {
                    n3 = this.connid++;
                }
                httpBasicConnection = new HttpBasicConnection(this, n3, (InetAddress)object, this.port, this.timeout, this.conn_timeout, this.manager.getReplyFactory());
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                ++n;
            }
        }
        if (httpBasicConnection == null) {
            throw new IOException("Unable to connect to " + this.host);
        }
        object = this.manager;
        synchronized (object) {
            this.state.incrConnectionCount();
            this.manager.notifyConnection(httpBasicConnection);
        }
        return httpBasicConnection;
    }

    public void deleteConnection(HttpConnection httpConnection) {
        HttpManager httpManager = this.manager;
        synchronized (httpManager) {
            this.state.decrConnectionCount();
            this.state.unregisterConnection(httpConnection);
            this.manager.deleteConnection(httpConnection);
        }
    }

    protected Reply doRequest(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        if (request.isInterrupted()) {
            throw new IOException("Interrupted Request");
        }
        request.setState(STATE_CONNECTION, httpBasicConnection);
        switch (this.getRequestMode(request)) {
            case 1: {
                return this.http11_run(httpBasicConnection, request);
            }
            case 2: {
                return this.http11_ts_run(httpBasicConnection, request);
            }
            case 4: {
                return this.http10_ka_run(httpBasicConnection, request);
            }
            case 3: {
                return this.http10_run(httpBasicConnection, request);
            }
            case 5: {
                return this.http_unknown(httpBasicConnection, request);
            }
        }
        throw new RuntimeException("Implementation bug.");
    }

    protected HttpBasicConnection getConnection() throws IOException {
        int n = 0;
        while (n < 3) {
            HttpBasicConnection httpBasicConnection = null;
            while ((httpBasicConnection = (HttpBasicConnection)this.manager.getConnection(this)) != null) {
                block8: {
                    try {
                        if (HttpBasicConnection.sock_m != null) break block8;
                        httpBasicConnection.input.available();
                    }
                    catch (IOException iOException) {
                        httpBasicConnection.close();
                        continue;
                    }
                }
                if (!httpBasicConnection.markUsed()) continue;
                return httpBasicConnection;
            }
            if (this.manager.negotiateConnection(this)) {
                httpBasicConnection = this.allocateConnection();
                if (httpBasicConnection.markUsed()) {
                    return httpBasicConnection;
                }
                return null;
            }
            try {
                long l = System.currentTimeMillis();
                this.manager.waitForConnection(this);
                long l2 = System.currentTimeMillis();
                if (l2 - l <= 20000L) continue;
                ++n;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        return null;
    }

    public short getMajorVersion() {
        return this.major;
    }

    public short getMinorVersion() {
        return this.minor;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    protected int getRequestMode(Request request) {
        if (!this.contacted || this.major < 1) {
            return 5;
        }
        if (this.minor < 1) {
            return this.keepalive ? 4 : 3;
        }
        return this.isTwoStage_11(request) ? 2 : 1;
    }

    protected Reply http10_ka_run(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        String string = request.getExpect();
        if (string != null && string.equalsIgnoreCase("100-continue")) {
            reply = request.makeReply(417);
            reply.setContent("100-continue is not supported by upstream HTTP/1.0 Server");
            return reply;
        }
        if (request.getConnection() == null) {
            if (request.hasProxy()) {
                request.addProxyConnection("Keep-Alive");
            } else {
                request.addConnection("Keep-Alive");
            }
        }
        try {
            request.emit(outputStream, 1);
            outputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        if (requestObserver != null) {
            this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
        }
        if (this.isTwoStage_10(request)) {
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, new ContinueEvent(this, request));
            }
            request.emit(outputStream, 12);
            outputStream.flush();
        }
        try {
            reply = (Reply)mimeParser.parse(this.manager.isLenient());
            while (reply.getStatus() / 100 == 1) {
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                }
                reply = null;
                reply = (Reply)mimeParser.parse(this.manager.isLenient());
            }
        }
        catch (IOException iOException) {
            if (this.isTwoStage_10(request)) {
                try {
                    reply = (Reply)mimeParser.parse(this.manager.isLenient());
                }
                catch (MimeParserException mimeParserException) {
                    return null;
                }
                try {
                    request.getOutputStream().close();
                }
                catch (Exception exception) {}
                return reply;
            }
            return null;
        }
        catch (MimeParserException mimeParserException) {}
        if (reply != null) {
            httpBasicConnection.setCloseOnEOF(reply.hasConnection("close"));
        }
        return reply;
    }

    protected Reply http10_run(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        String string = request.getExpect();
        if (string != null && string.equalsIgnoreCase("100-continue")) {
            reply = request.makeReply(417);
            reply.setContent("100-continue is not supported by upstream HTTP/1.0 Server");
            return reply;
        }
        request.emit(outputStream, 1);
        outputStream.flush();
        if (requestObserver != null) {
            this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            if (this.isTwoStage_10(request)) {
                this.notifyObserver(requestObserver, new ContinueEvent(this, request));
            }
        }
        try {
            request.emit(outputStream, 12);
            outputStream.flush();
        }
        catch (IOException iOException) {
            if (this.isTwoStage_10(request)) {
                try {
                    reply = (Reply)mimeParser.parse(this.manager.isLenient());
                }
                catch (MimeParserException mimeParserException) {
                    throw iOException;
                }
                if (reply != null) {
                    try {
                        request.getOutputStream().close();
                    }
                    catch (Exception exception) {}
                    return reply;
                }
            }
            throw iOException;
        }
        try {
            reply = (Reply)mimeParser.parse(this.manager.isLenient());
            while (reply.getStatus() / 100 == 1) {
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                }
                reply = null;
                reply = (Reply)mimeParser.parse(this.manager.isLenient());
            }
        }
        catch (MimeParserException mimeParserException) {}
        httpBasicConnection.setCloseOnEOF(true);
        return reply;
    }

    protected Reply http11_run(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        Object object;
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        boolean bl = false;
        if (request.hasOutputStream() && request.getContentLength() < 0) {
            bl = true;
            object = request.getTransferEncoding();
            if (object == null) {
                request.addTransferEncoding("chunked");
            } else {
                boolean bl2 = true;
                int n = 0;
                while (!bl2 && n < ((String[])object).length) {
                    bl2 = bl2 && !((String)object[n]).equals("chunked");
                    ++n;
                }
                if (bl2) {
                    request.addTransferEncoding("chunked");
                } else if (outputStream instanceof ChunkedOutputStream) {
                    bl = false;
                }
            }
        }
        try {
            request.emit(outputStream, 1);
            outputStream.flush();
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            }
            if (request.hasOutputStream()) {
                object = request.getExpect();
                if (object != null && ((String)object).equalsIgnoreCase("100-continue") && requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent(this, request));
                }
                if (bl) {
                    DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                    ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(dataOutputStream);
                    request.emit(chunkedOutputStream, 4);
                    chunkedOutputStream.flush();
                    chunkedOutputStream.close(false);
                    request.emit(outputStream, 8);
                } else {
                    request.emit(outputStream, 12);
                }
                outputStream.flush();
            }
            reply = (Reply)mimeParser.parse(this.manager.isLenient());
            while (reply.getStatus() / 100 == 1) {
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                }
                reply = (Reply)mimeParser.parse(this.manager.isLenient());
            }
        }
        catch (MimeParserException mimeParserException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (reply != null) {
            httpBasicConnection.setCloseOnEOF(reply.hasConnection("close"));
        }
        return reply;
    }

    protected Reply http11_ts_run(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        boolean bl = false;
        if (request.getContentLength() < 0) {
            bl = true;
            String[] stringArray = request.getTransferEncoding();
            if (stringArray == null) {
                request.addTransferEncoding("chunked");
            } else {
                boolean bl2 = true;
                int n = 0;
                while (!bl2 && n < stringArray.length) {
                    bl2 = bl2 && !stringArray[n].equals("chunked");
                    ++n;
                }
                if (bl2) {
                    request.addTransferEncoding("chunked");
                } else if (outputStream instanceof ChunkedOutputStream) {
                    bl = false;
                }
            }
        }
        try {
            request.emit(outputStream, 1);
            outputStream.flush();
            if (requestObserver != null) {
                this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            }
            reply = (Reply)mimeParser.parse(this.manager.isLenient());
            boolean bl3 = false;
            while (reply.getStatus() / 100 == 1 || reply.getStatus() == 417) {
                if (reply.getStatus() == 417) {
                    return reply;
                }
                reply = null;
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                }
                if (!bl3) {
                    bl3 = true;
                    if (bl) {
                        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                        ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(dataOutputStream);
                        request.emit(chunkedOutputStream, 4);
                        chunkedOutputStream.flush();
                        chunkedOutputStream.close(false);
                        request.emit(outputStream, 8);
                    } else {
                        request.emit(outputStream, 12);
                    }
                    outputStream.flush();
                }
                reply = (Reply)mimeParser.parse(this.manager.isLenient());
                while (reply.getStatus() / 100 == 1) {
                    if (requestObserver != null) {
                        this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                    }
                    reply = (Reply)mimeParser.parse(this.manager.isLenient());
                }
            }
        }
        catch (MimeParserException mimeParserException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (reply != null) {
            httpBasicConnection.setCloseOnEOF(reply.hasConnection("close"));
        }
        return reply;
    }

    protected Reply http_unknown(HttpBasicConnection httpBasicConnection, Request request) throws IOException, MimeParserException {
        boolean bl = false;
        if (request.getConnection() == null) {
            if (request.hasProxy()) {
                request.addProxyConnection("Keep-Alive");
            } else {
                request.addConnection("Keep-Alive");
            }
        }
        RequestObserver requestObserver = request.getObserver();
        OutputStream outputStream = httpBasicConnection.getOutputStream();
        MimeParser mimeParser = httpBasicConnection.getParser();
        Reply reply = null;
        request.emit(outputStream, 1);
        if (requestObserver != null) {
            this.notifyObserver(requestObserver, new ConnectedEvent((HttpServer)this, request, outputStream));
            if (this.isTwoStage_10(request)) {
                bl = true;
                this.notifyObserver(requestObserver, new ContinueEvent(this, request));
            }
        }
        try {
            request.emit(outputStream, 12);
            outputStream.flush();
        }
        catch (IOException iOException) {
            if (this.isTwoStage_10(request)) {
                try {
                    reply = (Reply)mimeParser.parse(this.manager.isLenient());
                }
                catch (MimeParserException mimeParserException) {
                    throw iOException;
                }
                if (reply != null) {
                    try {
                        request.getOutputStream().close();
                    }
                    catch (Exception exception) {}
                    return reply;
                }
            }
            throw iOException;
        }
        try {
            reply = (Reply)mimeParser.parse(this.manager.isLenient());
            while (reply.getStatus() / 100 == 1) {
                if (bl) {
                    bl = false;
                    continue;
                }
                if (requestObserver != null) {
                    this.notifyObserver(requestObserver, new ContinueEvent((HttpServer)this, request, reply));
                }
                reply = (Reply)mimeParser.parse(this.manager.isLenient());
            }
            if (reply != null) {
                this.updateServerInfo(reply);
            }
        }
        catch (MimeParserException mimeParserException) {}
        if (reply != null) {
            if (this.major == 1 && (this.minor == 1 || this.keepalive)) {
                httpBasicConnection.setCloseOnEOF(false);
            } else {
                httpBasicConnection.setCloseOnEOF(true);
            }
        }
        return reply;
    }

    public void initialize(HttpManager httpManager, HttpServerState httpServerState, String string, int n, int n2) throws HttpException {
        this.initialize(httpManager, httpServerState, string, n, n2, this.conn_timeout);
    }

    public void initialize(HttpManager httpManager, HttpServerState httpServerState, String string, int n, int n2, int n3) throws HttpException {
        this.manager = httpManager;
        this.state = httpServerState;
        this.host = string;
        this.port = n;
        this.timeout = n2;
        this.conn_timeout = n3;
        this.lookupLimit = null;
        this.updateHostAddr();
        this.state.state = 2;
    }

    protected void interruptRequest(Request request) {
        HttpBasicConnection httpBasicConnection = null;
        httpBasicConnection = (HttpBasicConnection)request.getState(STATE_CONNECTION);
        if (httpBasicConnection != null) {
            httpBasicConnection.markIdle(true);
        }
    }

    protected boolean isTwoStage_10(Request request) {
        return request.hasOutputStream();
    }

    protected boolean isTwoStage_11(Request request) {
        boolean bl = request.hasOutputStream();
        return bl && request.getExpect() != null;
    }

    protected void notifyObserver(RequestObserver requestObserver, Request request, int n) {
        RequestEvent requestEvent = new RequestEvent(this, request, n);
        requestObserver.notifyProgress(requestEvent);
    }

    protected void notifyObserver(RequestObserver requestObserver, RequestEvent requestEvent) {
        requestObserver.notifyProgress(requestEvent);
    }

    public void registerConnection(HttpConnection httpConnection) {
        HttpManager httpManager = this.manager;
        synchronized (httpManager) {
            this.state.registerConnection(httpConnection);
            this.manager.notifyIdle(httpConnection);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Reply runRequest(Request var1_1) throws HttpException {
        var2_2 = var1_1.getObserver();
        var3_3 = null;
        var4_4 = null;
        var5_5 /* !! */  = null;
        try {
            if (var2_2 != null) {
                this.notifyObserver(var2_2, var1_1, RequestEvent.EVT_QUEUED);
            }
            var6_6 = 1;
            if (!(var1_1.hasOutputStream() || (var7_9 = var1_1.getMethod()).length() > 6 || (var7_9 = var7_9.intern()) != HTTP.GET && var7_9 != HTTP.HEAD && var7_9 != HTTP.OPTIONS && var7_9 != HTTP.TRACE)) {
                var6_6 = 3;
            }
            var7_10 = 0;
            while (var4_4 == null && var7_10 < var6_6) {
                block36: {
                    block37: {
                        var3_3 = this.getConnection();
                        if (var3_3 == null) break block36;
                        if (var6_6 != 1) break block37;
                        if (!this.manager.keepbody) ** GOTO lbl27
                        if (!var1_1.hasOutputStream()) break block37;
                        var8_11 = new BufferedInputStream(var1_1.getOutputStream());
                        var1_1.setOutputStream((InputStream)var8_11);
                        var9_14 = var1_1.getContentLength();
                        if (var9_14 < 0) {
                            var9_14 = 65536;
                        }
                        var8_11.mark(var9_14);
                        break block37;
lbl-1000:
                        // 1 sources

                        {
                            var3_3.markIdle(true);
                            var3_3 = this.getConnection();
lbl27:
                            // 2 sources

                            ** while (var3_3.cached)
                        }
                    }
                    try {
                        var4_4 = this.doRequest(var3_3, var1_1);
                        if (var4_4 == null) {
                            if (var3_3.cached) {
                                --var7_10;
                                if (var1_1.hasOutputStream() && this.manager.keepbody) {
                                    var1_1.getOutputStream().reset();
                                }
                            }
                            var3_3.markIdle(true);
                        }
                    }
                    catch (MimeParserException var8_12) {
                        var5_5 /* !! */  = var8_12;
                        var3_3.markIdle(true);
                        throw var8_12;
                    }
                    catch (Exception var8_13) {
                        var5_5 /* !! */  = var8_13;
                        try {
                            try {
                                if (var1_1.hasOutputStream()) {
                                    var1_1.getOutputStream().reset();
                                }
                            }
                            catch (IOException v0) {
                            }
                            var10_16 = null;
                            var3_3.markIdle(true);
                        }
                        catch (Throwable var9_15) {
                            var10_16 = null;
                            var3_3.markIdle(true);
                            throw var9_15;
                        }
                    }
                    catch (Throwable v1) {
                        var3_3.markIdle(true);
                    }
                }
                ++var7_10;
            }
            if (var1_1.hasOutputStream()) {
                var1_1.getOutputStream().close();
            }
            if (var4_4 == null) {
                var8_11 = "Unable to contact target server " + this + " after " + var6_6 + " tries.";
                if (var2_2 != null) {
                    this.notifyObserver(var2_2, var1_1, RequestEvent.EVT_UNREACHABLE);
                }
                if (var5_5 /* !! */  != null) {
                    throw new HttpException(var1_1, null, var5_5 /* !! */ , (String)var8_11);
                }
                throw new HttpException(var1_1, (String)var8_11);
            }
            var4_4.matchesRequest(var1_1);
            if (var2_2 != null) {
                this.notifyObserver(var2_2, var1_1, RequestEvent.EVT_REPLIED);
            }
            if (var4_4.keepsAlive()) {
                var4_4.setStreamObserver(var3_3);
                if (!var4_4.hasInputStream()) {
                    var3_3.markIdle(false);
                }
            } else {
                var3_3.detach();
            }
        }
        catch (IOException var6_7) {
            var6_7.printStackTrace();
            if (var3_3 != null) {
                var3_3.markIdle(true);
            }
            if (var2_2 != null) {
                this.notifyObserver(var2_2, var1_1, RequestEvent.EVT_CLOSED);
            }
            throw new HttpException(var1_1, (Exception)var6_7);
        }
        catch (MimeParserException var6_8) {
            var6_8.printStackTrace();
            if (var3_3 != null) {
                var3_3.markIdle(true);
            }
            if (var2_2 != null) {
                this.notifyObserver(var2_2, var1_1, RequestEvent.EVT_CLOSED);
            }
            throw new HttpException(var1_1, (Exception)var6_8);
        }
        return var4_4;
    }

    public synchronized void setConnTimeout(int n) {
        this.conn_timeout = n;
    }

    protected void setHostAddr(InetAddress[] inetAddressArray) {
        this.addrs = inetAddressArray;
        this.addrptr = 0;
        this.lookupLimit = new Date(System.currentTimeMillis() + 300000L);
    }

    public synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public synchronized void unregisterConnection(HttpConnection httpConnection) {
        this.manager.notifyUse(httpConnection);
    }

    protected void updateHostAddr() throws HttpException {
        Date date = new Date();
        if (this.lookupLimit == null || this.lookupLimit.before(date)) {
            try {
                int n = this.host.length();
                boolean bl = true;
                int n2 = 0;
                while (n2 < n) {
                    char c = this.host.charAt(n2);
                    bl = (c <= '9' && c >= '0' || c == '.') ^ true;
                    if (bl) break;
                    ++n2;
                }
                InetAddress[] inetAddressArray = bl ? InetAddress.getAllByName(this.host) : new InetAddress[]{InetAddress.getByName(this.host)};
                if (inetAddressArray != null) {
                    this.setHostAddr(inetAddressArray);
                }
            }
            catch (UnknownHostException unknownHostException) {
                HttpException httpException;
                String string = "The host name [" + this.host + "] couldn't be resolved. " + "Details: \"" + unknownHostException.getMessage() + "\"";
                this.state.ex = httpException = new HttpException(unknownHostException, string);
                this.state.state = 1;
                throw httpException;
            }
        }
    }

    protected synchronized void updateServerInfo(Reply reply) {
        if (this.contacted) {
            return;
        }
        this.major = reply.getMajorVersion();
        this.minor = reply.getMinorVersion();
        this.keepalive = reply.keepsAlive();
        this.contacted = true;
    }
}

