/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.FrameArrayAttribute;
import org.w3c.tools.resources.IllegalAttributeAccess;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ObjectAttribute;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.ServerInterface;
import org.w3c.tools.resources.SpaceEntry;
import org.w3c.tools.resources.SpaceEntryImpl;
import org.w3c.tools.resources.StringAttribute;

public class Resource
extends AttributeHolder {
    private static final boolean debugunload = false;
    protected static int ATTR_STORE_ENTRY = -1;
    protected static int ATTR_IDENTIFIER = -1;
    protected static int ATTR_RESOURCE_FRAMES = -1;
    protected static int ATTR_PARENT = -1;
    protected static int ATTR_CONTEXT = -1;
    protected static int ATTR_URL = -1;
    protected static int ATTR_LAST_MODIFIED = -1;
    protected static int ATTR_HELP_URL = -1;
    public static String id = "identifier".intern();
    public static String co = "context".intern();

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.Resource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new ObjectAttribute("parent", "org.w3c.tools.resources.Resource", null, 9);
        ATTR_PARENT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("context", "org.w3c.tools.resources.ResourceContext", null, 9);
        ATTR_CONTEXT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("store-entry", "java.lang.Object", null, 8);
        ATTR_STORE_ENTRY = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("identifier", null, 6);
        ATTR_IDENTIFIER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new FrameArrayAttribute("frames", null, 1);
        ATTR_RESOURCE_FRAMES = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("url", null, 9);
        ATTR_URL = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new DateAttribute("last-modified", (Object)null, 3);
        ATTR_LAST_MODIFIED = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringAttribute("help-url", null, 1);
        ATTR_HELP_URL = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    public boolean acceptUnload() {
        return true;
    }

    protected void checkMultipleLock(ResourceReference resourceReference) throws MultipleLockException {
        if (resourceReference.nbLock() > 1) {
            throw new MultipleLockException(resourceReference.nbLock(), this, "can't delete");
        }
    }

    public synchronized ResourceFrame[] collectFrames(Class clazz) {
        ResourceFrame[] resourceFrameArray = null;
        resourceFrameArray = (ResourceFrame[])this.getValue(ATTR_RESOURCE_FRAMES, null);
        if (resourceFrameArray != null) {
            Vector<ResourceFrame> vector = new Vector<ResourceFrame>(resourceFrameArray.length);
            int n = 0;
            while (n < resourceFrameArray.length) {
                if (clazz.isInstance(resourceFrameArray[n])) {
                    vector.addElement(resourceFrameArray[n]);
                }
                ++n;
            }
            int n2 = vector.size();
            if (n2 > 0) {
                Object[] objectArray = new ResourceFrame[n2];
                vector.copyInto(objectArray);
                return objectArray;
            }
        }
        return null;
    }

    private String computeHelpUrl() {
        try {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(this.getServer().getDocumentationURL());
            stringBuffer.append('/');
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(".html");
            return stringBuffer.toString().intern();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void delete() throws MultipleLockException {
        ResourceSpace resourceSpace = this.getSpace();
        if (resourceSpace != null && this.getSpaceEntry() != null) {
            ResourceReference resourceReference = this.getResourceReference();
            if (resourceReference != null) {
                ResourceReference resourceReference2 = resourceReference;
                synchronized (resourceReference2) {
                    this.checkMultipleLock(resourceReference);
                    resourceSpace.deleteResource(this.getSpaceEntry(), this);
                }
            } else {
                resourceSpace.deleteResource(this.getSpaceEntry(), this);
            }
        }
    }

    public Object getClone(Object[] objectArray) {
        ResourceFrame[] resourceFrameArray = (ResourceFrame[])objectArray[ATTR_RESOURCE_FRAMES];
        if (resourceFrameArray != null) {
            ResourceFrame[] resourceFrameArray2 = new ResourceFrame[resourceFrameArray.length];
            int n = 0;
            while (n < resourceFrameArray.length) {
                resourceFrameArray2[n] = resourceFrameArray[n] == null ? null : (ResourceFrame)resourceFrameArray[n].getClone();
                ++n;
            }
            objectArray[Resource.ATTR_RESOURCE_FRAMES] = resourceFrameArray2;
        }
        return super.getClone(objectArray);
    }

    protected ResourceContext getContext() {
        return (ResourceContext)this.getValue(ATTR_CONTEXT, null);
    }

    public synchronized ResourceFrame getFrame(Class clazz) {
        ResourceFrame[] resourceFrameArray = null;
        resourceFrameArray = (ResourceFrame[])this.getValue(ATTR_RESOURCE_FRAMES, null);
        if (resourceFrameArray != null) {
            int n = 0;
            while (n < resourceFrameArray.length) {
                if (clazz.isInstance(resourceFrameArray[n])) {
                    return resourceFrameArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public synchronized ResourceFrame[] getFrames() {
        return (ResourceFrame[])this.getValue(ATTR_RESOURCE_FRAMES, null);
    }

    public String getHelpURL() {
        return this.getString(ATTR_HELP_URL, null);
    }

    public String getHelpURL(String string) {
        return null;
    }

    public String getIdentifier() {
        return this.getString(ATTR_IDENTIFIER, null);
    }

    public long getLastModified() {
        return this.getLong(ATTR_LAST_MODIFIED, -1L);
    }

    public ResourceReference getParent() {
        ResourceContext resourceContext = this.unsafeGetContext();
        if (resourceContext == null) {
            return null;
        }
        return resourceContext.getContainer();
    }

    public ResourceReference getResourceReference() {
        ResourceContext resourceContext = this.getContext();
        if (resourceContext != null) {
            return resourceContext.getResourceReference();
        }
        return null;
    }

    public ServerInterface getServer() {
        return ((ResourceContext)this.unsafeGetValue(ATTR_CONTEXT, null)).getServer();
    }

    protected ResourceSpace getSpace() {
        ResourceContext resourceContext = this.getContext();
        if (resourceContext != null) {
            return resourceContext.getSpace();
        }
        return null;
    }

    protected SpaceEntry getSpaceEntry() {
        ResourceReference resourceReference = this.getParent();
        if (resourceReference != null) {
            try {
                try {
                    ContainerResource containerResource = (ContainerResource)resourceReference.lock();
                    SpaceEntryImpl spaceEntryImpl = new SpaceEntryImpl(containerResource);
                    Object var4_5 = null;
                    resourceReference.unlock();
                    return spaceEntryImpl;
                }
                catch (InvalidResourceException invalidResourceException) {
                    SpaceEntry spaceEntry = null;
                    Object var4_6 = null;
                    resourceReference.unlock();
                    return spaceEntry;
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                resourceReference.unlock();
                throw throwable;
            }
        }
        return null;
    }

    public Object getStoreEntry() {
        return this.getValue(ATTR_STORE_ENTRY, null);
    }

    public String getURLPath() {
        return this.getString(ATTR_URL, null);
    }

    public synchronized Object getValue(int n, Object object) {
        if (n == ATTR_HELP_URL && this.values[ATTR_HELP_URL] == null) {
            this.values[Resource.ATTR_HELP_URL] = this.computeHelpUrl();
        }
        return super.getValue(n, object);
    }

    public synchronized Object getValue(Class clazz, int n, Object object) {
        ResourceFrame resourceFrame = this.getFrame(clazz);
        if (resourceFrame != null) {
            return resourceFrame.getValue(n, object);
        }
        throw new IllegalAttributeAccess((AttributeHolder)this, n);
    }

    public void initialize(Hashtable hashtable) {
        Object[] objectArray = this.values == null ? new Object[this.attributes.length] : this.values;
        int n = 0;
        while (n < objectArray.length) {
            String string = this.attributes[n].getName();
            Object v = hashtable.get(string);
            if (objectArray[n] == null) {
                objectArray[n] = n == ATTR_HELP_URL && v != null && v instanceof String ? ((String)v).intern() : v;
            }
            ++n;
        }
        this.initialize(objectArray);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
    }

    public boolean isInitialized() {
        return this.values != null;
    }

    public boolean isUnloaded() {
        return this.values == null;
    }

    public void markModified() {
        ResourceSpace resourceSpace = this.getSpace();
        if (resourceSpace != null && this.getSpaceEntry() != null) {
            Resource resource = this;
            synchronized (resource) {
                resourceSpace.markModified(this.getSpaceEntry(), this);
            }
        }
        super.setValue(ATTR_LAST_MODIFIED, (Object)new Long(System.currentTimeMillis()));
    }

    public void notifyUnload() {
        this.values = null;
    }

    public void pickleValues(Hashtable hashtable) {
        Object[] objectArray = new Object[this.attributes.length];
        int n = 0;
        while (n < objectArray.length) {
            String string = this.attributes[n].getName();
            Object v = hashtable.get(string);
            objectArray[n] = n == ATTR_HELP_URL && v != null && v instanceof String ? ((String)v).intern() : v;
            ++n;
        }
        this.values = objectArray;
    }

    public void registerFrame(ResourceFrame resourceFrame, Hashtable hashtable) {
        Resource resource = this;
        synchronized (resource) {
            ResourceFrame[] resourceFrameArray = null;
            resourceFrameArray = (ResourceFrame[])this.getValue(ATTR_RESOURCE_FRAMES, null);
            if (hashtable.get(id) == null) {
                String string = "frame-" + (resourceFrameArray == null ? 0 : resourceFrameArray.length);
                hashtable.put(id, string.intern());
            }
            resourceFrame.initialize(hashtable);
            if (resourceFrameArray == null) {
                resourceFrameArray = new ResourceFrame[]{resourceFrame};
            } else {
                int n = -1;
                int n2 = 0;
                while (n2 < resourceFrameArray.length) {
                    if (resourceFrameArray[n2] == null) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                if (n >= 0) {
                    resourceFrameArray[n] = resourceFrame;
                } else {
                    ResourceFrame[] resourceFrameArray2 = new ResourceFrame[resourceFrameArray.length + 1];
                    System.arraycopy(resourceFrameArray, 0, resourceFrameArray2, 0, resourceFrameArray.length);
                    resourceFrameArray2[resourceFrameArray.length] = resourceFrame;
                    resourceFrameArray = resourceFrameArray2;
                }
            }
            this.setValue(ATTR_RESOURCE_FRAMES, (Object)resourceFrameArray);
        }
    }

    protected void setContext(ResourceContext resourceContext) {
        resourceContext.setResourceReference(this.getResourceReference());
        this.setValue(ATTR_CONTEXT, (Object)resourceContext);
    }

    protected void setContext(ResourceContext resourceContext, boolean bl) {
        ResourceContext resourceContext2;
        resourceContext.setResourceReference(this.getResourceReference());
        if (bl && (resourceContext2 = this.getContext()) != null) {
            resourceContext.modules = resourceContext2.modules;
        }
        this.setValue(ATTR_CONTEXT, (Object)resourceContext);
    }

    public void setValue(int n, Object object) {
        if (n == ATTR_IDENTIFIER) {
            Object object2;
            String string = this.getIdentifier();
            super.setValue(n, object);
            if (this.getSpaceEntry() != null) {
                object2 = this.getSpace();
                object2.renameResource(this.getSpaceEntry(), string, (String)object);
            }
            if ((object2 = this.getParent()) != null) {
                try {
                    try {
                        Resource resource = object2.lock();
                        this.setValue(ATTR_URL, (Object)(String.valueOf(resource.getURLPath()) + URLEncoder.encode((String)object)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Object var6_8 = null;
                    object2.unlock();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    object2.unlock();
                    throw throwable;
                }
            }
            this.markModified();
            return;
        }
        super.setValue(n, object);
        if (!this.attributes[n].checkFlag(8) && n != ATTR_LAST_MODIFIED) {
            this.markModified();
        }
    }

    public synchronized void setValue(Class clazz, int n, Object object) {
        ResourceFrame resourceFrame = this.getFrame(clazz);
        if (resourceFrame != null) {
            resourceFrame.setValue(n, object);
            this.markModified();
            return;
        }
        throw new IllegalAttributeAccess((AttributeHolder)this, n);
    }

    public synchronized void unregisterFrame(ResourceFrame resourceFrame) {
        ResourceFrame[] resourceFrameArray = null;
        resourceFrameArray = (ResourceFrame[])this.getValue(ATTR_RESOURCE_FRAMES, null);
        if (resourceFrameArray != null) {
            ResourceFrame[] resourceFrameArray2 = new ResourceFrame[resourceFrameArray.length - 1];
            int n = 0;
            int n2 = 0;
            while (n2 < resourceFrameArray.length) {
                if (resourceFrameArray[n2] == resourceFrame) {
                    System.arraycopy(resourceFrameArray, n2 + 1, resourceFrameArray2, n, resourceFrameArray.length - n2 - 1);
                    this.setValue(ATTR_RESOURCE_FRAMES, (Object)resourceFrameArray2);
                    return;
                }
                try {
                    resourceFrameArray2[n++] = resourceFrameArray[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return;
                }
                ++n2;
            }
        }
    }

    ResourceFrame[] unsafeCollectFrames(Class clazz) {
        ResourceFrame[] resourceFrameArray = null;
        resourceFrameArray = (ResourceFrame[])this.unsafeGetValue(ATTR_RESOURCE_FRAMES, null);
        if (resourceFrameArray != null) {
            Vector<ResourceFrame> vector = new Vector<ResourceFrame>(resourceFrameArray.length);
            int n = 0;
            while (n < resourceFrameArray.length) {
                if (clazz.isInstance(resourceFrameArray[n])) {
                    vector.addElement(resourceFrameArray[n]);
                }
                ++n;
            }
            int n2 = vector.size();
            if (n2 > 0) {
                Object[] objectArray = new ResourceFrame[n2];
                vector.copyInto(objectArray);
                return objectArray;
            }
        }
        return null;
    }

    protected ResourceContext unsafeGetContext() {
        return (ResourceContext)this.unsafeGetValue(ATTR_CONTEXT, null);
    }

    public ResourceFrame[] unsafeGetFrames() {
        return (ResourceFrame[])this.unsafeGetValue(ATTR_RESOURCE_FRAMES, null);
    }

    public String unsafeGetIdentifier() {
        return this.unsafeGetString(ATTR_IDENTIFIER, null);
    }

    public ResourceReference unsafeGetResourceReference() {
        ResourceContext resourceContext = this.unsafeGetContext();
        if (resourceContext != null) {
            return resourceContext.getResourceReference();
        }
        return null;
    }

    public String unsafeGetURLPath() {
        return this.unsafeGetString(ATTR_URL, null);
    }

    public Object unsafeGetValue(int n, Object object) {
        if (n == ATTR_HELP_URL && this.values[ATTR_HELP_URL] == null) {
            this.values[Resource.ATTR_HELP_URL] = this.computeHelpUrl();
        }
        return super.unsafeGetValue(n, object);
    }

    public void updateAttributes() {
    }
}

