/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.offline.browse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.tools.offline.browse.InvalidStoreException;
import org.w3c.tools.offline.browse.ResourceLister;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.serialization.xml.XMLSerializer;

public class RepositoryFinder {
    protected String repository_dir = null;
    protected String repository_name = null;
    protected String store_dir = null;
    protected ResourceLister rl = null;
    protected File file = null;
    protected Serializer serializer = null;
    private Hashtable containers = null;
    private AttributeHolder[] holders = null;
    private Reader reader = null;
    private Writer writer = null;
    protected static Perl5Matcher pmatcher = new Perl5Matcher();
    protected static Perl5Compiler pcompiler = new Perl5Compiler();

    public RepositoryFinder(String string, String string2) throws InvalidStoreException {
        int n = string2.indexOf(47, 0);
        if (n != -1) {
            this.repository_dir = string2.substring(0, n);
            this.repository_name = string2.substring(n + 1, string2.length());
        } else {
            this.repository_dir = "";
            this.repository_name = string2;
        }
        this.store_dir = string;
        this.rl = new ResourceLister();
        this.containers = new Hashtable();
        this.serializer = new XMLSerializer();
        File file = new File(String.valueOf(this.store_dir) + "/" + this.repository_dir, this.repository_name);
        try {
            this.reader = new BufferedReader(new FileReader(file));
            this.holders = this.serializer.readAttributeHolders(this.reader);
            int n2 = 0;
            while (n2 < this.holders.length) {
                if (this.rl.getKeyFromHolder(this.holders[n2]) != null) {
                    this.containers.put(this.rl.getKeyFromHolder(this.holders[n2]), this.holders[n2]);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to read repository");
            throw new InvalidStoreException("inexistent repository");
        }
    }

    public AttributeHolder getAttributeHolder(String string) {
        int n = 0;
        while (n < this.holders.length) {
            if (this.rl.getIdentFromHolder(this.holders[n]).compareTo(string) == 0) {
                return this.holders[n];
            }
            ++n;
        }
        return null;
    }

    public AttributeHolder[] getAttributeHolders() {
        return this.holders;
    }

    public String getRep() {
        return String.valueOf(this.repository_dir) + "/" + this.repository_name;
    }

    public void writeHolders() {
        File file = new File(String.valueOf(this.store_dir) + "/" + this.repository_dir, String.valueOf(this.repository_name) + ".tmp");
        File file2 = new File(String.valueOf(this.store_dir) + "/" + this.repository_dir, String.valueOf(this.repository_name) + ".bak");
        File file3 = new File(String.valueOf(this.store_dir) + "/" + this.repository_dir, this.repository_name);
        try {
            this.writer = new BufferedWriter(new FileWriter(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Unable to open temp rep for write");
        }
        try {
            this.serializer.writeResources(this.holders, this.writer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Unable to write repository");
        }
        if (!file3.renameTo(file2)) {
            System.out.println("unable to rename " + file3 + " to " + file2);
        } else if (!file.renameTo(file3)) {
            file2.renameTo(file3);
            System.out.println("unable to rename " + file + " to " + file3);
        }
    }
}

