/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.tools.jpeg.JpegException;

public class JpegCommentWriter
extends Writer {
    private static final boolean debug = true;
    InputStream inJpegData;
    OutputStream outJpegData;
    ByteArrayOutputStream byteStream;
    OutputStreamWriter osw;
    boolean init;
    int lastMarker;

    public JpegCommentWriter(OutputStream outputStream, InputStream inputStream) {
        super(outputStream);
        this.inJpegData = inputStream;
        this.outJpegData = outputStream;
        this.byteStream = new ByteArrayOutputStream(65536);
        this.osw = new OutputStreamWriter(this.byteStream);
        this.init = false;
    }

    public JpegCommentWriter(OutputStream outputStream, InputStream inputStream, String string) throws UnsupportedEncodingException {
        super(outputStream);
        this.inJpegData = inputStream;
        this.outJpegData = outputStream;
        this.byteStream = new ByteArrayOutputStream(65536);
        this.osw = new OutputStreamWriter((OutputStream)this.byteStream, string);
        this.init = false;
    }

    public void close() throws IOException {
        int n;
        this.flush();
        byte[] byArray = new byte[1024];
        this.writeMarker(this.lastMarker);
        while ((n = this.inJpegData.read(byArray)) >= 0) {
            this.outJpegData.write(byArray, 0, n);
            if (n >= 0) continue;
        }
    }

    protected void dupFirstHeaders() throws IOException {
        try {
            this.dupFirstMarker();
        }
        catch (JpegException jpegException) {
            jpegException.printStackTrace();
            throw new IOException(jpegException.getMessage());
        }
        block12: while (true) {
            int n = this.nextMarker();
            switch (n) {
                case 218: {
                    continue block12;
                }
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 197: 
                case 198: 
                case 199: 
                case 201: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 207: {
                    this.lastMarker = n;
                    return;
                }
                case 217: {
                    this.lastMarker = n;
                    return;
                }
                case 236: 
                case 254: {
                    try {
                        this.skipVariable();
                        continue block12;
                    }
                    catch (JpegException jpegException) {
                        jpegException.printStackTrace();
                        throw new IOException(jpegException.getMessage());
                    }
                }
            }
            try {
                this.dupHeader(n);
            }
            catch (JpegException jpegException) {
                jpegException.printStackTrace();
                throw new IOException(jpegException.getMessage());
            }
        }
    }

    protected int dupFirstMarker() throws IOException, JpegException {
        int n = this.inJpegData.read();
        int n2 = this.inJpegData.read();
        if (n != 255 || n2 != 216) {
            throw new JpegException("Not a JPEG file");
        }
        this.outJpegData.write(n);
        this.outJpegData.write(n2);
        return n2;
    }

    protected void dupHeader(int n) throws IOException, JpegException {
        int n2 = this.read2bytes();
        if (n2 < 2) {
            throw new JpegException("Erroneous JPEG marker length");
        }
        this.writeMarker(n);
        this.writeMarkerLength(n2);
        byte[] byArray = new byte[1024];
        n2 -= 2;
        while (n2 > 0) {
            int n3 = this.inJpegData.read(byArray, 0, Math.min(byArray.length, n2));
            if (n3 < 0) {
                throw new IOException("Error while reading jpeg stream (EOF)");
            }
            this.outJpegData.write(byArray, 0, n3);
            n2 -= n3;
        }
    }

    public void flush() throws IOException {
        byte[] byArray;
        if (!this.init) {
            this.dupFirstHeaders();
            this.init = true;
        }
        this.osw.flush();
        ByteArrayOutputStream byteArrayOutputStream = this.byteStream;
        synchronized (byteArrayOutputStream) {
            byArray = this.byteStream.toByteArray();
            this.byteStream.reset();
        }
        int n = byArray.length;
        int n2 = 0;
        while (n > 0) {
            this.writeMarker(254);
            int n3 = Math.min(65500, n);
            this.writeMarkerLength(n3 + 2);
            this.outJpegData.write(byArray, n2, n3);
            n2 += n3;
            n -= n3;
        }
    }

    public String getEncoding() {
        return this.osw.getEncoding();
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            JpegCommentWriter jpegCommentWriter = new JpegCommentWriter(System.out, new FileInputStream(file));
            jpegCommentWriter.write(stringArray[1]);
            jpegCommentWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int nextMarker() throws IOException {
        boolean bl = false;
        int n = this.inJpegData.read();
        while (n != 255) {
            n = this.inJpegData.read();
        }
        while ((n = this.inJpegData.read()) == 255) {
        }
        return n;
    }

    protected int read2bytes() throws IOException, JpegException {
        int n = this.inJpegData.read();
        if (n == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        int n2 = this.inJpegData.read();
        if (n2 == -1) {
            throw new JpegException("Premature EOF in JPEG file");
        }
        return (n << 8) + n2;
    }

    /*
     * Unable to fully structure code
     */
    protected void skipVariable() throws IOException, JpegException {
        var1_1 = (long)this.read2bytes() - 2L;
        if (var1_1 >= 0L) ** GOTO lbl8
        throw new JpegException("Erroneous JPEG marker length");
lbl-1000:
        // 1 sources

        {
            var3_2 = this.inJpegData.skip(var1_1);
            if (var3_2 < 0L) {
                throw new IOException("Error while reading jpeg stream");
            }
            var1_1 -= var3_2;
lbl8:
            // 2 sources

            ** while (var1_1 > 0L)
        }
lbl9:
        // 1 sources

    }

    public void write(int n) throws IOException {
        this.osw.write(n);
    }

    public void write(String string) throws IOException {
        this.osw.write(string);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.osw.write(string, n, n2);
    }

    public void write(char[] cArray) throws IOException {
        this.osw.write(cArray);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.osw.write(cArray, n, n2);
    }

    protected void writeMarker(int n) throws IOException {
        this.outJpegData.write(255);
        this.outJpegData.write(n);
    }

    protected void writeMarkerLength(int n) throws IOException {
        this.outJpegData.write(n >> 8 & 0xFF);
        this.outJpegData.write(n & 0xFF);
    }
}

