/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.webdav;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.www.webdav.xml.DAVBody;
import org.w3c.www.webdav.xml.DAVFactory;
import org.w3c.www.webdav.xml.DAVMultiStatus;
import org.w3c.www.webdav.xml.DAVNode;
import org.w3c.www.webdav.xml.DAVResponse;

public class MultiStatusException
extends Exception {
    private boolean multi = false;
    private String url = null;
    private String status = null;
    private String msg = null;
    private Document document = null;

    public MultiStatusException(String string, String string2) {
        super(String.valueOf(string) + " [" + string2 + "]");
        this.url = string;
        this.status = string2;
        this.multi = false;
    }

    public MultiStatusException(String string, String string2, String string3) {
        super(String.valueOf(string) + " [" + string2 + "] " + string3);
        this.url = string;
        this.status = string2;
        this.msg = string3;
        this.multi = false;
    }

    public MultiStatusException(Document document) {
        super("Forwarded");
        this.document = document;
        this.multi = true;
    }

    public void addResponses(Document document, DAVMultiStatus dAVMultiStatus) {
        if (this.multi) {
            Element element = this.document.getDocumentElement();
            try {
                DAVNode.exportChildren(document, dAVMultiStatus.getNode(), element, true);
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
            }
        } else {
            DAVResponse dAVResponse = null;
            dAVResponse = this.msg != null ? DAVFactory.createResponse(this.url, this.status, this.msg, document) : DAVFactory.createResponse(this.url, this.status, document);
            dAVMultiStatus.addDAVNode(dAVResponse);
        }
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = DAVBody.createDocument("multistatus");
            DAVResponse dAVResponse = null;
            dAVResponse = this.msg != null ? DAVFactory.createResponse(this.url, this.status, this.msg, this.document) : DAVFactory.createResponse(this.url, this.status, this.document);
            this.document.getDocumentElement().appendChild(dAVResponse.getNode());
        }
        return this.document;
    }
}

