/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.FrameTreeListener;
import org.w3c.jigadm.gui.ServerBrowser;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.widgets.MessagePopup;
import org.w3c.tools.widgets.NodeHandler;
import org.w3c.tools.widgets.TreeBrowser;
import org.w3c.tools.widgets.TreeNode;

public class FrameBrowser
extends TreeBrowser
implements NodeHandler {
    public static final boolean debug = false;
    Image frameopened = null;
    Image frameicon = null;
    ServerBrowser serverBrowser = null;
    FrameTreeListener tl = null;
    TreeNode lastn = null;
    RemoteResourceWrapper rootResource;
    boolean locked;
    private Dimension preferredSize = null;

    public FrameBrowser(FrameTreeListener frameTreeListener, RemoteResourceWrapper remoteResourceWrapper) {
        boolean bl = false;
        RemoteResource remoteResource = null;
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        this.serverBrowser = remoteResourceWrapper.getBrowser();
        this.tl = frameTreeListener;
        this.locked = false;
        this.frameicon = this.getImage(propertyManager.getIconLocation("frame"));
        this.frameopened = this.getImage(propertyManager.getIconLocation("frameopened"));
        this.rootResource = remoteResourceWrapper;
        String string = null;
        while (!bl) {
            Object var8_7;
            try {
                try {
                    bl = true;
                    remoteResource = remoteResourceWrapper.getResource();
                    string = (String)remoteResource.getValue("identifier");
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                    }
                    this.errorPopup("Can't read resource identifier", remoteAccessException);
                }
                var8_7 = null;
                if (bl) continue;
                this.serverBrowser.popupDialog("admin");
            }
            catch (Throwable throwable) {
                var8_7 = null;
                if (!bl) {
                    this.serverBrowser.popupDialog("admin");
                }
                throw throwable;
            }
        }
        if (string != null) {
            this.initialize(this.rootResource, string, this, this.frameicon);
        }
    }

    protected void errorPopup(String string, Exception exception) {
        new MessagePopup(String.valueOf(string) + " : " + exception.getMessage()).show();
    }

    private final Frame getFrame(Component component) {
        while (!(component instanceof Frame)) {
            if ((component = component.getParent()) != null) continue;
            return null;
        }
        return (Frame)component;
    }

    public String getFrameName(RemoteResource remoteResource) throws RemoteAccessException {
        String string = remoteResource.getClassHierarchy()[0];
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = (String)remoteResource.getValue("identifier");
        return string2.concat(" (").concat(string3).concat(")");
    }

    public String getFrameName(RemoteResource remoteResource, String string) throws RemoteAccessException {
        String string2 = remoteResource.getClassHierarchy()[0];
        String string3 = string2.substring(string2.lastIndexOf(46) + 1);
        return string3.concat(" (").concat(string).concat(")");
    }

    private final Image getImage(String string) {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        return image;
    }

    protected synchronized boolean getLock() {
        if (this.locked) {
            return false;
        }
        this.setCursor(3);
        this.locked = true;
        return true;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(120, 100);
        }
        return this.preferredSize;
    }

    protected RemoteResourceWrapper getResources(RemoteResourceWrapper remoteResourceWrapper, String string) {
        RemoteResource remoteResource = null;
        if (remoteResourceWrapper != null) {
            try {
                remoteResource = remoteResourceWrapper.getResource().loadResource(string);
            }
            catch (RemoteAccessException remoteAccessException) {
                this.errorPopup("RemoteAccessException", remoteAccessException);
                remoteAccessException.printStackTrace();
            }
        }
        return new RemoteResourceWrapper(remoteResourceWrapper, remoteResource, this.serverBrowser);
    }

    public RemoteResourceWrapper getRootWrapper() {
        return this.rootResource;
    }

    public void insertNode(RemoteResourceWrapper remoteResourceWrapper, RemoteResourceWrapper remoteResourceWrapper2) {
        RemoteResource remoteResource = remoteResourceWrapper2.getResource();
        String string = null;
        try {
            string = this.getFrameName(remoteResource);
        }
        catch (RemoteAccessException remoteAccessException) {
            this.errorPopup("RemoteAccessException", remoteAccessException);
        }
        this.insertNode(remoteResourceWrapper, remoteResourceWrapper2, string);
    }

    public void insertNode(RemoteResourceWrapper remoteResourceWrapper, RemoteResourceWrapper remoteResourceWrapper2, String string) {
        TreeNode treeNode;
        boolean bl = false;
        if (remoteResourceWrapper == null) {
            System.out.println("Error null father");
        }
        if ((treeNode = this.getNode(remoteResourceWrapper)).getChildren() == -1) {
            return;
        }
        if (treeNode == null) {
            return;
        }
        try {
            bl = remoteResourceWrapper2.getResource().isContainer();
        }
        catch (RemoteAccessException remoteAccessException) {
            this.errorPopup("RemoteAccessException", remoteAccessException);
        }
        this.insert(treeNode, remoteResourceWrapper2, this, string, this.frameicon);
        this.repaint();
    }

    public boolean isDirectory(TreeBrowser treeBrowser, TreeNode treeNode) {
        return true;
    }

    public void notifyCollapse(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.getLock()) {
            if (this.tl != null) {
                this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
            }
            treeBrowser.collapse(treeNode);
            if (!treeNode.equals(this.lastn)) {
                treeBrowser.unselect(this.lastn);
                this.lastn = null;
            }
            this.unlock();
            treeBrowser.repaint();
            treeNode.setIcon(this.frameicon);
        }
    }

    public void notifyExecute(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.tl != null) {
            this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
        }
        if (!treeNode.equals(this.lastn)) {
            treeBrowser.unselect(this.lastn);
            this.lastn = null;
        }
        treeBrowser.repaint();
    }

    public void notifyExpand(TreeBrowser treeBrowser, TreeNode treeNode) {
        new Expander(treeBrowser, treeNode).start();
    }

    public void notifyExpander(TreeBrowser treeBrowser, TreeNode treeNode) {
        boolean bl = true;
        if (this.tl != null) {
            this.tl.focusChanged((RemoteResourceWrapper)treeNode.getItem());
        }
        RemoteResourceWrapper remoteResourceWrapper = null;
        RemoteResource remoteResource = null;
        remoteResourceWrapper = (RemoteResourceWrapper)treeNode.getItem();
        if (remoteResourceWrapper == null) {
            return;
        }
        remoteResource = remoteResourceWrapper.getResource();
        this.setCursor(3);
        try {
            try {
                RemoteResource[] remoteResourceArray = remoteResource.getFrames();
                if (remoteResourceArray != null) {
                    int n = 0;
                    while (n < remoteResourceArray.length) {
                        RemoteResourceWrapper remoteResourceWrapper2 = new RemoteResourceWrapper(remoteResourceWrapper, remoteResourceArray[n], this.serverBrowser);
                        treeBrowser.insert(treeNode, remoteResourceWrapper2, this, this.getFrameName(remoteResourceArray[n]), this.frameicon);
                        ++n;
                    }
                }
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    bl = false;
                }
                this.errorPopup("RemoteAccessException", remoteAccessException);
                remoteAccessException.printStackTrace();
            }
            Object var7_10 = null;
            if (!bl) {
                this.serverBrowser.popupDialog("admin");
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!bl) {
                this.serverBrowser.popupDialog("admin");
            }
            throw throwable;
        }
        this.setCursor(0);
        treeNode.setIcon(this.frameopened);
        treeBrowser.repaint();
    }

    public void notifySelect(TreeBrowser treeBrowser, TreeNode treeNode) {
        if (this.tl != null) {
            this.tl.editedChanged(this, (RemoteResourceWrapper)treeNode.getItem());
        }
        treeBrowser.unselect(this.lastn);
        treeBrowser.select(treeNode);
        treeBrowser.repaint();
        this.lastn = treeNode;
    }

    public void removeNode(RemoteResourceWrapper remoteResourceWrapper) {
        if (this.getLock()) {
            if (this.getNode(remoteResourceWrapper) != null) {
                this.removeBranch(this.getNode(remoteResourceWrapper));
                this.tl.nodeRemoved(remoteResourceWrapper);
            }
            this.unlock();
            this.repaint();
        }
    }

    public void renameNode(RemoteResourceWrapper remoteResourceWrapper, String string) {
        TreeNode treeNode = this.getNode(remoteResourceWrapper);
        if (treeNode != null) {
            try {
                if (remoteResourceWrapper != this.rootResource) {
                    string = this.getFrameName(remoteResourceWrapper.getResource(), string);
                }
            }
            catch (RemoteAccessException remoteAccessException) {}
            treeNode.setLabel(string);
            this.repaint();
        }
    }

    public void setCursor(int n) {
        this.getFrame(this.serverBrowser).setCursor(new Cursor(n));
        Toolkit.getDefaultToolkit().sync();
    }

    protected synchronized void unlock() {
        this.locked = false;
        this.setCursor(0);
    }

    class Expander
    extends Thread {
        TreeBrowser browser;
        TreeNode nd;

        Expander(TreeBrowser treeBrowser, TreeNode treeNode) {
            this.browser = treeBrowser;
            this.nd = treeNode;
        }

        public void run() {
            if (FrameBrowser.this.getLock()) {
                FrameBrowser.this.notifyExpander(this.browser, this.nd);
                FrameBrowser.this.unlock();
            }
        }
    }
}

