/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssValue;

public class CssTime
extends CssValue {
    private Float value;
    private int unit;
    private static String[] units = new String[]{"ms", "s"};
    private static int[] hash_units;
    private static Float defaultValue;

    public CssTime() {
        this.value = defaultValue;
    }

    public CssTime(Float value) {
        this.value = value;
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        String unit;
        int length;
        if ((s = s.toLowerCase()).charAt((length = s.length()) - 2) == 'm') {
            unit = s.substring(length - 2, length);
            this.value = new Float(s.substring(0, length - 2));
        } else {
            unit = s.substring(length - 1, length);
            this.value = Float.valueOf(s.substring(0, length - 1));
        }
        if (this.value.floatValue() < 0.0f) {
            throw new InvalidParamException("negative-value", this.value.toString(), ac);
        }
        this.unit = 1;
        if (this.value.floatValue() != 0.0f) {
            int hash = unit.hashCode();
            for (int i = 0; i < units.length; ++i) {
                if (hash != hash_units[i]) continue;
                this.unit = i;
                return;
            }
        } else {
            return;
        }
        throw new InvalidParamException("unit", unit, ac);
    }

    public Object get() {
        if (this.unit == 1) {
            return new Float(this.value.floatValue() * 1000.0f);
        }
        return this.value;
    }

    public String getUnit() {
        return units[this.unit];
    }

    public String toString() {
        if (this.value.floatValue() != 0.0f) {
            return Util.displayFloat(this.value) + this.getUnit();
        }
        return Util.displayFloat(this.value);
    }

    public boolean equals(Object value) {
        return value instanceof CssTime && this.value.equals(((CssTime)value).value) && this.unit == ((CssTime)value).unit;
    }

    static {
        defaultValue = new Float(0.0f);
        hash_units = new int[units.length];
        for (int i = 0; i < units.length; ++i) {
            CssTime.hash_units[i] = units[i].hashCode();
        }
    }
}

