/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.servlet;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.css.css.HTMLStyleSheetParser;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleReportFactory;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.error.ErrorReport;
import org.w3c.css.error.ErrorReportFactory;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Codecs;
import org.w3c.css.util.FakeFile;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.NVPair;
import org.w3c.css.util.Util;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public final class CssValidator
extends HttpServlet {
    static final String texthtml = "text/html";
    static final String applxhtml = "application/xhtml+xml";
    static final String textplain = "text/plain";
    static final String textunknwon = "text/unknown";
    static final String soap12 = "application/soap+xml";
    static final String server_name = "Jigsaw/2.2.2 W3C_CSS_Validator_JFouffa/2.0";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Util.servlet = true;
        if (config.getInitParameter("debug") != null) {
            Util.onDebug = config.getInitParameter("debug").equals("true");
            System.err.println("RUN IN DEBUG MODE: " + config.getInitParameter("debug").equals("true"));
        } else if (Util.onDebug) {
            System.err.println("RUN IN DEBUG MODE but activated outside the servlet");
        }
        if (config.getInitParameter("import") != null && config.getInitParameter("import").equals("false")) {
            Util.importSecurity = true;
        }
    }

    private PrintWriter getLocalPrintWriter(OutputStream os, String encoding) throws IOException {
        if (encoding != null) {
            return new PrintWriter(new OutputStreamWriter(os, encoding));
        }
        return new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean errorReport = true;
        int warningLevel = 2;
        StyleSheetParser parser = null;
        String lang = null;
        try {
            lang = req.getParameter("lang");
        }
        catch (Exception e) {
            lang = null;
        }
        lang = lang == null || lang.equals("") ? req.getHeader("Accept-Language") : lang + ',' + req.getHeader("Accept-Language");
        ApplContext ac = new ApplContext(lang);
        ac.setContentEncoding(req.getHeader("Accept-Charset"));
        String output = req.getParameter("output");
        String uri = null;
        try {
            uri = req.getParameter("uri");
        }
        catch (Exception ex) {
            this.handleError(res, ac, output, "No file", new IOException("Invalid escape sequence in URI"), false);
        }
        String text = null;
        try {
            text = req.getParameter("text");
        }
        catch (Exception ex) {
            this.handleError(res, ac, output, "Invalid text", new IOException("Invalid escape sequence in URI"), false);
        }
        String warning = req.getParameter("warning");
        String error = req.getParameter("error");
        String profile = req.getParameter("profile");
        String usermedium = req.getParameter("usermedium");
        String credential = req.getHeader("Authorization");
        if (credential != null && credential.length() > 1) {
            ac.setCredential(credential);
        }
        if (usermedium == null || "".equals(usermedium)) {
            usermedium = "all";
        }
        ServletInputStream in = req.getInputStream();
        ac.setMedium(usermedium);
        if (req.getParameter("debug") != null) {
            Util.onDebug = req.getParameter("debug").equals("true");
            if (Util.onDebug) {
                System.err.println("SWITCH DEBUG MODE REQUEST");
            }
        } else {
            Util.onDebug = false;
        }
        uri = Util.suppressWhiteSpace(uri);
        if (output == null) {
            output = texthtml;
        }
        if (profile != null && !"none".equals(profile)) {
            if ("css1".equals(profile) || "css2".equals(profile) || "css21".equals(profile) || "css3".equals(profile) || "svg".equals(profile) || "svgbasic".equals(profile) || "svgtiny".equals(profile)) {
                ac.setCssVersion(profile);
            } else {
                ac.setProfile(profile);
                ac.setCssVersion("css2");
            }
        } else {
            ac.setCssVersion("css2");
        }
        if (Util.onDebug) {
            System.err.println("[DEBUG]  profile is : " + ac.getCssVersion() + " medium is " + usermedium);
        }
        if (uri == null && text == null) {
            this.handleError(res, ac, output, "No file", new IOException(ac.getMsg().getServletString("invalid-request")), false);
            return;
        }
        in.close();
        if (warning != null) {
            if (warning.equals("no")) {
                warningLevel = -1;
            } else {
                try {
                    warningLevel = Integer.parseInt(warning);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        if (error != null && error.equals("no")) {
            errorReport = false;
        }
        Util.verbose("\nServlet request ");
        if (uri != null) {
            Util.verbose("Source file : " + uri);
        } else {
            Util.verbose("TEXTAREA Input");
        }
        if (uri != null) {
            try {
                uri = HTTPURL.getURL(uri).toString();
                HTMLStyleSheetParser URLparser = new HTMLStyleSheetParser(ac, uri);
                this.handleRequest(ac, res, uri, URLparser.getStyleSheet(), output, warningLevel, errorReport);
            }
            catch (ProtocolException pex) {
                if (Util.onDebug) {
                    pex.printStackTrace();
                }
                res.setHeader("WWW-Authenticate", pex.getMessage());
                res.sendError(401);
            }
            catch (Exception e) {
                this.handleError(res, ac, output, uri, e, true);
            }
        } else {
            Util.verbose("- TextArea Data -");
            Util.verbose(text);
            Util.verbose("- End of TextArea Data");
            parser = new StyleSheetParser();
            try {
                parser.parseStyleElement(ac, new ByteArrayInputStream(text.getBytes()), null, usermedium, new URL("file://localhost/TextArea"), 0);
                this.handleRequest(ac, res, "file://localhost/TextArea", parser.getStyleSheet(), output, warningLevel, errorReport);
            }
            catch (Exception e) {
                this.handleError(res, ac, output, "TextArea", e, false);
            }
        }
        Util.verbose("CssValidator: Request terminated.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String lang = null;
        try {
            lang = req.getParameter("lang");
        }
        catch (Exception e) {
            lang = null;
        }
        lang = lang == null || lang.equals("") ? req.getHeader("Accept-Language") : lang + ',' + req.getHeader("Accept-Language");
        ApplContext ac = new ApplContext(lang);
        boolean errorReport = true;
        int warningLevel = 2;
        StyleSheetParser parser = null;
        FakeFile file = null;
        String output = null;
        boolean XMLinput = false;
        String warning = null;
        String error = null;
        String profile = null;
        String usermedium = "all";
        ServletInputStream in = req.getInputStream();
        byte[] buf = new byte[2048];
        byte[] general = new byte[65536];
        int count = 0;
        if (req.getParameter("debug") != null) {
            Util.onDebug = req.getParameter("debug").equals("true");
            if (Util.onDebug) {
                System.err.println("SWITCH DEBUG MODE REQUEST");
            }
        } else {
            Util.onDebug = false;
        }
        Util.verbose("\nCssValidator: Servlet request ");
        Util.verbose("Content-length : " + req.getContentLength());
        if (req.getContentType().trim().startsWith("multipart/form-data")) {
            Util.verbose("Content-type : multipart/form-data");
        }
        try {
            int len;
            while ((len = in.readLine(buf, 0, buf.length)) != -1) {
                if (len >= 2 && buf[len - 1] == 10 && buf[len - 2] == 13) {
                    buf[--len - 1] = 10;
                }
                if (len != 0 && buf[len - 1] == 13) {
                    buf[len - 1] = 10;
                }
                if (general.length < count + len) {
                    byte[] old = general;
                    general = new byte[old.length * 2];
                    System.arraycopy(old, 0, general, 0, old.length);
                }
                System.arraycopy(buf, 0, general, count, len);
                count += len;
            }
        }
        finally {
            in.close();
        }
        try {
            buf = new byte[count];
            System.arraycopy(general, 0, buf, 0, count);
            NVPair[] tmp = Codecs.mpFormDataDecode(buf, req.getContentType());
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].getName().equals("file")) {
                    file = (FakeFile)tmp[i].getValue();
                    continue;
                }
                if (tmp[i].getName().equals("output")) {
                    output = (String)tmp[i].getValue();
                    continue;
                }
                if (tmp[i].getName().equals("warning")) {
                    warning = (String)tmp[i].getValue();
                    continue;
                }
                if (tmp[i].getName().equals("error")) {
                    warning = (String)tmp[i].getValue();
                    continue;
                }
                if (tmp[i].getName().equals("input")) {
                    XMLinput = ((String)tmp[i].getValue()).equals("XML");
                    continue;
                }
                if (tmp[i].getName().equals("profile")) {
                    profile = (String)tmp[i].getValue();
                    continue;
                }
                if (!tmp[i].getName().equals("usermedium") || (usermedium = (String)tmp[i].getValue()) != null && !"".equals(usermedium)) continue;
                usermedium = "all";
            }
        }
        catch (Exception e) {
            System.out.println("Oups! Error in Util/Codecs.java?!?");
            e.printStackTrace();
        }
        ac.setMedium(usermedium);
        if (output == null) {
            output = texthtml;
        }
        if (file == null || file.getSize() == 0) {
            this.handleError(res, ac, output, "No file", new IOException(ac.getMsg().getServletString("invalid-request")), false);
            return;
        }
        if (warning != null) {
            if (warning.equals("no")) {
                warningLevel = -1;
            } else {
                try {
                    warningLevel = Integer.parseInt(warning);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        if (error != null && error.equals("no")) {
            errorReport = false;
        }
        Util.verbose("File : " + file.getName());
        parser = new StyleSheetParser();
        try {
            parser.parseStyleElement(ac, file.getInputStream(), null, null, new URL("file://localhost/" + file.getName()), 0);
            this.handleRequest(ac, res, "file://localhost/" + file.getName(), parser.getStyleSheet(), output, warningLevel, errorReport);
        }
        catch (Exception e) {
            this.handleError(res, ac, output, file.getName(), e, false);
        }
        Util.verbose("CssValidator: Request terminated.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ApplContext ac, HttpServletResponse res, String title, StyleSheet styleSheet, String output, int warningLevel, boolean errorReport) throws Exception {
        this.buildHeader(ac, res, output);
        if (styleSheet == null) {
            throw new IOException(ac.getMsg().getServletString("process") + " " + title);
        }
        if ("text/xml".equals(ac.getInput()) && texthtml.equals(output)) {
            output = "xhtml";
        } else if (texthtml.equals(output)) {
            output = "html";
        } else if (soap12.equals(output)) {
            output = "soap12";
        } else if (textplain.equals(output)) {
            output = "text";
        }
        styleSheet.findConflicts(ac);
        StyleReport style = StyleReportFactory.getStyleReport(ac, title, styleSheet, output, warningLevel);
        if (!errorReport) {
            style.desactivateError();
        }
        PrintWriter out = this.getLocalPrintWriter((OutputStream)res.getOutputStream(), ac.getContentEncoding());
        try {
            style.print(out);
        }
        finally {
            out.close();
        }
    }

    private void buildHeader(ApplContext ac, HttpServletResponse res, String output) {
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache");
        if (output == null) {
            output = new String(texthtml);
        }
        MimeType outputMt = null;
        if (output.equals(texthtml) || output.equals("html")) {
            outputMt = MimeType.TEXT_HTML.getClone();
        } else if (output.equals(applxhtml) || output.equals("xhtml")) {
            outputMt = MimeType.APPLICATION_XHTML_XML.getClone();
        } else if (output.equals(soap12) || output.equals("soap12")) {
            try {
                outputMt = new MimeType(soap12);
            }
            catch (MimeTypeFormatException e) {
                outputMt = MimeType.TEXT_PLAIN.getClone();
            }
        } else {
            outputMt = MimeType.TEXT_PLAIN.getClone();
        }
        if (ac != null) {
            if (output.equals("soap12")) {
                ac.setContentEncoding(null);
            }
            if (ac.getContentEncoding() != null) {
                outputMt.setParameter("charset", ac.getContentEncoding());
            }
            res.setContentType(outputMt.toString());
            if (ac.getContentLanguage() != null) {
                res.setHeader("Content-Language", ac.getContentLanguage());
            } else {
                res.setHeader("Content-Language", "en");
            }
        } else {
            res.setHeader("Content-Language", "en");
            res.setHeader("charset", "UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(HttpServletResponse res, ApplContext ac, String output, String title, Exception e, boolean validURI) throws IOException {
        System.err.println("[ERROR VALIDATOR] " + title);
        System.err.println(e.toString());
        e.printStackTrace();
        this.buildHeader(ac, res, output);
        res.setStatus(500);
        validURI = e instanceof UnknownHostException || e instanceof FileNotFoundException && (e.getMessage().indexOf("Not Found") != -1 || e.getMessage().indexOf("Service Unavailable") != -1);
        PrintWriter out = this.getLocalPrintWriter((OutputStream)res.getOutputStream(), ac.getContentEncoding());
        ErrorReport error = ErrorReportFactory.getErrorReport(ac, title, output, e, validURI);
        try {
            error.print(out);
        }
        finally {
            out.close();
        }
    }
}

