/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.AttributeList;
import html.parser.ContentModel;
import html.parser.DTD;
import html.parser.DTDConstants;
import html.parser.DTDInputStream;
import html.parser.Element;
import html.parser.Entity;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public class DTDParser
implements DTDConstants {
    DTD dtd;
    DTDInputStream in;
    int ch;
    char[] str = new char[128];
    int strpos = 0;
    int nerrors = 0;

    void error(String err, String arg1, String arg2, String arg3) {
        int i;
        ++this.nerrors;
        String str = DTD.props.getProperty("dtderr." + err);
        if (str == null) {
            str = err;
        }
        while ((i = str.indexOf(37)) > 0) {
            str = str.substring(0, i) + arg1 + str.substring(i + 1);
            arg1 = arg2;
            arg2 = arg3;
        }
        System.out.println("line " + this.in.ln + ", dtd " + this.dtd + ": " + str);
    }

    void error(String err, String arg1, String arg2) {
        this.error(err, arg1, arg2, "?");
    }

    void error(String err, String arg1) {
        this.error(err, arg1, "?", "?");
    }

    void error(String err) {
        this.error(err, "?", "?", "?");
    }

    boolean expect(int c) {
        if (this.ch != c) {
            char[] str = new char[]{(char)c};
            this.error("expected", "'" + new String(str) + "'");
            return false;
        }
        this.ch = this.in.read();
        return true;
    }

    void addString(int c) {
        if (this.strpos == this.str.length) {
            char[] newstr = new char[this.str.length * 2];
            System.arraycopy(this.str, 0, newstr, 0, this.str.length);
            this.str = newstr;
        }
        this.str[this.strpos++] = (char)c;
    }

    String getString(int pos) {
        char[] newstr = new char[this.strpos - pos];
        System.arraycopy(this.str, pos, newstr, 0, this.strpos - pos);
        this.strpos = pos;
        return new String(newstr);
    }

    String peekString(int pos) {
        char[] newstr = new char[this.strpos - pos];
        System.arraycopy(this.str, pos, newstr, 0, this.strpos - pos);
        return new String(newstr);
    }

    void skipSpace() {
        block3: while (true) {
            switch (this.ch) {
                case 9: 
                case 10: 
                case 32: {
                    this.ch = this.in.read();
                    continue block3;
                }
            }
            break;
        }
    }

    void skipParameterSpace() {
        block8: while (true) {
            switch (this.ch) {
                case 9: 
                case 10: 
                case 32: {
                    this.ch = this.in.read();
                    continue block8;
                }
                case 45: {
                    this.ch = this.in.read();
                    if (this.ch != 45) {
                        this.in.push(this.ch);
                        this.ch = 45;
                        return;
                    }
                    ++this.in.replace;
                    while (true) {
                        this.ch = this.in.read();
                        switch (this.ch) {
                            case 45: {
                                this.ch = this.in.read();
                                if (this.ch != 45) break;
                                this.ch = this.in.read();
                                --this.in.replace;
                                this.skipParameterSpace();
                                return;
                            }
                            case -1: {
                                this.error("eof.arg", "comment");
                                --this.in.replace;
                                return;
                            }
                        }
                    }
                }
            }
            break;
        }
    }

    boolean parseExtendedIdentifier(boolean lower) {
        switch (this.ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (lower) {
                    this.ch = 97 + (this.ch - 65);
                }
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            default: {
                return false;
            }
        }
        block9: while (true) {
            this.addString(this.ch);
            this.ch = this.in.read();
            switch (this.ch) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (lower) {
                        this.ch = 97 + (this.ch - 65);
                    }
                }
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block9;
                }
            }
            break;
        }
        return true;
    }

    Vector parseExtendedIdentifierList(boolean lower) {
        Vector<String> elems = new Vector<String>();
        this.skipSpace();
        switch (this.ch) {
            case 40: {
                this.ch = this.in.read();
                this.skipParameterSpace();
                while (this.parseExtendedIdentifier(lower)) {
                    elems.addElement(this.getString(0));
                    this.skipParameterSpace();
                    if (this.ch != 124) continue;
                    this.ch = this.in.read();
                    this.skipParameterSpace();
                }
                this.expect(41);
                this.skipParameterSpace();
                break;
            }
            default: {
                if (!this.parseExtendedIdentifier(lower)) {
                    this.error("expected", "identifier");
                    break;
                }
                elems.addElement(this.getString(0));
                this.skipParameterSpace();
            }
        }
        return elems;
    }

    boolean parseIdentifier(boolean lower) {
        switch (this.ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (lower) {
                    this.ch = 97 + (this.ch - 65);
                }
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                break;
            }
            default: {
                return false;
            }
        }
        block8: while (true) {
            this.addString(this.ch);
            this.ch = this.in.read();
            switch (this.ch) {
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (lower) {
                        this.ch = 97 + (this.ch - 65);
                    }
                }
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    Vector parseIdentifierList(boolean lower) {
        Vector<String> elems = new Vector<String>();
        this.skipSpace();
        switch (this.ch) {
            case 40: {
                this.ch = this.in.read();
                this.skipParameterSpace();
                while (this.parseIdentifier(lower)) {
                    elems.addElement(this.getString(0));
                    this.skipParameterSpace();
                    if (this.ch != 124) continue;
                    this.ch = this.in.read();
                    this.skipParameterSpace();
                }
                this.expect(41);
                this.skipParameterSpace();
                break;
            }
            default: {
                if (!this.parseIdentifier(lower)) {
                    this.error("expected", "identifier");
                    break;
                }
                elems.addElement(this.getString(0));
                this.skipParameterSpace();
            }
        }
        return elems;
    }

    private void parseEntityReference() {
        int pos = this.strpos;
        this.ch = this.in.read();
        if (this.ch == 35) {
            int n = 0;
            this.ch = this.in.read();
            if (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90) {
                this.addString(35);
            } else {
                while (this.ch >= 48 && this.ch <= 57) {
                    n = n * 10 + this.ch - 48;
                    this.ch = this.in.read();
                }
                if (this.ch == 59 || this.ch == 10) {
                    this.ch = this.in.read();
                }
                this.addString(n);
                return;
            }
        }
        block4: while (true) {
            switch (this.ch) {
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.addString(this.ch);
                    this.ch = this.in.read();
                    continue block4;
                }
            }
            break;
        }
        if (this.strpos == pos) {
            this.addString(38);
            return;
        }
        String nm = this.getString(pos);
        Entity ent = this.dtd.getEntity(nm);
        if (ent == null) {
            this.error("undef.entref" + nm);
            return;
        }
        if (this.ch == 59 || this.ch == 10) {
            this.ch = this.in.read();
        }
        byte[] data = ent.getData();
        for (int i = 0; i < data.length; ++i) {
            this.addString(data[i]);
        }
    }

    private void parseEntityDeclaration() {
        int type = 65536;
        this.skipSpace();
        if (this.ch == 37) {
            this.ch = this.in.read();
            type = 262144;
            this.skipSpace();
        }
        if (this.ch == 35) {
            this.addString(35);
            this.ch = this.in.read();
        }
        if (!this.parseIdentifier(false)) {
            this.error("expected", "identifier");
            return;
        }
        String nm = this.getString(0);
        this.skipParameterSpace();
        if (this.parseIdentifier(false)) {
            String tnm = this.getString(0);
            int t = Entity.name2type(tnm);
            if (t == 0) {
                this.error("invalid.arg", "entity type", tnm);
            } else {
                type |= t;
            }
            this.skipParameterSpace();
        }
        if (this.ch != 34 && this.ch != 39) {
            this.error("expected", "entity value");
            this.skipParameterSpace();
            if (this.ch == 62) {
                this.ch = this.in.read();
            }
            return;
        }
        int term = this.ch;
        this.ch = this.in.read();
        while (this.ch != -1 && this.ch != term) {
            if (this.ch == 38) {
                this.parseEntityReference();
                continue;
            }
            this.addString(this.ch & 0xFF);
            this.ch = this.in.read();
        }
        if (this.ch == term) {
            this.ch = this.in.read();
        }
        if (this.in.replace == 0) {
            String str = this.getString(0);
            byte[] data = str.getBytes();
            this.dtd.defineEntity(nm, type, data);
        } else {
            this.strpos = 0;
        }
        this.skipParameterSpace();
        this.expect(62);
    }

    ContentModel parseContentModel() {
        ContentModel m = null;
        switch (this.ch) {
            case 40: {
                this.ch = this.in.read();
                this.skipParameterSpace();
                ContentModel e = this.parseContentModel();
                if (this.ch != 41) {
                    m = new ContentModel(this.ch, e);
                    do {
                        this.ch = this.in.read();
                        this.skipParameterSpace();
                        e.next = this.parseContentModel();
                        if (e.next.type == m.type) {
                            e.next = (ContentModel)e.next.content;
                        }
                        while (e.next != null) {
                            e = e.next;
                        }
                    } while (this.ch == m.type);
                } else {
                    m = new ContentModel(44, e);
                }
                this.expect(41);
                break;
            }
            case 35: {
                this.ch = this.in.read();
                if (this.parseIdentifier(true)) {
                    m = new ContentModel(42, new ContentModel(this.dtd.getElement("#" + this.getString(0))));
                    break;
                }
                this.error("invalid", "content model");
                break;
            }
            default: {
                if (this.parseIdentifier(true)) {
                    m = new ContentModel(this.dtd.getElement(this.getString(0)));
                    break;
                }
                this.error("invalid", "content model");
            }
        }
        switch (this.ch) {
            case 42: 
            case 43: 
            case 63: {
                m = new ContentModel(this.ch, m);
                this.ch = this.in.read();
            }
        }
        this.skipParameterSpace();
        return m;
    }

    void parseElementDeclaration() {
        Vector elems = this.parseIdentifierList(true);
        BitSet inclusions = null;
        BitSet exclusions = null;
        boolean omitStart = false;
        boolean omitEnd = false;
        if (this.ch == 45 || this.ch == 79) {
            omitStart = this.ch == 79;
            this.ch = this.in.read();
            this.skipParameterSpace();
            if (this.ch == 45 || this.ch == 79) {
                omitEnd = this.ch == 79;
                this.ch = this.in.read();
                this.skipParameterSpace();
            } else {
                this.expect(45);
            }
        }
        int type = 18;
        ContentModel content = null;
        if (this.parseIdentifier(false)) {
            String nm = this.getString(0);
            type = Element.name2type(nm);
            if (type == 0) {
                this.error("invalid.arg", "content type", nm);
                type = 17;
            }
            this.skipParameterSpace();
        } else {
            content = this.parseContentModel();
        }
        if (type == 18 || type == 19) {
            Enumeration e;
            Vector v;
            if (this.ch == 45) {
                this.ch = this.in.read();
                v = this.parseIdentifierList(true);
                exclusions = new BitSet();
                e = v.elements();
                while (e.hasMoreElements()) {
                    exclusions.set(this.dtd.getElement((String)e.nextElement()).getIndex());
                }
            }
            if (this.ch == 43) {
                this.ch = this.in.read();
                v = this.parseIdentifierList(true);
                inclusions = new BitSet();
                e = v.elements();
                while (e.hasMoreElements()) {
                    inclusions.set(this.dtd.getElement((String)e.nextElement()).getIndex());
                }
            }
        }
        this.expect(62);
        if (this.in.replace == 0) {
            Enumeration e = elems.elements();
            while (e.hasMoreElements()) {
                this.dtd.defineElement((String)e.nextElement(), type, omitStart, omitEnd, content, exclusions, inclusions);
            }
        }
    }

    void parseAttributeDeclaredValue(AttributeList atts) {
        if (this.ch == 40) {
            atts.values = this.parseExtendedIdentifierList(true);
            atts.type = 9;
            return;
        }
        if (!this.parseExtendedIdentifier(false)) {
            this.error("invalid", "attribute value");
            return;
        }
        atts.type = AttributeList.name2type(this.getString(0));
        this.skipParameterSpace();
        if (atts.type == 11) {
            atts.values = this.parseIdentifierList(true);
        }
    }

    String parseAttributeValueSpecification() {
        int delim = -1;
        switch (this.ch) {
            case 34: 
            case 39: {
                delim = this.ch;
                this.ch = this.in.read();
            }
        }
        block9: while (true) {
            switch (this.ch) {
                case -1: {
                    this.error("eof.arg", "attribute value");
                    return this.getString(0);
                }
                case 38: {
                    this.parseEntityReference();
                    continue block9;
                }
                case 9: 
                case 10: 
                case 32: {
                    if (delim == -1) {
                        return this.getString(0);
                    }
                    this.addString(32);
                    this.ch = this.in.read();
                    continue block9;
                }
                case 34: 
                case 39: {
                    if (delim != this.ch) break;
                    this.ch = this.in.read();
                    return this.getString(0);
                }
            }
            this.addString(this.ch & 0xFF);
            this.ch = this.in.read();
        }
    }

    void parseAttributeDefaultValue(AttributeList atts) {
        if (this.ch == 35) {
            this.ch = this.in.read();
            if (!this.parseIdentifier(true)) {
                this.error("invalid", "attribute value");
                return;
            }
            this.skipParameterSpace();
            atts.modifier = AttributeList.name2type(this.getString(0));
            if (atts.modifier != 1) {
                return;
            }
        }
        atts.value = this.parseAttributeValueSpecification();
        this.skipParameterSpace();
    }

    void parseAttlistDeclaration() {
        Vector elems = this.parseIdentifierList(true);
        AttributeList attlist = null;
        AttributeList atts = null;
        while (this.parseIdentifier(true)) {
            if (atts == null) {
                attlist = atts = new AttributeList(this.getString(0));
            } else {
                atts = atts.next = new AttributeList(this.getString(0));
            }
            this.skipParameterSpace();
            this.parseAttributeDeclaredValue(atts);
            this.parseAttributeDefaultValue(atts);
            if (atts.modifier != 5 || atts.values == null || atts.values.size() != 1) continue;
            atts.value = (String)atts.values.elementAt(0);
        }
        this.expect(62);
        if (this.in.replace == 0) {
            Enumeration e = elems.elements();
            while (e.hasMoreElements()) {
                this.dtd.defineAttributes((String)e.nextElement(), attlist);
            }
        }
    }

    void parseIgnoredSection() {
        int depth = 1;
        ++this.in.replace;
        block5: while (true) {
            switch (this.ch) {
                case 60: {
                    this.ch = this.in.read();
                    if (this.ch != 33 || (this.ch = this.in.read()) != 91) continue block5;
                    this.ch = this.in.read();
                    ++depth;
                    continue block5;
                }
                case 93: {
                    this.ch = this.in.read();
                    if (this.ch != 93 || (this.ch = this.in.read()) != 62) continue block5;
                    this.ch = this.in.read();
                    if (--depth != 0) continue block5;
                    --this.in.replace;
                    return;
                }
                case -1: {
                    this.error("eof");
                    --this.in.replace;
                    return;
                }
            }
            this.ch = this.in.read();
        }
    }

    void parseMarkedSectionDeclaration() {
        this.ch = this.in.read();
        this.skipSpace();
        if (!this.parseIdentifier(true)) {
            this.error("expected", "section status keyword");
            return;
        }
        String str = this.getString(0);
        this.skipSpace();
        this.expect(91);
        if ("ignore".equals(str)) {
            this.parseIgnoredSection();
        } else {
            if (!"include".equals(str)) {
                this.error("invalid.arg", "section status keyword", str);
            }
            this.parseSection();
            this.expect(93);
            this.expect(93);
            this.expect(62);
        }
    }

    void parseExternalIdentifier() {
        if (this.parseIdentifier(false)) {
            String id = this.getString(0);
            this.skipParameterSpace();
            if (id.equals("PUBLIC")) {
                if (this.ch == 39 || this.ch == 34) {
                    this.parseAttributeValueSpecification();
                } else {
                    this.error("expected", "public identifier");
                }
                this.skipParameterSpace();
            } else if (!id.equals("SYSTEM")) {
                this.error("invalid", "external identifier");
            }
            if (this.ch == 39 || this.ch == 34) {
                this.parseAttributeValueSpecification();
            }
            this.skipParameterSpace();
        }
    }

    void parseDocumentTypeDeclaration() {
        this.skipParameterSpace();
        if (!this.parseIdentifier(true)) {
            this.error("expected", "identifier");
        } else {
            this.skipParameterSpace();
        }
        this.strpos = 0;
        this.parseExternalIdentifier();
        if (this.ch == 91) {
            this.ch = this.in.read();
            this.parseSection();
            this.expect(93);
            this.skipParameterSpace();
        }
        this.expect(62);
    }

    void parseSection() {
        block13: while (true) {
            switch (this.ch) {
                case 93: {
                    return;
                }
                case 60: {
                    Object str;
                    this.ch = this.in.read();
                    block6 : switch (this.ch) {
                        case 33: {
                            this.ch = this.in.read();
                            switch (this.ch) {
                                case 91: {
                                    this.parseMarkedSectionDeclaration();
                                    break block6;
                                }
                                case 45: {
                                    this.skipParameterSpace();
                                    this.expect(62);
                                    break block6;
                                }
                            }
                            if (this.parseIdentifier(true)) {
                                str = this.getString(0);
                                if (((String)str).equals("element")) {
                                    this.parseElementDeclaration();
                                    break;
                                }
                                if (((String)str).equals("entity")) {
                                    this.parseEntityDeclaration();
                                    break;
                                }
                                if (((String)str).equals("attlist")) {
                                    this.parseAttlistDeclaration();
                                    break;
                                }
                                if (((String)str).equals("doctype")) {
                                    this.parseDocumentTypeDeclaration();
                                    break;
                                }
                                if (((String)str).equals("usemap")) {
                                    this.error("ignoring", "usemap");
                                    while (this.ch != -1 && this.ch != 62) {
                                        this.ch = this.in.read();
                                    }
                                    this.expect(62);
                                    break;
                                }
                                if (((String)str).equals("shortref")) {
                                    this.error("ignoring", "shortref");
                                    while (this.ch != -1 && this.ch != 62) {
                                        this.ch = this.in.read();
                                    }
                                    this.expect(62);
                                    break;
                                }
                                if (((String)str).equals("notation")) {
                                    this.error("ignoring", "notation");
                                    while (this.ch != -1 && this.ch != 62) {
                                        this.ch = this.in.read();
                                    }
                                    this.expect(62);
                                    break;
                                }
                                this.error("markup");
                                break;
                            }
                            this.error("markup");
                            while (this.ch != -1 && this.ch != 62) {
                                this.ch = this.in.read();
                            }
                            this.expect(62);
                        }
                    }
                    continue block13;
                }
                case -1: {
                    return;
                }
                default: {
                    Object str = new char[]{(char)this.ch};
                    this.error("invalid.arg", "character", "'" + new String((char[])str) + "' / " + this.ch);
                }
                case 9: 
                case 10: 
                case 32: 
            }
            this.ch = this.in.read();
        }
    }

    DTD parse(InputStream in, DTD dtd) {
        this.dtd = dtd;
        this.in = new DTDInputStream(in, dtd);
        long tm = System.currentTimeMillis();
        this.ch = this.in.read();
        this.parseSection();
        if (this.ch != -1) {
            this.error("premature");
        }
        tm = System.currentTimeMillis() - tm;
        if (Boolean.getBoolean("html.parser.DTDParser.verbose")) {
            System.out.println("[Parsed DTD " + dtd + " in " + tm + "ms]");
        }
        return this.nerrors > 0 ? null : dtd;
    }
}

