/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.DTD;
import html.parser.DTDConstants;
import html.parser.Entity;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

final class DTDInputStream
extends FilterInputStream
implements DTDConstants {
    DTD dtd;
    Stack stack = new Stack();
    char[] str = new char[64];
    int replace = 0;
    int ln = 1;
    int ch;

    DTDInputStream(InputStream in, DTD dtd) {
        super(in);
        this.dtd = dtd;
        try {
            this.ch = in.read();
        }
        catch (IOException e) {
            System.out.println("DTDInputStream::DTDInputStream : IOException");
        }
    }

    void error(String msg) {
        System.out.println("line " + this.ln + ": dtd input error: " + msg);
    }

    void push(int ch) {
        byte[] data = new byte[]{(byte)(ch & 0xFF)};
        this.push(new ByteArrayInputStream(data));
    }

    void push(byte[] data) {
        if (data.length > 0) {
            this.push(new ByteArrayInputStream(data));
        }
    }

    void push(InputStream in) {
        this.stack.push(new Integer(this.ln));
        this.stack.push(new Integer(this.ch));
        this.stack.push(this.in);
        this.in = in;
        try {
            this.ch = in.read();
        }
        catch (IOException e) {
            System.out.println("DTDInputStream::push : IOException");
        }
    }

    public int read() {
        switch (this.ch) {
            case 37: {
                try {
                    this.ch = this.in.read();
                }
                catch (IOException e) {
                    System.out.println("DTDInputStream::read<1> : IOException");
                }
                if (this.replace > 0) {
                    return 37;
                }
                int pos = 0;
                while (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch >= 48 && this.ch <= 57 || this.ch == 46 || this.ch == 45) {
                    this.str[pos++] = (char)this.ch;
                    try {
                        this.ch = this.in.read();
                    }
                    catch (IOException e) {
                        System.out.println("DTDInputStream::read<3> : IOException");
                    }
                }
                if (pos == 0) {
                    return 37;
                }
                String nm = new String(this.str, 0, pos);
                Entity ent = this.dtd.getEntity(nm);
                if (ent == null) {
                    this.error("undefined entity reference: " + nm);
                    return this.read();
                }
                switch (this.ch) {
                    case 13: {
                        ++this.ln;
                    }
                    case 59: {
                        try {
                            this.ch = this.in.read();
                        }
                        catch (IOException e) {
                            System.out.println("DTDInputStream::read<2+> : IOException");
                        }
                        break;
                    }
                    case 10: {
                        ++this.ln;
                        try {
                            this.ch = this.in.read();
                            if (this.ch != 13) break;
                            this.ch = this.in.read();
                            break;
                        }
                        catch (IOException e) {
                            System.out.println("DTDInputStream::read<2> : IOException");
                        }
                    }
                }
                try {
                    this.push(ent.getInputStream());
                }
                catch (Exception e) {
                    this.error("entity data not found: " + ent + ", " + ent.getString());
                }
                return this.read();
            }
            case 10: {
                ++this.ln;
                try {
                    this.ch = this.in.read();
                    if (this.ch == 13) {
                        this.ch = this.in.read();
                    }
                }
                catch (IOException e) {
                    System.out.println("DTDInputStream::read<4> : IOException");
                }
                return 10;
            }
            case 13: {
                ++this.ln;
                try {
                    this.ch = this.in.read();
                }
                catch (IOException e) {
                    System.out.println("DTDInputStream::read<5> : IOException");
                }
                return 10;
            }
            case -1: {
                if (this.stack.size() > 0) {
                    this.in = (InputStream)this.stack.pop();
                    this.ch = (Integer)this.stack.pop();
                    this.ln = (Integer)this.stack.pop();
                    return this.read();
                }
                return -1;
            }
        }
        int c = this.ch;
        try {
            this.ch = this.in.read();
        }
        catch (IOException e) {
            System.out.println("DTDInputStream::read<6> : IOException");
        }
        return c;
    }
}

