/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.StringArrayAttribute;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class MimeTypeArrayAttribute
extends StringArrayAttribute {
    public MimeTypeArrayAttribute(String string, MimeType[] mimeTypeArray, Integer n) {
        super(string, MimeTypeArrayAttribute.toStringArray(mimeTypeArray), n);
        this.type = "[Lorg.w3c.www.mime.MimeType;";
    }

    public boolean checkValue(Object object) {
        return object instanceof MimeType[] || object instanceof String[];
    }

    public int getPickleLength(Object object) {
        return super.getPickleLength(MimeTypeArrayAttribute.toStringArray(object));
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        super.pickle(dataOutputStream, MimeTypeArrayAttribute.toStringArray(object));
    }

    public static String[] toStringArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof MimeType[]) {
            MimeType[] mimeTypeArray = (MimeType[])object;
            String[] stringArray = new String[mimeTypeArray.length];
            int n = 0;
            while (n < mimeTypeArray.length) {
                stringArray[n] = mimeTypeArray[n].toString();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        MimeType[] mimeTypeArray = new MimeType[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                mimeTypeArray[n2] = new MimeType(dataInputStream.readUTF());
            }
            catch (MimeTypeFormatException mimeTypeFormatException) {
                mimeTypeArray[n2] = null;
            }
            ++n2;
        }
        return mimeTypeArray;
    }
}

