/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Writer;
import org.w3c.tools.resources.serialization.xml.JigXML;

public class XMLWriter
implements JigXML {
    protected Writer writer = null;
    protected int level = 0;
    protected static String header = "<?xml version='1.0' encoding='UTF-8'?>\n<jigxml version=\"1.0\" xmlns=\"http://jigsaw.w3.org/JigXML/JigXML1.0\">\n";

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    protected void closeDocument() throws IOException {
        this.writer.write("</");
        this.writer.write("jigxml");
        this.writer.write(">\n");
        this.writer.close();
    }

    protected void closeResource() throws IOException {
        this.writer.write("</");
        this.writer.write("resource");
        this.writer.write(">\n");
    }

    public static String encode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16);
        String string2 = null;
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    protected void indent() throws IOException {
        int n = 0;
        while (n < this.level) {
            this.writer.write(" ");
            ++n;
        }
    }

    protected void startDocument() throws IOException {
        this.writer.write(header);
    }
}

