/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.servlet.AutoReloadServletLoader;
import org.w3c.jigsaw.servlet.JigsawHttpServletRequest;
import org.w3c.jigsaw.servlet.JigsawHttpServletResponse;
import org.w3c.jigsaw.servlet.JigsawHttpSessionContext;
import org.w3c.jigsaw.servlet.JigsawServletContext;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.ObjectAttribute;
import org.w3c.tools.resources.PropertiesAttribute;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.timers.EventHandler;
import org.w3c.util.ArrayDictionary;
import org.w3c.util.EmptyEnumeration;
import org.w3c.util.ThreadCache;
import org.w3c.www.http.HttpMessage;

public class ServletWrapper
extends FramedResource
implements ServletConfig {
    static ThreadCache threadCache = null;
    public static final String RUNNER = "org.w3c.jigsaw.servlet.runner";
    public static final String ENDED = "org.w3c.jigsaw.servlet.ended";
    protected TimeoutManager timeoutManager = null;
    protected static final boolean debug = false;
    protected static int ATTR_SERVLET_CLASS;
    protected static int ATTR_SERVLET_TIMEOUT;
    protected static int ATTR_SERVLET_INSTANCEMAX;
    protected static int ATTR_PARAMETERS;
    protected static int ATTR_SERVLET_CONTEXT;
    protected static int ATTR_SESSION_CONTEXT;
    protected ServletPool servletPool = new ServletPool();
    protected boolean inited = false;

    static {
        threadCache = new ThreadCache("servlet-runner");
        threadCache.setCachesize(5);
        threadCache.setGrowAsNeeded(true);
        threadCache.setIdleTimeout(86400000);
        threadCache.initialize();
        ATTR_SERVLET_CLASS = -1;
        ATTR_SERVLET_TIMEOUT = -1;
        ATTR_SERVLET_INSTANCEMAX = -1;
        ATTR_PARAMETERS = 1;
        ATTR_SERVLET_CONTEXT = -1;
        ATTR_SESSION_CONTEXT = -1;
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.servlet.ServletWrapper");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        attribute = new StringAttribute("servlet-class", null, 6);
        ATTR_SERVLET_CLASS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new PropertiesAttribute("servlet-parameters", null, 2);
        ATTR_PARAMETERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("servlet-context", "org.w3c.jigsaw.servlet.JigsawServletContext", null, 8);
        ATTR_SERVLET_CONTEXT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new ObjectAttribute("session-context", "org.w3c.jigsaw.servlet.JigsawHttpSessionContext", null, 8);
        ATTR_SESSION_CONTEXT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new LongAttribute("servlet-timeout", null, 2);
        ATTR_SERVLET_TIMEOUT = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new IntegerAttribute("servlet-instancemax", null, 2);
        ATTR_SERVLET_INSTANCEMAX = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    public boolean acceptUnload() {
        return this.inited ^ true;
    }

    protected void checkServlet() throws ClassNotFoundException, ServletException {
        ServletPool servletPool = this.servletPool;
        synchronized (servletPool) {
            boolean bl = this.getLocalServletLoader().classChanged(this.getServletClass());
            if (!this.inited || bl || this.servletPool.getLoadedClass() != this.getLocalServletLoader().loadClass(this.getServletClass())) {
                this.inited = this.launchServlet();
            }
        }
    }

    protected AutoReloadServletLoader createNewLocalServletLoader(boolean bl) {
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        return jigsawServletContext.createNewLocalServletLoader(bl);
    }

    protected void destroyServlet() {
        ServletPool servletPool = this.servletPool;
        synchronized (servletPool) {
            Servlet servlet = this.servletPool.remove();
            while (servlet != null) {
                servlet.destroy();
                servlet = this.servletPool.remove();
            }
            this.inited = this.servletPool.getLoadedClass() != null;
        }
    }

    public synchronized String getInitParameter(String string) {
        ArrayDictionary arrayDictionary = this.getServletParameters();
        String string2 = arrayDictionary != null ? (String)arrayDictionary.get(string) : null;
        return string2;
    }

    public synchronized Enumeration getInitParameterNames() {
        ArrayDictionary arrayDictionary = this.getServletParameters();
        return arrayDictionary != null ? arrayDictionary.keys() : new EmptyEnumeration();
    }

    protected int getInstanceMax() {
        int n = this.getInt(ATTR_SERVLET_INSTANCEMAX, 1);
        if (n < 1) {
            JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
            n = jigsawServletContext.getServletInstanceMax();
        }
        if (n < 1) {
            return 1;
        }
        return n;
    }

    protected AutoReloadServletLoader getLocalServletLoader() {
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        return jigsawServletContext.getLocalServletLoader();
    }

    public Servlet getServlet() {
        try {
            this.checkServlet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.servletPool.getRepresentative();
    }

    public String getServletClass() {
        String string;
        String string2 = this.getString(ATTR_SERVLET_CLASS, null);
        if (string2 == null && (string = this.getIdentifier()).endsWith(".class")) {
            string2 = string;
        }
        return string2;
    }

    public ServletContext getServletContext() {
        ServletContext servletContext = (ServletContext)this.getValue(ATTR_SERVLET_CONTEXT, null);
        return servletContext;
    }

    public File getServletDirectory() {
        ResourceReference resourceReference = this.getParent();
        if (resourceReference != null) {
            try {
                try {
                    Resource resource = resourceReference.lock();
                    if (resource.definesAttribute("directory")) {
                        File file = (File)resource.getValue("directory", null);
                        Object var4_5 = null;
                        resourceReference.unlock();
                        return file;
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                    invalidResourceException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                resourceReference.unlock();
                throw throwable;
            }
            Object var4_6 = null;
            resourceReference.unlock();
        }
        return null;
    }

    public String getServletName() {
        return this.getIdentifier();
    }

    public ArrayDictionary getServletParameters() {
        return (ArrayDictionary)this.getValue(ATTR_PARAMETERS, null);
    }

    protected long getServletTimeout() {
        long l = this.getLong(ATTR_SERVLET_TIMEOUT, 0L);
        if (l == 0L) {
            JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
            l = jigsawServletContext.getServletTimeout();
        }
        return l;
    }

    public JigsawHttpSessionContext getSessionContext() {
        return (JigsawHttpSessionContext)this.getValue(ATTR_SESSION_CONTEXT, null);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        if (this.getServletContext() != null) {
            this.timeoutManager = new TimeoutManager((httpd)this.getServer());
            this.timeoutManager.start();
        }
        try {
            this.registerFrameIfNone("org.w3c.jigsaw.servlet.ServletWrapperFrame", "servlet-wrapper-frame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void invalidateAllSession() {
        JigsawHttpSessionContext jigsawHttpSessionContext = this.getSessionContext();
        Enumeration enumeration = jigsawHttpSessionContext.getIds();
        while (enumeration.hasMoreElements()) {
            jigsawHttpSessionContext.getSession((String)enumeration.nextElement()).invalidate();
        }
    }

    protected boolean isInited() {
        return this.inited;
    }

    public boolean isServletLoaded() {
        try {
            this.checkServlet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.inited;
    }

    protected boolean isWrappingAServlet() {
        String string = this.getServletClass();
        if (string == null) {
            return false;
        }
        Class clazz = null;
        try {
            clazz = this.getLocalServletLoader().loadClass(string, true);
            Object t = clazz.newInstance();
            return t instanceof Servlet;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean launchServlet() throws ClassNotFoundException, ServletException {
        this.destroyServlet();
        if (this.inited) {
            String string = "relaunching servlet failed due to incomplete \"" + this.getServletClass() + "\" cleanup.";
            this.getServer().errlog(this, string);
            return false;
        }
        String string = this.getServletClass();
        if (string == null) {
            this.getServer().errlog(this, "no servlet class attribute defined.");
            return false;
        }
        Class clazz = null;
        try {
            if (this.getLocalServletLoader().classChanged(string)) {
                this.createNewLocalServletLoader(true);
                this.invalidateAllSession();
            }
            clazz = this.getLocalServletLoader().loadClass(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "unable to find servlet class \"" + this.getServletClass() + "\"";
            this.getServer().errlog(string2);
            throw classNotFoundException;
        }
        return clazz != null ? this.launchServlet(clazz) : false;
    }

    protected boolean launchServlet(Class clazz) throws ServletException {
        Servlet servlet = null;
        try {
            servlet = (Servlet)clazz.newInstance();
            servlet.init((ServletConfig)this);
            this.timeoutManager.restart();
            if (servlet != null) {
                this.servletPool.add(servlet);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Illegal access during servlet instantiation, " + illegalAccessException.getClass().getName() + ": " + illegalAccessException.getMessage();
            this.getServer().errlog(this, string);
            throw new ServletException(string, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            String string = "unable to instantiate servlet, " + instantiationException.getClass().getName() + ": " + instantiationException.getMessage();
            this.getServer().errlog(this, string);
            throw new ServletException(string, (Throwable)instantiationException);
        }
        catch (ServletException servletException) {
            String string = "Error while initializing servlet";
            this.getServer().errlog(this, string);
            this.getServer().errlog(this, string);
            throw servletException;
        }
        catch (Exception exception) {
            String string = "Error while loading servlet";
            this.getServer().errlog(this, string);
            this.getServer().errlog(this, string);
            throw new ServletException(string, (Throwable)exception);
        }
    }

    public void notifyUnload() {
        if (this.timeoutManager != null) {
            this.timeoutManager.stop();
        }
        this.destroyServlet();
    }

    protected void service(Request request, Reply reply) throws ServletException, IOException {
        JigsawHttpServletResponse jigsawHttpServletResponse = null;
        JigsawHttpServletRequest jigsawHttpServletRequest = null;
        jigsawHttpServletResponse = new JigsawHttpServletResponse(request, reply);
        Servlet servlet = this.servletPool.takeServlet();
        JigsawServletContext jigsawServletContext = (JigsawServletContext)this.getServletContext();
        jigsawHttpServletRequest = new JigsawHttpServletRequest(servlet, jigsawServletContext, request, jigsawHttpServletResponse, this.getSessionContext());
        jigsawHttpServletResponse.setServletRequest(jigsawHttpServletRequest);
        ServletRunner servletRunner = new ServletRunner(servlet, jigsawHttpServletRequest, jigsawHttpServletResponse);
        reply.setState(RUNNER, servletRunner);
        threadCache.getThread(servletRunner, true);
        this.timeoutManager.restart();
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_SERVLET_CLASS && object != null || n == ATTR_PARAMETERS) {
            try {
                ServletPool servletPool = this.servletPool;
                synchronized (servletPool) {
                    this.inited = this.launchServlet();
                }
            }
            catch (Exception exception) {
                String string = "unable to set servlet class \"" + this.getServletClass() + "\" : " + exception.getMessage();
                this.getServer().errlog(string);
            }
        }
        if (n == ATTR_SERVLET_TIMEOUT) {
            this.timeoutManager.restart();
        }
    }

    protected void setValueOfSuperClass(int n, Object object) {
        super.setValue(n, object);
    }

    protected class TimeoutManager
    implements EventHandler {
        private Object timer = null;
        private httpd server = null;

        TimeoutManager(httpd httpd2) {
            this.server = httpd2;
        }

        public void handleTimerEvent(Object object, long l) {
            TimeoutManager timeoutManager = this;
            synchronized (timeoutManager) {
                this.timer = null;
            }
            ServletWrapper.this.destroyServlet();
        }

        protected void restart() {
            this.start();
        }

        private synchronized void setTimer(long l) {
            if (this.timer != null) {
                this.server.timer.recallTimer(this.timer);
                this.timer = null;
            }
            this.timer = this.server.timer.registerTimer(l, this, null);
        }

        protected void start() {
            long l = ServletWrapper.this.getServletTimeout();
            if (l != -1L) {
                this.setTimer(l);
            }
        }

        protected synchronized void stop() {
            if (this.timer != null) {
                this.server.timer.recallTimer(this.timer);
                this.timer = null;
            }
        }
    }

    private class ServletPool {
        private int maximum = 1;
        private int capacity = 0;
        private int usage = 0;
        private Servlet[] pool = null;
        private boolean singleThreaded = false;
        private Class loadedClass = null;

        ServletPool() {
        }

        protected void add(Servlet servlet) {
            if (this.pool == null || this.loadedClass == null) {
                this.singleThreaded = servlet instanceof SingleThreadModel;
                this.maximum = this.singleThreaded ? ServletWrapper.this.getInstanceMax() : 1;
                this.loadedClass = servlet.getClass();
                this.pool = new Servlet[this.maximum];
            }
            if (this.capacity < this.maximum) {
                this.pool[this.capacity++] = servlet;
            }
        }

        protected Class getLoadedClass() {
            return this.loadedClass;
        }

        protected synchronized Servlet getRepresentative() {
            if (!ServletWrapper.this.inited || this.capacity < 1 || this.loadedClass == null) {
                return null;
            }
            if (this.singleThreaded) {
                return null;
            }
            return this.pool[0];
        }

        protected synchronized void releaseServlet(Servlet servlet) throws ServletException {
            if (!ServletWrapper.this.inited || this.capacity < 1 || this.pool == null || this.loadedClass == null) {
                throw new ServletException("Releasing servlet without initialization.");
            }
            if (this.usage > 0) {
                if (this.singleThreaded) {
                    this.pool[--this.usage] = servlet;
                    this.notifyAll();
                } else {
                    --this.usage;
                }
            } else {
                throw new ServletException("Incorrect servlet release occurred.");
            }
        }

        protected Servlet remove() {
            if (this.capacity > this.usage) {
                Servlet servlet = this.pool[--this.capacity];
                if (this.capacity < 1) {
                    this.pool = null;
                    this.loadedClass = null;
                    this.singleThreaded = false;
                    this.maximum = 1;
                }
                return servlet;
            }
            return null;
        }

        protected synchronized Servlet takeServlet() throws ServletException {
            if (!ServletWrapper.this.inited || this.capacity < 1 || this.pool == null || this.loadedClass == null) {
                throw new ServletException("Accessing servlet without initialization.");
            }
            if (this.singleThreaded) {
                try {
                    while (true) {
                        if (this.usage < this.capacity) {
                            return this.pool[this.usage++];
                        }
                        if (this.capacity < this.maximum) {
                            if (ServletWrapper.this.launchServlet(this.loadedClass)) {
                                this.notifyAll();
                                Thread.currentThread();
                                Thread.yield();
                                continue;
                            }
                            this.wait();
                            continue;
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ServletException("Waiting for a free servlet instance interrupted.");
                }
            }
            ++this.usage;
            return this.pool[0];
        }
    }

    protected class ServletRunner
    implements Runnable,
    EventHandler {
        Servlet srServlet = null;
        JigsawHttpServletRequest srReq = null;
        JigsawHttpServletResponse srResp = null;
        Thread t = null;
        private Object stimer = null;
        private httpd server = (httpd)ServletWrapper.this.getServer();

        ServletRunner(Servlet servlet, JigsawHttpServletRequest jigsawHttpServletRequest, JigsawHttpServletResponse jigsawHttpServletResponse) {
            this.srServlet = servlet;
            this.srReq = jigsawHttpServletRequest;
            this.srResp = jigsawHttpServletResponse;
        }

        public void handleTimerEvent(Object object, long l) {
            this.signalTimeout();
        }

        public void run() {
            Object object;
            Object object2;
            Object object3;
            block48: {
                object3 = this;
                synchronized (object3) {
                    this.t = Thread.currentThread();
                }
                this.stimer = this.server.timer.registerTimer(this.server.getRequestTimeOut(), this, null);
                object3 = this.t.getName();
                this.t.setName("ServletRunner<" + (String)object3 + ":" + this.srServlet.hashCode() + ">");
                object2 = null;
                try {
                    try {
                        object = this.srResp.getReply();
                        if (object != null) {
                            object2 = ((HttpMessage)object).getState("org.w3c.jigsaw.servlet.monitor");
                        }
                        this.srServlet.service((ServletRequest)this.srReq, (ServletResponse)this.srResp);
                        try {
                            ServletWrapper.this.servletPool.releaseServlet(this.srServlet);
                        }
                        finally {
                            Object var7_7 = null;
                            this.srServlet = null;
                        }
                        if (this.stimer != null) {
                            this.server.timer.recallTimer(this.stimer);
                            this.stimer = null;
                        }
                        this.srResp.flushStream(true);
                    }
                    catch (UnavailableException unavailableException) {
                        String string = null;
                        this.srResp.setStatus(503);
                        if (unavailableException.isPermanent()) {
                            string = "<h2>The servlet is permanently unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>";
                            try {
                                this.srResp.sendError(503, string);
                            }
                            catch (IOException iOException) {}
                        } else {
                            int n = unavailableException.getUnavailableSeconds();
                            if (n > 0) {
                                string = "<h2>The servlet is temporarily unavailable :</h2>Delay : " + n + " seconds<br><br>Details: <b>" + unavailableException.getMessage() + "</b>";
                                this.srResp.getReply().setRetryAfter(n);
                                try {
                                    this.srResp.sendError(503, string);
                                }
                                catch (IOException iOException) {}
                            } else {
                                string = "<h2>The servlet is temporarily unavailable :</h2>Details: <b>" + unavailableException.getMessage() + "</b>";
                                try {
                                    this.srResp.sendError(503, string);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (this.srResp.isStreamObtained()) {
                            try {
                                this.srResp.flushStream(false);
                                OutputStream outputStream = this.srResp.getRawOutputStream();
                                if (outputStream != null) {
                                    OutputStream outputStream2 = outputStream;
                                    synchronized (outputStream2) {
                                        PrintWriter printWriter = new PrintWriter(outputStream);
                                        exception.printStackTrace(printWriter);
                                        printWriter.flush();
                                    }
                                }
                                this.srResp.flushStream(true);
                            }
                            catch (IOException iOException) {}
                        }
                        try {
                            this.srResp.sendError(500, "Servlet has thrown exception:" + exception.toString());
                        }
                        catch (IOException iOException) {
                        }
                    }
                    Object var4_15 = null;
                    if (this.stimer == null) break block48;
                    this.server.timer.recallTimer(this.stimer);
                }
                catch (Throwable throwable) {
                    Object object4;
                    Object var4_16 = null;
                    if (this.stimer != null) {
                        this.server.timer.recallTimer(this.stimer);
                        this.stimer = null;
                    }
                    if (this.srServlet != null) {
                        try {
                            ServletWrapper.this.servletPool.releaseServlet(this.srServlet);
                        }
                        catch (ServletException servletException) {}
                    }
                    if (object2 != null) {
                        object4 = object2;
                        synchronized (object4) {
                            object2.notifyAll();
                        }
                    }
                    this.t.setName((String)object3);
                    this.srServlet = null;
                    this.srReq = null;
                    object4 = this.srResp.getReply();
                    if (object4 != null) {
                        ((HttpMessage)object4).setState(ServletWrapper.ENDED, new Object());
                    }
                    this.srResp = null;
                    throw throwable;
                }
                this.stimer = null;
            }
            if (this.srServlet != null) {
                try {
                    ServletWrapper.this.servletPool.releaseServlet(this.srServlet);
                }
                catch (ServletException servletException) {}
            }
            if (object2 != null) {
                object = object2;
                synchronized (object) {
                    object2.notifyAll();
                }
            }
            this.t.setName((String)object3);
            this.srServlet = null;
            this.srReq = null;
            object = this.srResp.getReply();
            if (object != null) {
                ((HttpMessage)object).setState(ServletWrapper.ENDED, new Object());
            }
            this.srResp = null;
        }

        protected void signalTimeout() {
            ServletRunner servletRunner = this;
            synchronized (servletRunner) {
                this.stimer = null;
            }
            servletRunner = this;
            synchronized (servletRunner) {
                if (this.t != null) {
                    this.t.interrupt();
                }
            }
        }
    }
}

