/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pics;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.w3c.jigsaw.pics.InvalidLabelException;
import org.w3c.jigsaw.pics.LabelInterface;
import org.w3c.jigsaw.pics.LabelServiceInterface;
import org.w3c.jigsaw.pics.PICS;
import org.w3c.jigsaw.pics.SampleLabel;
import org.w3c.jigsaw.pics.SampleLabelBureau;
import org.w3c.jigsaw.pics.UnknownServiceException;

public class SampleLabelService
implements LabelServiceInterface {
    File directory = null;
    String name = null;

    public SampleLabelService(SampleLabelBureau sampleLabelBureau, String string) throws UnknownServiceException {
        this.name = string;
        try {
            this.directory = new File(sampleLabelBureau.getIdentifier());
            this.directory = this.filify(new URL(string), false);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnknownServiceException(string);
        }
        if (PICS.debug()) {
            System.out.println("LabelService for " + string + " is in " + this.directory.getAbsolutePath());
        }
        if (!this.directory.exists() || !this.directory.isDirectory()) {
            throw new UnknownServiceException(string);
        }
    }

    public void dump(StringBuffer stringBuffer, int n) {
        stringBuffer.append(" \"" + this.getName() + "\"");
    }

    public File filify(URL uRL, boolean bl) {
        File file = null;
        file = new File(this.getDirectory(), uRL.getProtocol());
        file = new File(file, uRL.getHost());
        if (uRL.getPort() != 80 && uRL.getPort() != -1) {
            file = new File(file, new Integer(uRL.getPort()).toString());
        }
        if (uRL.getFile() != null && !uRL.getFile().equals("/")) {
            String string = bl ? String.valueOf(uRL.getFile().substring(1)) + ".gen" : uRL.getFile().substring(1);
            file = new File(file, this.slashify(string));
        } else if (bl) {
            file = new File(file.getParent(), String.valueOf(file.getName()) + ".gen");
        }
        if (PICS.debug()) {
            System.out.println("Label for " + uRL + " in [" + file + "]");
        }
        return file;
    }

    private final File getDirectory() {
        return this.directory;
    }

    public LabelInterface getGenericLabel(URL uRL) {
        try {
            while (true) {
                Object object;
                File file;
                if ((file = this.filify(uRL, true)).exists()) {
                    object = null;
                    try {
                        object = new SampleLabel(file);
                    }
                    catch (InvalidLabelException invalidLabelException) {
                        return null;
                    }
                    return object;
                }
                object = uRL.getFile();
                if (object == null || ((String)object).equals("/")) {
                    return null;
                }
                String string = uRL.getFile();
                if (string.length() - 1 == string.lastIndexOf("/")) {
                    string = string.substring(0, string.length() - 2);
                }
                if ((string = string.substring(0, string.lastIndexOf("/"))).length() == 0) {
                    string = "/";
                }
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public LabelInterface[] getGenericTreeLabels(URL uRL) {
        Object object;
        File file = this.filify(uRL, false);
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        LabelInterface labelInterface = this.getGenericLabel(uRL);
        Vector<Object> vector = new Vector<Object>(stringArray.length);
        if (labelInterface != null) {
            vector.addElement(labelInterface);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(".gen")) {
                object = null;
                try {
                    object = new SampleLabel(new File(file, stringArray[n]));
                }
                catch (InvalidLabelException invalidLabelException) {
                    object = null;
                }
                if (object != null) {
                    vector.addElement(object);
                }
            }
            ++n;
        }
        if (vector.size() > 0) {
            object = new SampleLabel[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public LabelInterface getSpecificLabel(URL uRL) {
        File file = this.filify(uRL, false);
        if (file.exists()) {
            SampleLabel sampleLabel = null;
            try {
                sampleLabel = new SampleLabel(file);
            }
            catch (InvalidLabelException invalidLabelException) {
                return null;
            }
            return sampleLabel;
        }
        return null;
    }

    public LabelInterface[] getTreeLabels(URL uRL) {
        Object object;
        File file = this.filify(uRL, false);
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        LabelInterface labelInterface = this.getGenericLabel(uRL);
        Vector<Object> vector = new Vector<Object>(stringArray.length);
        if (labelInterface != null) {
            vector.addElement(labelInterface);
        }
        int n = 0;
        while (n < stringArray.length) {
            object = null;
            try {
                object = new SampleLabel(new File(file, stringArray[n]));
            }
            catch (InvalidLabelException invalidLabelException) {
                object = null;
            }
            if (object != null) {
                vector.addElement(object);
            }
            ++n;
        }
        if (vector.size() > 0) {
            object = new SampleLabel[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    private String slashify(String string) {
        String string2 = System.getProperty("file.separator");
        if (string2.equals("/")) {
            return string;
        }
        if (string2.length() != 1) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " invalid separator length !");
        }
        return string.replace('/', '\\');
    }
}

