/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.frames;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.jigsaw.frames.CGIHeaderHolder;
import org.w3c.jigsaw.frames.CGIHeaderHolderFactory;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.frames.ProcessErrorReader;
import org.w3c.jigsaw.frames.ProcessFeeder;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidParentException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.PropertiesAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.mime.MimeType;

public class CgiFrame
extends HTTPFrame {
    private static final String STATE_EXTRA_PATH = "org.w3c.jigsaw.frames.CgiFrame.extraPath";
    protected static int ATTR_INTERPRETER = -1;
    protected static int ATTR_COMMAND = -1;
    protected static int ATTR_NOHEADER = -1;
    protected static int ATTR_GENERATES_FORM = -1;
    protected static int ATTR_REMOTE_HOST = -1;
    protected static int ATTR_CGI_DEBUG = -1;
    protected static int ATTR_ENV = -1;

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.frames.CgiFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringAttribute("interpreter", null, 2);
        ATTR_INTERPRETER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("command", null, 6);
        ATTR_COMMAND = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("noheader", Boolean.FALSE, 2);
        ATTR_NOHEADER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("generates-form", Boolean.TRUE, 2);
        ATTR_GENERATES_FORM = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("remote-host", null, 2);
        ATTR_REMOTE_HOST = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new BooleanAttribute("cgi-debug", Boolean.FALSE, 2);
        ATTR_CGI_DEBUG = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new PropertiesAttribute("environment", null, 2);
        ATTR_ENV = AttributeRegistry.registerAttribute(clazz, attribute);
    }

    private void addEnv(String string, String string2, Vector vector) {
        vector.addElement(String.valueOf(string) + "=" + string2);
    }

    public boolean checkCgiDebug() {
        return this.getBoolean(ATTR_CGI_DEBUG, false);
    }

    public boolean checkGeneratesFormFlag() {
        return this.getBoolean(ATTR_GENERATES_FORM, true);
    }

    public boolean checkNoheaderFlag() {
        return this.getBoolean(ATTR_NOHEADER, false);
    }

    public boolean checkRemoteHost() {
        return this.getBoolean(ATTR_REMOTE_HOST, false);
    }

    public Reply get(Request request) throws ProtocolException, ResourceException {
        if (!this.checkGeneratesFormFlag()) {
            return super.get(request);
        }
        Process process = null;
        try {
            process = this.makeCgiCommand(request);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Reply reply = request.makeReply(404);
            reply.setContent("The resource's script wasn't found.");
            throw new HTTPException(reply);
        }
        return this.handleCGIOutput(process, request);
    }

    public String[] getCommand() {
        return (String[])this.getValue(ATTR_COMMAND, null);
    }

    public HttpEntityTag getETag() {
        HttpEntityTag httpEntityTag;
        if (this.etag == null && (httpEntityTag = super.getETag()) != null) {
            this.etag.setWeak(true);
        }
        return this.etag;
    }

    public String getEnvName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(5 + n);
        stringBuffer.append("HTTP_");
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuffer.append(c == '-' ? (char)'_' : (char)Character.toUpperCase(c));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getInterpreter() {
        return this.getString(ATTR_INTERPRETER, null);
    }

    public ArrayDictionary getUserEnv() {
        return (ArrayDictionary)this.getValue(ATTR_ENV, null);
    }

    protected Reply handleCGIOutput(Process process, Request request) throws ProtocolException {
        new ProcessErrorReader(process).start();
        if (this.checkNoheaderFlag()) {
            Reply reply = request.makeReply(1000);
            reply.setStream(process.getInputStream());
            return reply;
        }
        if (this.checkCgiDebug()) {
            Reply reply = request.makeReply(200);
            reply.setContentType(MimeType.TEXT_PLAIN);
            reply.setStream(process.getInputStream());
            return reply;
        }
        MimeParser mimeParser = new MimeParser(process.getInputStream(), new CGIHeaderHolderFactory());
        Reply reply = null;
        try {
            Enumeration enumeration;
            String string;
            CGIHeaderHolder cGIHeaderHolder = (CGIHeaderHolder)mimeParser.parse();
            String string2 = cGIHeaderHolder.getStatus();
            String string3 = cGIHeaderHolder.getLocation();
            if (string2 != null) {
                int n = -1;
                try {
                    string = string2.trim();
                    int n2 = string.indexOf(32);
                    if (n2 != -1) {
                        string = string.substring(0, n2);
                    }
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    String string4 = "Emited an invalid status line [" + string2 + "].";
                    this.getServer().errlog(this, string4);
                    reply = request.makeReply(500);
                    reply.setContent("CGI script emited invalid status.");
                    throw new HTTPException(reply);
                }
                reply = this.createDefaultReply(request, n);
                reply.setContentLength(-1);
            } else if (string3 != null) {
                reply = request.makeReply(302);
            } else {
                reply = this.createDefaultReply(request, 200);
                reply.setContentLength(-1);
            }
            if (string3 != null) {
                try {
                    reply.setLocation(new URL(this.getURL(request), string3));
                }
                catch (MalformedURLException malformedURLException) {
                    this.getServer().errlog(this, "unable to create location url " + string3 + " in base " + this.getURL(request));
                }
            }
            if ((enumeration = cGIHeaderHolder.enumerateHeaders()) != null) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    reply.setValue(string, cGIHeaderHolder.getValue(string));
                }
            }
            reply.setStream(mimeParser.getInputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MimeParserException mimeParserException) {
            String string = String.valueOf(String.valueOf(this.getURL(request))) + ": emited invalid output [" + mimeParserException.getMessage() + "]";
            this.getServer().errlog(this, string);
            Reply reply2 = request.makeReply(500);
            reply2.setContent("CGI error: unable to parse script headers.");
            throw new HTTPException(reply2);
        }
        if (reply != null) {
            reply.setDynamic(true);
        }
        return reply;
    }

    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        Request request;
        String string = lookupState.getRemainingPath(true);
        if (string == null || string.equals("")) {
            string = "/";
        }
        if ((request = (Request)lookupState.getRequest()) != null) {
            request.setState(STATE_EXTRA_PATH, string);
        }
        lookupResult.setTarget(this.getResource().getResourceReference());
        return super.lookup(lookupState, lookupResult);
    }

    protected Process makeCgiCommand(Request request) throws ProtocolException, IOException {
        Object[] objectArray;
        Enumeration enumeration;
        Object object;
        String string = null;
        Object[] objectArray2 = this.getCommand();
        if (objectArray2 == null) {
            Reply reply = request.makeReply(500);
            reply.setContent("CgiResource mis-configured: it doesn't have a  command attribute");
            throw new HTTPException(reply);
        }
        Vector vector = new Vector(32);
        httpd httpd2 = request.getClient().getServer();
        InetAddress inetAddress = httpd2.getInetAddress();
        String string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.type");
        if (string2 != null) {
            this.addEnv("AUTH_TYPE", string2, vector);
        }
        if ((string2 = request.getValue("content-length")) != null) {
            this.addEnv("CONTENT_LENGTH", string2, vector);
        }
        if ((string2 = request.getValue("content-type")) != null) {
            this.addEnv("CONTENT_TYPE", string2, vector);
        }
        this.addEnv("GATEWAY_INTERFACE", "CGI/1.1", vector);
        string2 = (String)request.getState(STATE_EXTRA_PATH);
        if (string2 == null) {
            this.addEnv("PATH_INFO", "/", vector);
        } else {
            this.addEnv("PATH_INFO", string2, vector);
        }
        string = request.getQueryString();
        if (string != null) {
            this.addEnv("QUERY_STRING", string, vector);
        }
        string2 = request.getClient().getInetAddress().toString();
        this.addEnv("REMOTE_ADDR", string2, vector);
        string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        if (string2 != null) {
            this.addEnv("REMOTE_USER", string2, vector);
        }
        if (this.checkRemoteHost()) {
            object = request.getClient().getInetAddress().getHostName();
            this.addEnv("REMOTE_HOST", (String)object, vector);
        }
        this.addEnv("REQUEST_METHOD", request.getMethod(), vector);
        this.addEnv("SCRIPT_NAME", this.getURLPath(), vector);
        this.addEnv("SERVER_NAME", this.getServer().getHost(), vector);
        string2 = Integer.toString(this.getServer().getLocalPort());
        this.addEnv("SERVER_PORT", string2, vector);
        this.addEnv("SERVER_PROTOCOL", request.getVersion(), vector);
        this.addEnv("SERVER_SOFTWARE", httpd2.getSoftware(), vector);
        if (this.getFileResource() != null) {
            this.addEnv("PATH_TRANSLATED", this.getFileResource().getFile().getAbsolutePath(), vector);
        }
        if ((object = this.getUserEnv()) != null) {
            enumeration = ((ArrayDictionary)object).keys();
            while (enumeration.hasMoreElements()) {
                objectArray = (String)enumeration.nextElement();
                this.addEnv((String)objectArray, (String)((ArrayDictionary)object).get(objectArray), vector);
            }
        }
        enumeration = request.enumerateHeaderDescriptions(false);
        while (enumeration.hasMoreElements()) {
            objectArray = (HeaderDescription)enumeration.nextElement();
            this.addEnv(this.getEnvName(objectArray.getName()), request.getHeaderValue((HeaderDescription)objectArray).toString(), vector);
        }
        if (string != null) {
            objectArray = new String[objectArray2.length + 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            objectArray[objectArray2.length] = string;
            objectArray2 = objectArray;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (this.getInterpreter() != null) {
            String[] stringArray = new String[objectArray2.length + 1];
            stringArray[0] = this.getInterpreter();
            System.arraycopy(objectArray2, 0, stringArray, 1, objectArray2.length);
            return Runtime.getRuntime().exec(stringArray, (String[])objectArray);
        }
        return Runtime.getRuntime().exec((String[])objectArray2, (String[])objectArray);
    }

    public Reply post(Request request) throws ProtocolException, ResourceException {
        Process process = null;
        try {
            process = this.makeCgiCommand(request);
        }
        catch (IOException iOException) {
            String string = "The process " + this.getCommand()[0] + " couldn't be executed [" + iOException.getMessage() + "]";
            this.getServer().errlog(this, string);
            Reply reply = request.makeReply(500);
            reply.setContent("CGI script is misconfigured.");
            throw new HTTPException(reply);
        }
        try {
            InputStream inputStream;
            Client client = request.getClient();
            if (client != null) {
                client.sendContinue();
            }
            if ((inputStream = request.getInputStream()) == null) {
                process.getOutputStream().close();
            } else {
                new ProcessFeeder(process, inputStream).start();
            }
        }
        catch (IOException iOException) {
            Reply reply = request.makeReply(400);
            reply.setContent("The request didn't have a valid input.");
            throw new HTTPException(reply);
        }
        return this.handleCGIOutput(process, request);
    }

    public void registerResource(FramedResource framedResource) {
        block3: {
            super.registerResource(framedResource);
            if (this.getCommand() != null || this.getFileResource() == null) break block3;
            try {
                if (this.getFileResource().getFile() != null) {
                    String[] stringArray = new String[]{this.getFileResource().getFile().getAbsolutePath()};
                    this.setValue(ATTR_COMMAND, (Object)stringArray);
                }
            }
            catch (InvalidParentException invalidParentException) {}
        }
    }
}

