/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.util.Calendar;
import java.util.Date;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.DateAttribute;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.SimpleAttribute;

public class HourLimiterFilter
extends ResourceFilter {
    public static int ATTR_DAY_REPEAT = -1;
    public static int ATTR_WEEK_REPEAT = -1;
    public static int ATTR_MONTH_REPEAT = -1;
    public static int ATTR_YEAR_REPEAT = -1;
    public static int ATTR_DATE_START = -1;
    public static int ATTR_DATE_END = -1;
    private int a_year;
    private int a_month;
    private int a_week;
    private int a_day;
    private int a_time;
    private int b_year;
    private int b_month;
    private int b_week;
    private int b_day;
    private int b_time;

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.HourLimiterFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new BooleanAttribute("day_repeat", Boolean.FALSE, 2);
        ATTR_DAY_REPEAT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("week_repeat", Boolean.FALSE, 2);
        ATTR_WEEK_REPEAT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("month_repeat", Boolean.FALSE, 2);
        ATTR_MONTH_REPEAT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("year_repeat", Boolean.FALSE, 2);
        ATTR_YEAR_REPEAT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new DateAttribute("start", (Object)null, 2);
        ATTR_DATE_START = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new DateAttribute("end", (Object)null, 2);
        ATTR_DATE_END = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    protected boolean getDayRepeat() {
        return this.getBoolean(ATTR_DAY_REPEAT, false);
    }

    protected boolean getMonthRepeat() {
        return this.getBoolean(ATTR_MONTH_REPEAT, false);
    }

    protected boolean getWeekRepeat() {
        return this.getBoolean(ATTR_WEEK_REPEAT, false);
    }

    protected boolean getYearRepeat() {
        return this.getBoolean(ATTR_YEAR_REPEAT, false);
    }

    public synchronized ReplyInterface ingoingFilter(RequestInterface requestInterface) {
        Object object;
        Request request = (Request)requestInterface;
        Reply reply = null;
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(7);
        int n4 = calendar.get(5);
        int n5 = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        if (this.getDayRepeat()) {
            if (n5 < this.a_time || n5 > this.b_time) {
                reply = request.makeReply(503);
                if (n5 < this.a_time) {
                    reply.setRetryAfter(this.a_time - n5);
                } else {
                    reply.setRetryAfter(84600 + n5 - this.a_time);
                }
            }
        } else if (this.getWeekRepeat()) {
            int n6 = this.a_time + this.a_week * 86400;
            int n7 = this.b_time + this.b_week * 86400;
            int n8 = n5 + n3 * 86400;
            if (n8 < n6 || n8 > n7) {
                reply = request.makeReply(503);
                if (n8 < n6) {
                    reply.setRetryAfter(n6 - n8);
                } else {
                    reply.setRetryAfter(592200 + n8 - n6);
                }
            }
        } else if (this.getMonthRepeat()) {
            int n9 = this.a_time + this.a_day * 86400;
            int n10 = this.b_time + this.b_day * 86400;
            int n11 = n5 + n4 * 86400;
            if (n11 < n9 || n11 > n10) {
                reply = request.makeReply(503);
                if (n11 < n9) {
                    reply.setRetryAfter(n9 - n11);
                } else {
                    calendar.setTime(new Date(this.getLong(ATTR_DATE_START, -1L)));
                    calendar.set(1, n);
                    calendar.set(2, n2);
                    calendar.roll(2, true);
                    reply.setRetryAfter(calendar.getTime().getTime());
                }
            }
        } else if (this.getYearRepeat()) {
            object = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            ((Calendar)object).setTime(new Date(this.getLong(ATTR_DATE_START, -1L)));
            calendar2.setTime(new Date(this.getLong(ATTR_DATE_END, -1L)));
            ((Calendar)object).set(1, n);
            calendar2.set(1, n);
            if (calendar.before(object)) {
                reply = request.makeReply(503);
                reply.setRetryAfter(((Calendar)object).getTime().getTime());
            } else if (calendar.after(calendar2)) {
                ((Calendar)object).roll(1, true);
                reply = request.makeReply(503);
                reply.setRetryAfter(((Calendar)object).getTime().getTime());
            }
        } else {
            object = Calendar.getInstance();
            Calendar calendar3 = Calendar.getInstance();
            ((Calendar)object).setTime(new Date(this.getLong(ATTR_DATE_START, -1L)));
            calendar3.setTime(new Date(this.getLong(ATTR_DATE_END, -1L)));
            if (calendar.before(object)) {
                reply = request.makeReply(503);
                reply.setRetryAfter(((Calendar)object).getTime().getTime());
            } else if (calendar.after(calendar3)) {
                reply = request.makeReply(503);
            }
        }
        if (reply != null) {
            object = new HtmlGenerator("Service Unavailable");
            ((HtmlGenerator)object).append("You may retry after the delay or the date given");
            reply.setStream((HtmlGenerator)object);
        }
        return reply;
    }

    public void initialize(Object[] objectArray) {
        Calendar calendar = Calendar.getInstance();
        long l = System.currentTimeMillis();
        super.initialize(objectArray);
        calendar.setTime(new Date(this.getLong(ATTR_DATE_START, l)));
        this.a_year = calendar.get(1);
        this.a_month = calendar.get(2);
        this.a_week = calendar.get(7);
        this.a_day = calendar.get(5);
        this.a_time = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        calendar.setTime(new Date(this.getLong(ATTR_DATE_END, l)));
        this.b_year = calendar.get(1);
        this.b_month = calendar.get(2);
        this.b_week = calendar.get(7);
        this.b_day = calendar.get(5);
        this.b_time = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_DATE_START) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date((Long)object));
            this.a_year = calendar.get(1);
            this.a_month = calendar.get(2);
            this.a_week = calendar.get(7);
            this.a_day = calendar.get(5);
            this.a_time = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        } else if (n == ATTR_DATE_END) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date((Long)object));
            this.b_year = calendar.get(1);
            this.b_month = calendar.get(2);
            this.b_week = calendar.get(7);
            this.b_day = calendar.get(5);
            this.b_time = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        }
    }
}

