/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.webdav.xml;

import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;
import org.w3c.www.webdav.xml.DAVFactory;
import org.w3c.www.webdav.xml.DAVLink;
import org.w3c.www.webdav.xml.DAVLockEntry;
import org.w3c.www.webdav.xml.DAVNode;

public class DAVProperties
extends DAVNode {
    DAVProperties(Element element) {
        super(element);
    }

    public void addProperty(String string) {
        this.addDAVNode(string, null);
    }

    public void addProperty(String string, String string2) {
        this.addDAVNode(string, string2);
    }

    public String getContentLanguage() {
        return this.getTextChildValue("getcontentlanguage");
    }

    public int getContentLength() {
        String string = this.getTextChildValue("getcontentlength");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public String getContentType() {
        return this.getTextChildValue("getcontenttype");
    }

    public Date getCreationDate() {
        String string = this.getTextChildValue("creationdate");
        if (string != null) {
            try {
                return DateParser.parse(string);
            }
            catch (InvalidDateException invalidDateException) {
                return null;
            }
        }
        return null;
    }

    public String getDisplayName() {
        return this.getTextChildValue("displayname");
    }

    public String getETag() {
        return this.getTextChildValue("getetag");
    }

    public Date getLastModified() {
        String string = this.getTextChildValue("getlastmodified");
        if (string != null) {
            try {
                return DateParser.parse(string);
            }
            catch (InvalidDateException invalidDateException) {
                return null;
            }
        }
        return null;
    }

    public String getLockDiscovery() {
        return this.getTextChildValue("lockdiscovery");
    }

    public Element[] getProperties() {
        return this.getChildrenElements();
    }

    public String getProperty(String string) {
        return this.getTextChildValue(string);
    }

    public String[] getPropertyNames() {
        return this.getDAVNodeNames();
    }

    public String getResourceType() {
        return this.getTextChildValue("resourcetype");
    }

    public DAVLink[] getSources() {
        Vector vector = this.getDAVElementsByTagName("source");
        int n = vector.size();
        DAVLink[] dAVLinkArray = new DAVLink[n];
        int n2 = 0;
        while (n2 < n) {
            dAVLinkArray[n2] = new DAVLink((Element)vector.elementAt(n2));
            ++n2;
        }
        return dAVLinkArray;
    }

    public DAVLockEntry[] getSupportedLocks() {
        Vector vector = this.getDAVElementsByTagName("supportedlock");
        int n = vector.size();
        DAVLockEntry[] dAVLockEntryArray = new DAVLockEntry[n];
        int n2 = 0;
        while (n2 < n) {
            dAVLockEntryArray[n2] = new DAVLockEntry((Element)vector.elementAt(n2));
            ++n2;
        }
        return dAVLockEntryArray;
    }

    public void setResourceType(String string) {
        Document document = this.element.getOwnerDocument();
        Node node = DAVNode.getDAVNode(this.element, "resourcetype");
        Element element = DAVFactory.createDAVElement(document, "resourcetype");
        if (string != null) {
            DAVNode.addDAVNode(element, string, null);
        }
        if (node != null) {
            this.element.replaceChild(element, node);
        } else {
            this.element.appendChild(element);
        }
    }
}

