/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache.push;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.w3c.www.protocol.http.cache.push.PushCacheListener;
import org.w3c.www.protocol.http.cache.push.PushCacheManager;
import org.w3c.www.protocol.http.cache.push.PushCacheProtocol;
import org.w3c.www.protocol.http.cache.push.PushReply;

public class PushCacheHandler
extends Thread {
    private Socket _socket = null;
    private boolean _running = false;
    private InputStream _stream = null;
    private byte[] _buffer = new byte[16];
    private byte[] _textBuffer = new byte[1024];
    private PushCacheListener _listener;
    DataInputStream _dataStream = null;

    public PushCacheHandler(PushCacheListener pushCacheListener, Socket socket) throws IOException {
        this._listener = pushCacheListener;
        this._socket = socket;
        this._stream = this._socket.getInputStream();
        this._listener.registerHandler(this);
    }

    protected void add() throws IOException {
        int n = this._dataStream.readInt();
        int n2 = this._dataStream.readInt();
        if (n == 0 || n2 == 0) {
            throw new IOException("Zero length path or url in ADD command");
        }
        if (n > 1024 || n2 > 1024) {
            throw new IOException("String too long in ADD command");
        }
        String string = new String(this._textBuffer, 8, n - 1);
        String string2 = new String(this._textBuffer, n + 8, n2 - 1);
        PushCacheManager.instance().storeReply(new PushReply(string, string2));
        this.reply_ok();
    }

    protected void clean() throws Exception {
        PushCacheManager.instance().cleanCache();
        this.reply_ok();
    }

    protected void cleanup() {
        try {
            this._socket.close();
            this._stream.close();
        }
        catch (IOException iOException) {}
        this._socket = null;
        this._stream = null;
        this._listener.deregisterHandler(this);
    }

    protected void del() throws Exception {
        String string = new String(this._textBuffer, 0, this._textBuffer.length - 1);
        PushCacheManager.instance().removeURL(string);
        this.reply_ok();
    }

    protected void nop() throws Exception {
        this.reply_ok();
    }

    protected void present() throws Exception {
        String string = new String(this._textBuffer, 0, this._textBuffer.length - 1);
        if (PushCacheManager.instance().isPresent(string)) {
            this.reply_ok();
        } else {
            this.reply_no();
        }
    }

    public void printBuffer(byte[] byArray, int n) {
        Integer n2 = new Integer(0);
        int n3 = 0;
        System.err.println("buffer: ");
        int n4 = 0;
        while (n4 < n) {
            byte by = byArray[n4];
            if (!Character.isISOControl((char)by)) {
                Character c = new Character((char)by);
                System.err.print(" " + c.charValue() + " ");
            } else {
                n3 = 0xFF & by;
                if (n3 < 16) {
                    System.err.print("0" + Integer.toHexString(n3) + " ");
                } else {
                    System.err.print(String.valueOf(Integer.toHexString(n3)) + " ");
                }
            }
            ++n4;
        }
        System.err.print("\n");
    }

    protected void readPayload() throws IOException {
        this._dataStream.skipBytes(4);
        int n = this._dataStream.readInt();
        if (n == 0) {
            return;
        }
        if (n > 8192) {
            throw new IOException("Payload length " + n + " exceeds maximum length " + 8192);
        }
        this._textBuffer = new byte[n];
        int n2 = 0;
        int n3 = n;
        n2 = 0;
        n3 = n;
        int n4 = -1;
        while (n3 > 0) {
            n4 = this._stream.read(this._textBuffer, n2, n3);
            if (n4 < 0) {
                throw new IOException("read returned " + n4 + " after reading " + n2 + " bytes");
            }
            n2 += n4;
            n3 -= n4;
        }
        this._dataStream = new DataInputStream(new ByteArrayInputStream(this._textBuffer));
    }

    protected void reply_error(String string) {
        try {
            byte[] byArray = PushCacheProtocol.instance().errorPacket(string);
            this._socket.getOutputStream().write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void reply_no() throws IOException {
        byte[] byArray = PushCacheProtocol.instance().noPacket();
        this._socket.getOutputStream().write(byArray, 0, byArray.length);
    }

    protected void reply_ok() throws IOException {
        byte[] byArray = PushCacheProtocol.instance().okPacket();
        this._socket.getOutputStream().write(byArray, 0, byArray.length);
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        this._running = true;
        try {
            while (this._running) {
                n = this._stream.read(this._buffer);
                if (!PushCacheProtocol.instance().isValidProtocolTag(this._buffer)) {
                    throw new Exception("Bad protocol tag");
                }
                this._dataStream = new DataInputStream(new ByteArrayInputStream(this._buffer));
                this._dataStream.skipBytes(4);
                short s = this._dataStream.readShort();
                short s2 = this._dataStream.readShort();
                if (s != 1 || s2 > 2) {
                    throw new Exception("Bad protocol version");
                }
                String string = new String(this._buffer, 8, 4);
                int n2 = PushCacheProtocol.instance().parseCommand(string);
                this.readPayload();
                switch (n2) {
                    case 1: {
                        this.add();
                        break;
                    }
                    case 5: {
                        this.stopRunning();
                        break;
                    }
                    case 2: {
                        this.del();
                        break;
                    }
                    case 3: {
                        this.clean();
                        break;
                    }
                    case 4: {
                        this.present();
                        break;
                    }
                    case 8: {
                        this.nop();
                        break;
                    }
                    default: {
                        throw new Exception("Unrecognised command \"" + string + "\"");
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._running = false;
            this.reply_error(exception.getMessage());
        }
        this.cleanup();
    }

    public void stopRunning() {
        try {
            this._running = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

