/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache.push;

import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.ActiveStream;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CacheSerializer;
import org.w3c.www.protocol.http.cache.CacheSweeper;
import org.w3c.www.protocol.http.cache.CacheValidator;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.EntityCachedResource;
import org.w3c.www.protocol.http.cache.InvalidCacheException;
import org.w3c.www.protocol.http.cache.push.PushCacheListener;
import org.w3c.www.protocol.http.cache.push.PushCacheManager;
import org.w3c.www.protocol.http.cache.push.PushCacheStore;

public class PushCacheFilter
extends CacheFilter {
    public static final String PORT_NUM_P = "org.w3c.www.protocol.http.cache.push.portnumber";
    public static final int DEFAULT_PORT_NUM = 9876;

    public boolean canUseCache(Request request) {
        return true;
    }

    public PushCacheStore getPushCacheStore() {
        return (PushCacheStore)super.getStore();
    }

    /*
     * Unable to fully structure code
     */
    public Reply ingoingFilter(Request var1_1) throws HttpException {
        if (!this.canUseCache(var1_1)) {
            if (this.debug) {
                this.trace(var1_1, "*** Can't use cache");
            }
            if (this.connected) {
                var2_2 = null;
                var3_5 = null;
                try {
                    var4_8 = var1_1.getURL().toExternalForm();
                    var2_2 = this.store.getCachedResourceReference(var4_8);
                    if (var2_2 != null) {
                        var3_5 = (EntityCachedResource)var2_2.lookupResource(var1_1);
                    }
                }
                catch (InvalidCacheException v0) {
                    var3_5 = null;
                }
                if (var3_5 != null) {
                    var3_5.setWillRevalidate(true);
                }
                var1_1.setState("org.w3c.www.protocol.http.cache.dont", Boolean.TRUE);
                return null;
            }
            var2_3 = var1_1.makeReply(504);
            var2_3.setContent("The cache cannot be use for <p><code>" + var1_1.getMethod() + "</code> " + "<strong>" + var1_1.getURL() + "</strong>" + ". <p>It is disconnected.");
            return var2_3;
        }
        var2_4 = var1_1.getURL().toExternalForm();
        if (this.precache.containsKey(var2_4)) {
            if (this.debug) {
                System.out.println("*** Already downloading: " + var2_4);
            }
            try {
                var3_6 = (CachedResource)this.precache.get(var2_4);
                return var3_6.perform(var1_1);
            }
            catch (Exception v1) {}
        }
        var3_7 = null;
        try {
            var3_7 = this.store.getCachedResourceReference(var2_4);
        }
        catch (InvalidCacheException v2) {
            var3_7 = null;
        }
        try {
            if (PushCacheManager.instance().isPushResource(var3_7) && (var4_9 = (EntityCachedResource)var3_7.lookupResource(var1_1)) != null) {
                var5_11 = var4_9.perform(var1_1);
                return var5_11;
            }
        }
        catch (Exception var4_10) {
            var4_10.printStackTrace();
        }
        if (var1_1.checkOnlyIfCached() || !this.connected) {
            var4_9 = null;
            if (var3_7 != null) {
                var4_9 = (EntityCachedResource)var3_7.lookupResource(var1_1);
            }
            if (var3_7 == null || var4_9 == null) {
                if (this.debug) {
                    this.trace(var1_1, "unavailable (disconnected).");
                }
                var5_12 = var1_1.makeReply(504);
                var5_12.setContent("The cache doesn't have an entry for <p><strong>" + var1_1.getURL() + "</strong>" + ". <p>And it is disconnected.");
                return var5_12;
            }
            if (this.debug) {
                this.trace(var1_1, this.connected != false ? " hit - only if cached" : " hit while disconneced");
            }
            if (!this.validator.isValid((CachedResource)var4_9, var1_1)) {
                this.addWarning(var1_1, CacheFilter.WARN_STALE);
            }
            this.addWarning(var1_1, CacheFilter.WARN_DISCONNECTED);
            var5_13 = var4_9.perform(var1_1);
            this.setWarnings(var1_1, var5_13);
            return var5_13;
        }
        if (var3_7 == null) ** GOTO lbl96
        if (var3_7.getLoadState() == 2 || var3_7.getLoadState() == 4) {
            this.setRequestRevalidation(var3_7, var1_1);
            return null;
        }
        if (this.validator.isValid(var3_7, var1_1)) {
            try {
                this.store.updateResourceGeneration(var3_7);
            }
            catch (InvalidCacheException v3) {}
            var4_9 = var3_7.perform(var1_1);
            return var4_9;
        }
        if (this.debug) {
            System.out.println("*** Revalidation asked for " + var2_4);
        }
        this.setRequestRevalidation(var3_7, var1_1);
        return null;
lbl-1000:
        // 1 sources

        {
            var4_9 = this.uritable;
            synchronized (var4_9) {
                try {
                    this.uritable.wait();
                }
                catch (InterruptedException v4) {}
            }
            if (this.precache.containsKey(var2_4)) {
                if (this.debug) {
                    System.out.println("*** Already downloading: " + var2_4);
                }
                var4_9 = (CachedResource)this.precache.get(var2_4);
                return var4_9.perform(var1_1);
            }
            this.uritable.put(var2_4, var2_4);
lbl96:
            // 2 sources

            ** while (this.uritable.containsKey((Object)var2_4))
        }
lbl97:
        // 1 sources

        return null;
    }

    public void initialize(HttpManager httpManager) throws PropRequestFilterException {
        try {
            block6: {
                this.props = httpManager.getProperties();
                this.shared = this.props.getBoolean("org.w3c.www.protocol.http.cache.shared", false);
                this.connected = this.props.getBoolean("org.w3c.www.protocol.http.cache.connected", true);
                this.debug = this.props.getBoolean("org.w3c.www.protocol.http.cache.debug", false);
                String string = this.props.getString("org.w3c.www.protocol.http.cache.validatorclass", "org.w3c.www.protocol.http.cache.SimpleCacheValidator");
                String string2 = this.props.getString("org.w3c.www.protocol.http.cache.sweeperclass", "org.w3c.www.protocol.http.cache.SimpleCacheSweeper");
                String string3 = this.props.getString("org.w3c.www.protocol.http.cache.serializerclass", "org.w3c.www.protocol.http.cache.SimpleCacheSerializer");
                try {
                    Class<?> clazz = Class.forName(string);
                    this.validator = (CacheValidator)clazz.newInstance();
                    this.validator.initialize(this);
                    clazz = Class.forName(string2);
                    this.sweeper = (CacheSweeper)clazz.newInstance();
                    this.sweeper.initialize(this);
                    clazz = Class.forName(string3);
                    this.serializer = (CacheSerializer)clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new PropRequestFilterException("Unable to start cache");
                }
                this.store = new PushCacheStore();
                try {
                    this.store.initialize(this);
                }
                catch (InvalidCacheException invalidCacheException) {
                    if (!this.debug) break block6;
                    invalidCacheException.printStackTrace();
                }
            }
            this.sweeper.start();
            ActiveStream.initialize();
            this.props.registerObserver(this);
            httpManager.setFilter(this);
            int n = this.props.getInteger(PORT_NUM_P, 9876);
            PushCacheListener pushCacheListener = new PushCacheListener(n);
            pushCacheListener.start();
            PushCacheManager.instance().registerFilter(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

