/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.w3c.www.mux.MuxReader;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.mux.MuxStreamHandler;
import org.w3c.www.mux.MuxWriter;

public class MuxStream {
    protected MuxStreamHandler handler = null;
    protected MuxReader reader = null;
    protected MuxWriter writer = null;
    protected MuxSession[] sessions = null;
    protected boolean server = false;
    protected InetAddress inetaddr = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected boolean alive = true;

    public MuxStream(boolean bl, MuxStreamHandler muxStreamHandler, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.server = bl;
        this.handler = muxStreamHandler;
        this.in = inputStream;
        this.out = outputStream;
        this.reader = new MuxReader(this, inputStream);
        this.writer = new MuxWriter(this, outputStream);
        this.sessions = new MuxSession[8];
        this.reader.start();
    }

    public MuxStream(boolean bl, MuxStreamHandler muxStreamHandler, Socket socket) throws IOException {
        this(bl, muxStreamHandler, socket.getInputStream(), socket.getOutputStream());
        this.inetaddr = socket.getInetAddress();
    }

    private MuxSession acceptSession(int n, int n2, int n3) throws IOException {
        if (this.server & (n2 & 1) == 0) {
            throw new IOException("MUX: Invalid even session id " + n2);
        }
        MuxSession muxSession = null;
        if (this.handler != null && this.handler.acceptSession(this, n2, n3)) {
            muxSession = this.createSession(n2, n3);
            this.handler.notifySession(muxSession);
        } else {
            muxSession = null;
            System.out.println(String.valueOf(String.valueOf(this)) + ": RST (accept) session " + n2);
            this.writer.writeMessage(n2, 0x8000000, 0);
            this.writer.flush();
        }
        return muxSession;
    }

    private final synchronized MuxSession allocateSession(int n) throws IOException {
        int n2 = this.server ? 2 : 3;
        while (n2 < this.sessions.length) {
            if (this.sessions[n2] == null) {
                this.sessions[n2] = new MuxSession(this, n2, n);
                return this.sessions[n2];
            }
            n2 += 2;
        }
        MuxSession muxSession = this.checkSession(n2);
        if (muxSession == null) {
            muxSession = new MuxSession(this, n2, n);
        }
        this.sessions[n2] = muxSession;
        return muxSession;
    }

    private final synchronized MuxSession checkSession(int n) throws IOException {
        if (n >= 256) {
            throw new IOException("MUX: Invalid session id " + n);
        }
        if (n >= this.sessions.length) {
            MuxSession[] muxSessionArray = new MuxSession[n + 8];
            System.arraycopy(this.sessions, 0, muxSessionArray, 0, this.sessions.length);
            this.sessions = muxSessionArray;
        }
        return this.sessions[n];
    }

    private synchronized void cleanup() {
        this.alive = false;
        this.reader.shutdown();
        this.writer.shutdown();
        this.reader = null;
        this.writer = null;
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException iOException) {}
        this.in = null;
        this.out = null;
    }

    public MuxSession connect(int n) throws IOException {
        Object object = this;
        synchronized (object) {
            if (!this.alive) {
                throw new IOException("Broken mux stream");
            }
        }
        object = this.allocateSession(n);
        this.writer.writeMessage(((MuxSession)object).getIdentifier(), 0x20000000, n, null, 0, 0);
        return object;
    }

    private synchronized MuxSession createSession(int n, int n2) throws IOException {
        MuxSession muxSession = this.sessions[n];
        if (muxSession == null) {
            this.sessions[n] = muxSession = new MuxSession(this, n, n2);
        } else {
            System.out.println("MuxStream:createSession: already existing !");
        }
        return muxSession;
    }

    protected void ctrlDefineStack(int n, int[] nArray) throws IOException {
    }

    protected void ctrlDefineString(int n, String string) {
    }

    protected void ctrlMuxControl(int n, int n2) throws IOException {
        MuxSession muxSession = this.lookupSession(n, true);
        muxSession.notifyControl(n2);
    }

    protected void ctrlSendCredit(int n, int n2) throws IOException {
        MuxSession muxSession = this.lookupSession(n, true);
        muxSession.notifyCredit(n2);
    }

    protected void error(Object object, Exception exception) {
        System.out.println("*** Fatal error on " + this);
        exception.printStackTrace();
        System.out.println("No recovery !");
        System.exit(1);
    }

    protected synchronized void error(Object object, String string) {
        boolean bl = false;
        MuxStream muxStream = this;
        synchronized (muxStream) {
            int n = 0;
            while (n < this.sessions.length) {
                if (this.sessions[n] != null) {
                    this.sessions[n].abort();
                }
                ++n;
            }
        }
        this.cleanup();
    }

    public InetAddress getInetAddress() {
        return this.inetaddr;
    }

    protected final MuxWriter getMuxWriter() {
        return this.writer;
    }

    protected MuxSession lookupSession(int n, int n2, int n3, int n4) throws IOException {
        MuxSession muxSession = this.checkSession(n2);
        if (muxSession == null) {
            if ((n & 0x20000000) != 0) {
                muxSession = this.acceptSession(n, n2, n3);
            } else if ((n & 0x10000000) != 0x10000000) {
                System.out.println(String.valueOf(String.valueOf(this)) + ": RST (lookup) session " + n2);
                if ((n & 0x8000000) != 0x8000000) {
                    this.writer.writeMessage(n2, 0x8000000, 0);
                }
            }
        }
        return muxSession;
    }

    protected synchronized MuxSession lookupSession(int n, boolean bl) {
        MuxSession muxSession;
        if (n < this.sessions.length && (muxSession = this.sessions[n]) != null) {
            return muxSession;
        }
        if (bl) {
            throw new RuntimeException("MuxStream:lookupSession:  invalid session id " + n + ".");
        }
        return null;
    }

    public synchronized boolean shutdown(boolean bl) throws IOException {
        if (!this.alive) {
            return true;
        }
        boolean bl2 = true;
        if (bl) {
            int n = 0;
            while (n < this.sessions.length) {
                MuxSession muxSession = this.sessions[n];
                if (muxSession != null) {
                    muxSession.abort();
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.sessions.length) {
                if (this.sessions[n] != null) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
        }
        if (bl2) {
            this.cleanup();
        }
        return bl2;
    }

    protected synchronized void unregisterSession(MuxSession muxSession) {
        this.sessions[muxSession.getIdentifier()] = null;
    }
}

