/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.w3c.www.mux.MuxInputStream;
import org.w3c.www.mux.MuxOutputStream;
import org.w3c.www.mux.MuxStream;

public class MuxSession {
    public static final int INPUT_BUFFER_SIZE = 4096;
    protected MuxStream stream = null;
    protected MuxInputStream in = null;
    protected MuxOutputStream out = null;
    protected int id = -1;
    protected int protid = -1;
    protected boolean aborted = false;
    protected boolean finsent = false;

    protected MuxSession(MuxStream muxStream, int n, int n2) {
        this.stream = muxStream;
        this.id = n;
        this.protid = n2;
        this.in = new MuxInputStream(this);
        this.out = new MuxOutputStream(this);
    }

    protected synchronized void abort() {
        this.aborted = true;
        try {
            this.shutdown();
        }
        catch (Exception exception) {}
    }

    public final int getIdentifier() {
        return this.id;
    }

    public InetAddress getInetAddress() {
        return this.getMuxStream().getInetAddress();
    }

    protected int getInputBufferSize() {
        return 4096;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.aborted) {
            throw new IOException("Aborted mux session");
        }
        return this.in;
    }

    protected final MuxStream getMuxStream() {
        return this.stream;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.aborted) {
            throw new IOException("Aborted mux session");
        }
        return this.out;
    }

    public final int getProtocolIdentifier() {
        return this.protid;
    }

    protected final void notifyControl(int n) {
        this.out.notifyControl(n);
    }

    protected final void notifyCredit(int n) {
        this.out.notifyCredit(n);
    }

    protected final void notifyFIN() throws IOException {
        this.in.close();
        if (this.finsent) {
            this.shutdown();
        }
    }

    protected void notifyOutputClose() throws IOException {
        this.stream.getMuxWriter().writeMessage(this.id, 0x10000000, 0);
    }

    protected void notifyPUSH() {
        System.out.println("MuxSession:notifyPUSH: not handled");
    }

    protected void notifyRST() throws IOException {
        this.in.error("Broken pipe");
        this.out.close();
        this.shutdown();
    }

    protected final void pushInput(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        this.in.push(byArray, n, n2, bl);
    }

    protected final void sendFIN() throws IOException {
        if (!this.finsent) {
            this.stream.getMuxWriter().writeMessage(this.id, 0x10000000, 0);
            this.stream.getMuxWriter().flush();
            this.finsent = true;
        }
    }

    public void shutdown() throws IOException {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.stream.unregisterSession(this);
    }
}

