/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.w3c.tools.crypt.Md5;

public final class UUID {
    private int unique;
    private long time;
    private static String address;
    private static int hostUnique;
    private static Object mutex;
    private static long lastTime;
    private static long DELAY;

    static {
        hostUnique = new Object().hashCode();
        mutex = new Object();
        lastTime = System.currentTimeMillis();
        DELAY = 10L;
        try {
            String string = InetAddress.getLocalHost().getHostAddress();
            Md5 md5 = new Md5(string);
            md5.processString();
            address = md5.getStringDigest();
        }
        catch (UnknownHostException unknownHostException) {
            address = UUID.generateNoNetworkID();
        }
    }

    public UUID() {
        Object object = mutex;
        synchronized (object) {
            boolean bl = false;
            while (!bl) {
                this.time = System.currentTimeMillis();
                if (this.time < lastTime + DELAY) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                lastTime = this.time;
                bl = true;
            }
            this.unique = hostUnique;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UUID) {
            UUID uUID = (UUID)object;
            return this.unique == uUID.unique && this.time == uUID.time && address.equals(address);
        }
        return false;
    }

    private static String generateNoNetworkID() {
        Thread thread = Thread.currentThread();
        String string = String.valueOf(Thread.activeCount()) + System.getProperty("os.version") + System.getProperty("user.name") + System.getProperty("java.version");
        System.out.println(string);
        Md5 md5 = new Md5(string);
        md5.processString();
        return md5.getStringDigest();
    }

    public static void main(String[] stringArray) {
        System.out.println(new UUID());
        System.out.println(new UUID());
        System.out.println(new UUID());
        System.out.println(new UUID());
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.unique, 16)) + "-" + Long.toString(this.time, 16) + "-" + address;
    }
}

