/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.UnknownResource;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.store.ResourceStoreManager;
import org.w3c.tools.resources.upgrade.Attribute;
import org.w3c.tools.resources.upgrade.UpgradeException;
import org.w3c.util.IO;

public class Upgrader {
    public static final boolean debug = true;
    Serializer serializer = null;
    String server = null;
    File config = null;
    File props = null;

    public Upgrader(String string, File file, File file2, Serializer serializer) {
        this.server = string;
        this.config = file;
        this.props = file2;
        this.serializer = serializer;
    }

    protected void backupStores(File file, FilenameFilter filenameFilter) throws IOException {
        File file2 = new File(file, "backup");
        file2.mkdirs();
        System.out.print("Doing backup, copying store files in \"" + file2.getAbsolutePath() + "\"...");
        File[] fileArray = file.listFiles(filenameFilter);
        int n = 0;
        while (n < fileArray.length) {
            File file3 = new File(fileArray[n].getParentFile(), "backup/" + fileArray[n].getName());
            IO.copy(fileArray[n], file3);
            ++n;
        }
        System.out.println(" done.");
    }

    protected void checkDir(File file) throws UpgradeException {
        if (!file.exists()) {
            String string = "*** ERROR : \"" + file.getAbsolutePath() + "\" doesn't exists, please check that \"" + file.getParentFile().getParent() + "\" is the Jigsaw Install Directory.";
            throw new UpgradeException(string);
        }
        if (!file.isDirectory()) {
            String string = "*** ERROR : \"" + file.getAbsolutePath() + "\" is not a directory, please check that \"" + file.getParentFile().getParent() + "\" is the Jigsaw Install Directory.";
            throw new UpgradeException(string);
        }
    }

    protected void cleanStores(File file, FilenameFilter filenameFilter) throws IOException {
        System.out.print("Cleaning stores in \"" + file.getAbsolutePath() + "\"...");
        File[] fileArray = file.listFiles(filenameFilter);
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n].delete();
            ++n;
        }
        System.out.println(" done.");
    }

    protected boolean createSubDirs(File file) {
        int n = 0;
        while (n < 128) {
            File file2 = new File(file, Integer.toString(n));
            if (!file2.exists() && !file2.mkdirs()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected File getNewStore(File file, File file2) {
        String string = file2.getName();
        if (string.equals("root.idx")) {
            return new File(file, "root.xml");
        }
        int n = Integer.parseInt(string.substring(3));
        return new File(file, String.valueOf(n % 128) + "/" + string);
    }

    public static Attribute getOldAttribute(org.w3c.tools.resources.Attribute attribute) throws UpgradeException {
        String string = attribute.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = "org.w3c.tools.resources.upgrade." + string.substring(n + 1);
        try {
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[3];
            classArray[0] = Class.forName("java.lang.String");
            if (attribute.getType() == null) {
                throw new UpgradeException("*** ERROR : no type defined for " + attribute.getName());
            }
            classArray[1] = attribute.getType().equals("java.util.Date") ? Class.forName("java.lang.Long") : Class.forName(attribute.getType());
            classArray[2] = Class.forName("java.lang.Integer");
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{attribute.getName(), attribute.getDefault(), new Integer(1)};
            return (Attribute)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("unable to instanciate :" + string2);
        }
    }

    private Properties loadProps(File file) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
            catch (Exception exception) {
                System.err.println("*** ERROR : " + exception.getMessage());
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
        return properties;
    }

    public static int lookupAttribute(String string, org.w3c.tools.resources.Attribute[] attributeArray) {
        int n = 0;
        while (n < attributeArray.length) {
            if (string.equals(attributeArray[n].getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void readIndex(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.readUTF();
            ++n2;
        }
    }

    public static Resource[] readRepository(File file) throws FileNotFoundException, IOException, UpgradeException {
        DataInputStream dataInputStream = null;
        dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        Upgrader.unpickleProlog(dataInputStream);
        Upgrader.readIndex(dataInputStream);
        Vector<Resource> vector = new Vector<Resource>(10);
        Resource resource = null;
        do {
            if ((resource = Upgrader.readResource(dataInputStream)) == null) continue;
            vector.addElement(resource);
        } while (resource != null);
        Object[] objectArray = new Resource[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Resource readResource(DataInputStream dataInputStream) throws IOException, UpgradeException {
        String string = null;
        try {
            string = dataInputStream.readUTF();
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return null;
        }
        if (string.startsWith("org.w3c.jigsaw.map")) {
            System.out.println("\n*** WARNING : " + string + " is no more supported.");
            return new UnknownResource();
        }
        try {
            Class<?> clazz = Class.forName(string);
            Resource resource = (Resource)clazz.newInstance();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(10);
            org.w3c.tools.resources.Attribute[] attributeArray = AttributeRegistry.getClassAttributes(clazz);
            boolean bl = dataInputStream.readBoolean() ^ true;
            if (bl) {
                String string2 = null;
                while (!(string2 = dataInputStream.readUTF()).equals("")) {
                    int n = Upgrader.lookupAttribute(string2, attributeArray);
                    int n2 = dataInputStream.readShort() & 0xFFFF;
                    if (n >= 0) {
                        Attribute attribute = Upgrader.getOldAttribute(attributeArray[n]);
                        Object object = attribute.unpickle(dataInputStream);
                        if (object == null) continue;
                        hashtable.put(string2, object);
                        continue;
                    }
                    dataInputStream.skip(n2);
                }
            } else {
                int n = 0;
                while (n < attributeArray.length) {
                    Attribute attribute;
                    Object object;
                    if (dataInputStream.readBoolean() && (object = (attribute = Upgrader.getOldAttribute(attributeArray[n])).unpickle(dataInputStream)) != null) {
                        hashtable.put(attributeArray[n].getName(), object);
                    }
                    ++n;
                }
            }
            resource.pickleValues(hashtable);
            return resource;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("\n*** ERROR loading " + string);
            System.out.println("*** Class not found : " + classNotFoundException.getMessage());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("\n*** ERROR loading " + string);
            System.out.println("*** " + illegalAccessException.getMessage());
            return null;
        }
        catch (InstantiationException instantiationException) {
            System.out.println("\n*** ERROR loading " + string);
            System.out.println("*** " + instantiationException.getMessage());
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("\n*** ERROR loading " + string);
            System.out.println("*** Class not found : " + noClassDefFoundError.getMessage());
            return null;
        }
    }

    private void saveProps(Properties properties, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, "Updated by Upgrader");
            }
            catch (Exception exception) {
                System.err.println("*** ERROR : " + exception.getMessage());
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            fileOutputStream.close();
        }
        catch (Exception exception) {}
    }

    public static void unpickleProlog(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readInt();
        dataInputStream.readUTF();
        dataInputStream.readInt();
    }

    public void updateEntriesIndex(File file) throws IOException, UpgradeException {
        File[] fileArray;
        if (file.isDirectory()) {
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.indexOf("-index") != -1 && !string.endsWith(".bak") && !string.endsWith(".xml");
                }
            };
            fileArray = file.listFiles(filenameFilter);
            if (fileArray == null || fileArray.length == 0) {
                String string = "\n*** ERROR : unable to find index file.\n*** Please check that \"" + file.getAbsolutePath() + "\" is the Jigsaw store directory";
                throw new UpgradeException(string);
            }
            if (fileArray.length > 1) {
                String string = "\n*** ERROR: several index files found, please delete or move the invalid index files : ";
                int n = 0;
                while (n < fileArray.length) {
                    string = String.valueOf(string) + "\n\t" + fileArray[n].getName();
                    ++n;
                }
                throw new UpgradeException(string);
            }
        } else {
            if (file.exists()) {
                throw new UpgradeException("\n*** ERROR : \"" + file.getAbsolutePath() + "\" is not a directory.");
            }
            throw new UpgradeException("\n*** ERROR : \"" + file.getAbsolutePath() + "\" doesn't exists.");
        }
        File file2 = fileArray[0];
        System.out.print("Found index file \"" + file2.getName() + "\", upgrading...");
        File file3 = new File(file, String.valueOf(file2.getName()) + ".xml");
        ResourceStoreManager.updateEntriesIndex(file2, file3, this.serializer);
        System.out.println(" done.");
    }

    protected void updateProperties(int n) {
        System.out.println("\nUpgrading properties files...");
        System.out.print("Updating \"" + this.props.getName() + "\"...");
        Properties properties = this.loadProps(this.props);
        ((Hashtable)properties).put(httpd.SERIALIZER_CLASS_P, "org.w3c.tools.resources.serialization.xml.XMLSerializer");
        ((Hashtable)properties).put("org.w3c.jigsaw.version.counter", String.valueOf(n));
        this.saveProps(properties, this.props);
        System.out.println(" done.");
    }

    public void upgrade(int n) throws IOException, UpgradeException {
        File file;
        this.checkDir(this.config);
        File file2 = new File(this.config, "stores");
        this.checkDir(file2);
        System.out.println("Upgrading stores in \"" + file2.getAbsolutePath() + "\"...");
        this.updateEntriesIndex(file2);
        System.out.print("Creating subdirectories... ");
        this.createSubDirs(file2);
        System.out.println("done.");
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return (string.startsWith("st-") || string.equals("root.idx")) && !string.endsWith(".bak");
            }
        };
        FilenameFilter filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("st-") || string.equals("root.idx") || string.equals("root.idx.bak") || string.equals("state") || string.endsWith("-index") || string.endsWith("-index.bak");
            }
        };
        this.backupStores(file2, filenameFilter2);
        this.upgradeStores(file2, filenameFilter);
        this.cleanStores(file2, filenameFilter2);
        filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".db");
            }
        };
        filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".bak");
            }
        };
        try {
            file = new File(this.config, "auth");
            this.checkDir(file);
            System.out.println("\nUpgrading realms in \"" + file.getAbsolutePath() + "\"...");
            this.backupStores(file, filenameFilter);
            this.upgradeDB(file, filenameFilter);
            this.cleanStores(file, filenameFilter2);
        }
        catch (UpgradeException upgradeException) {}
        try {
            file = new File(this.config, "indexers");
            this.checkDir(file);
            System.out.println("\nUpgrading indexers in \"" + file.getAbsolutePath() + "\"...");
            this.backupStores(file, filenameFilter);
            this.upgradeDB(file, filenameFilter);
            this.cleanStores(file, filenameFilter2);
        }
        catch (UpgradeException upgradeException) {}
        this.updateProperties(n);
    }

    protected void upgradeDB(File file, FilenameFilter filenameFilter) {
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            System.err.println("No store files found!");
            return;
        }
        System.out.print("Upgrading " + fileArray.length + " store files...");
        int n = 0;
        while (n < fileArray.length) {
            try {
                AttributeHolder[] attributeHolderArray = Upgrader.readRepository(fileArray[n]);
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fileArray[n]));
                this.serializer.writeResources(attributeHolderArray, bufferedWriter);
                System.out.print(".");
            }
            catch (Exception exception) {
                System.err.println("\n*** ERROR : unable to upgrade " + fileArray[n].getName());
                exception.printStackTrace();
            }
            ++n;
        }
        System.out.println(" done.");
    }

    protected void upgradeStores(File file, FilenameFilter filenameFilter) throws UpgradeException {
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            System.err.println("No store files found!");
            return;
        }
        System.out.print("Upgrading " + fileArray.length + " store files");
        int n = 0;
        while (n < fileArray.length) {
            try {
                AttributeHolder[] attributeHolderArray = Upgrader.readRepository(fileArray[n]);
                File file2 = this.getNewStore(file, fileArray[n]);
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                this.serializer.writeResources(attributeHolderArray, bufferedWriter);
                System.out.print(".");
            }
            catch (Exception exception) {
                System.err.println("\n*** ERROR : unable to upgrade " + fileArray[n].getName());
                exception.printStackTrace();
            }
            ++n;
        }
        System.out.println(" done.");
    }

    public static void usage() {
        System.err.println("Usage : java org.w3c.tools.resources.upgrade.Upgrader <Jigsaw Install Directory>\n");
        System.exit(-1);
    }
}

