/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.offline.command;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.tools.offline.command.CommandParseException;

public class CommandLine {
    public static String WHERE = "where";
    public static String LIST = "list";
    public static String GO = "go";
    public static String REC = "r";
    public static String ATTR = "a";
    public static String UP = "..";
    public static String NO_OPT = "none";
    private String cmd = null;
    private String action = null;
    private String target = null;
    private String option = NO_OPT;
    protected Vector parsedCmd;
    protected static Perl5Matcher pmatcher = new Perl5Matcher();
    protected static Perl5Compiler pcompiler = new Perl5Compiler();
    protected static Pattern srPattern;

    public CommandLine(String string) {
        try {
            this.cmd = string;
            this.parsedCmd = new Vector();
            srPattern = pcompiler.compile("^s/[\\w|=|\\*|\\-|\\\\/]+?/[\\w|\\-|\\\\/]+/$", 0);
        }
        catch (MalformedPatternException malformedPatternException) {
            malformedPatternException.printStackTrace();
        }
    }

    public String getAction() {
        return this.action;
    }

    public String getOption() {
        return this.option;
    }

    public String getTarget() {
        return this.target;
    }

    private boolean isaReplaceAction(String string) {
        return pmatcher.matches(string, srPattern);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() throws CommandParseException {
        StringReader stringReader = new StringReader(this.cmd);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.wordChars(33, 44);
        streamTokenizer.wordChars(46, 47);
        streamTokenizer.wordChars(61, 61);
        streamTokenizer.wordChars(63, 64);
        streamTokenizer.wordChars(91, 96);
        try {
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype == -3) {
                    this.parsedCmd.addElement(new String(streamTokenizer.sval));
                }
                if (streamTokenizer.ttype == 45) {
                    this.parsedCmd.addElement(new String("-"));
                }
                int cfr_ignored_0 = streamTokenizer.ttype;
            }
        }
        catch (IOException iOException) {
            throw new CommandParseException();
        }
        switch (this.parsedCmd.size()) {
            case 1: {
                this.action = (String)this.parsedCmd.elementAt(0);
                if (this.action.compareTo(LIST) != 0 && this.action.compareTo(WHERE) != 0) throw new CommandParseException();
                this.target = ".*";
                return;
            }
            default: {
                this.action = (String)this.parsedCmd.elementAt(0);
                if (!this.isaReplaceAction(this.action) && this.action.compareTo(LIST) != 0 && this.action.compareTo(GO) != 0) throw new CommandParseException();
                boolean bl = false;
                int n = 1;
                while (n < this.parsedCmd.size()) {
                    String string = (String)this.parsedCmd.elementAt(n);
                    if (bl) {
                        bl = false;
                        if (string.compareTo(REC) == 0 || string.compareTo(ATTR) == 0 || string.compareTo(String.valueOf(REC) + ATTR) == 0 || string.compareTo(String.valueOf(ATTR) + REC) == 0) {
                            this.option = string;
                        } else {
                            System.out.println("option discarded " + string);
                        }
                    } else {
                        if (string.compareTo("-") != 0) {
                            this.target = string;
                            break;
                        }
                        bl = true;
                    }
                    ++n;
                }
                if (this.target != null) return;
                throw new CommandParseException();
            }
            case 0: 
        }
    }
}

