/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

public class ExifData {
    public static final int[] bytesPerFormat;
    public static final int NUM_FORMATS = 12;
    public static final int FMT_BYTE = 1;
    public static final int FMT_STRING = 2;
    public static final int FMT_USHORT = 3;
    public static final int FMT_ULONG = 4;
    public static final int FMT_URATIONAL = 5;
    public static final int FMT_SBYTE = 6;
    public static final int FMT_UNDEFINED = 7;
    public static final int FMT_SSHORT = 8;
    public static final int FMT_SLONG = 9;
    public static final int FMT_SRATIONAL = 10;
    public static final int FMT_SINGLE = 11;
    public static final int FMT_DOUBLE = 12;
    private byte[] data = null;
    private boolean intelOrder = false;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        bytesPerFormat = nArray;
    }

    public ExifData(byte[] byArray) {
        String string = new String(byArray);
        if (byArray.length <= 4 || !"Exif".equals(string.substring(0, 4))) {
            return;
        }
        String string2 = string.substring(6, 8);
        if ("II".equals(string2)) {
            this.intelOrder = true;
        } else if ("MM".equals(string2)) {
            this.intelOrder = false;
        } else {
            System.err.println("Bogus byte order in EXIF data.");
            return;
        }
        this.data = byArray;
        int n = this.get16u(8);
        if (n != 42) {
            this.data = null;
            System.err.println("Check value fails: 0x" + Integer.toHexString(n));
            return;
        }
    }

    public double convertAnyValue(int n, int n2) {
        if (this.data == null) {
            return 0.0;
        }
        double d = 0.0;
        switch (n) {
            case 6: {
                d = this.data[n2];
                break;
            }
            case 1: {
                int n3 = this.data[n2];
                d = n3 &= 0xFF;
                break;
            }
            case 3: {
                d = this.get16u(n2);
                break;
            }
            case 4: {
                d = this.get32u(n2);
                break;
            }
            case 5: 
            case 10: {
                int n4 = this.get32s(n2);
                int n5 = this.get32s(n2 + 4);
                if (n5 == 0) {
                    d = 0.0;
                    break;
                }
                d = (double)n4 / (double)n5;
                break;
            }
            case 8: {
                d = this.get16s(n2);
                break;
            }
            case 9: {
                d = this.get32s(n2);
                break;
            }
            default: {
                System.err.println("Unexpected number format: " + n);
            }
        }
        return d;
    }

    public int get16s(int n) {
        int n2;
        int n3;
        if (this.data == null) {
            return 0;
        }
        if (this.intelOrder) {
            n3 = this.data[n + 1];
            n2 = this.data[n];
        } else {
            n3 = this.data[n];
            n2 = this.data[n + 1];
        }
        return ((n3 &= 0xFF) << 8) + (n2 &= 0xFF);
    }

    public int get16u(int n) {
        if (this.data == null) {
            return 0;
        }
        int n2 = this.get16s(n);
        return n2 &= 0xFFFF;
    }

    public int get32s(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.data == null) {
            return 0;
        }
        if (this.intelOrder) {
            n5 = this.data[n + 3] & 0xFF;
            n4 = this.data[n + 2] & 0xFF;
            n3 = this.data[n + 1] & 0xFF;
            n2 = this.data[n] & 0xFF;
        } else {
            n5 = this.data[n] & 0xFF;
            n4 = this.data[n + 1] & 0xFF;
            n3 = this.data[n + 2] & 0xFF;
            n2 = this.data[n + 3] & 0xFF;
        }
        int n6 = (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
        return n6;
    }

    public int get32u(int n) {
        if (this.data == null) {
            return 0;
        }
        return this.get32s(n);
    }

    public byte[] getBytes(int n, int n2) {
        if (this.data == null || n2 == 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        int n3 = n;
        while (n2 > 0) {
            byArray[n3 - n] = this.data[n3];
            ++n3;
            --n2;
        }
        return byArray;
    }

    public String getString(int n, int n2) {
        return this.getString(n, n2, true);
    }

    protected String getString(int n, int n2, boolean bl) {
        if (this.data == null) {
            return "";
        }
        String string = "";
        int n3 = n;
        while (!(n2 <= 0 || bl && this.data[n3] == 0)) {
            short s = this.data[n3];
            s = (short)(s & 0xFF);
            String string2 = String.valueOf((char)s);
            if (s == 37 || s < 32 || s > 126) {
                string2 = Integer.toHexString((char)s);
                if (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                string2 = "%" + string2;
            }
            string = String.valueOf(string) + string2;
            ++n3;
            --n2;
        }
        return string;
    }

    public String getUndefined(int n, int n2) {
        return this.getString(n, n2, false);
    }

    public boolean isExifData() {
        return this.data != null;
    }
}

