/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssValue;

public class CssDate
extends CssValue {
    String day = new String();
    String month = new String();
    String year = new String();

    public void set(String s, ApplContext ac) throws InvalidParamException {
        Integer y;
        Integer m;
        Integer d;
        s = s.toLowerCase();
        int length = s.length();
        if (s.indexOf("/") == -1) {
            throw new InvalidParamException("value", s, ac);
        }
        if (s.indexOf("/") == s.lastIndexOf("/")) {
            throw new InvalidParamException("value", s, ac);
        }
        this.day = s.substring(0, s.indexOf("/") - 1);
        this.month = s.substring(s.indexOf("/"), s.lastIndexOf("/") - 1);
        this.year = s.substring(s.lastIndexOf("/"), length);
        try {
            d = new Integer(this.day);
            m = new Integer(this.month);
            y = new Integer(this.year);
        }
        catch (NumberFormatException e) {
            throw new InvalidParamException("value", s, ac);
        }
        if (d > 31 || d < 0 || m > 12 || m < 0 || y < 0) {
            throw new InvalidParamException("value", s, ac);
        }
    }

    public Object get() {
        return new String(this.day + "/" + this.month + "/" + this.year);
    }

    public String toString() {
        return this.day + "/" + this.month + "/" + this.year;
    }

    public boolean equals(Object value) {
        return value instanceof CssDate && this.day.equals(((CssDate)value).day) && this.month.equals(((CssDate)value).month) && this.year.equals(((CssDate)value).year);
    }
}

