/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.Hashtable;
import java.util.Vector;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssColorConstants;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.HSL;
import org.w3c.css.values.HSLA;
import org.w3c.css.values.RGB;
import org.w3c.css.values.RGBA;

public class CssColor
extends CssValue
implements CssColorConstants,
CssOperator {
    Object color;
    RGB rgb;
    RGBA rgba = null;
    HSL hsl = null;
    HSLA hsla = null;
    static Hashtable definedColors;
    static Hashtable deprecatedColors;
    static CssIdent inherit;

    public CssColor() {
        this.color = inherit;
    }

    public CssColor(ApplContext ac, String s) throws InvalidParamException {
        this.setIdentColor(s, ac);
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        if (s.startsWith("#")) {
            this.setShortRGBColor(s.toLowerCase(), ac);
        } else {
            this.setIdentColor(s, ac);
        }
    }

    public Object get() {
        if (this.color != null) {
            if (this.color == inherit) {
                return null;
            }
            return this.color;
        }
        return this.rgb.r;
    }

    public boolean isDefault() {
        return this.color == inherit;
    }

    public String toString() {
        if (this.color != null) {
            if (this.color == inherit) {
                return inherit.toString();
            }
            return this.color.toString();
        }
        if (this.rgba != null) {
            return this.rgba.toString();
        }
        if (this.hsl != null) {
            return this.hsl.toString();
        }
        if (this.hsla != null) {
            return this.hsla.toString();
        }
        return this.rgb.toString();
    }

    public void setRGBColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssNumber number;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGB();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            this.rgb.r = this.clippedIntValue(number.getInt(), ac);
            this.rgb.setPercent(false);
        } else if (val instanceof CssPercentage) {
            this.rgb.r = this.clippedPercentValue(((Float)val.get()).floatValue(), ac);
            this.rgb.setPercent(true);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgb.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgb.g = this.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgb.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgb.g = this.clippedPercentValue(((Float)val.get()).floatValue(), ac);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgb.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgb.b = this.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgb.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgb.b = this.clippedPercentValue(((Float)val.get()).floatValue(), ac);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    private void setShortRGBColor(String s, ApplContext ac) throws InvalidParamException {
        int b;
        int g;
        int r;
        this.rgb = new RGB();
        this.color = null;
        if ((s = s.substring(1)).length() != 3 && s.length() != 6) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (s.length() == 3) {
            String sh = s.substring(0, 1);
            r = Integer.parseInt(sh + sh, 16);
            sh = s.substring(1, 2);
            g = Integer.parseInt(sh + sh, 16);
            sh = s.substring(2, 3);
            b = Integer.parseInt(sh + sh, 16);
        } else {
            r = Integer.parseInt(s.substring(0, 2), 16);
            g = Integer.parseInt(s.substring(2, 4), 16);
            b = Integer.parseInt(s.substring(4, 6), 16);
        }
        this.rgb.r = new Integer(r);
        this.rgb.g = new Integer(g);
        this.rgb.b = new Integer(b);
        this.rgb.output = "#" + s;
    }

    private void setIdentColor(String s, ApplContext ac) throws InvalidParamException {
        String lower_s = s.toLowerCase();
        if (definedColors.get(lower_s) != null) {
            Object obj = definedColors.get(lower_s);
            if (obj instanceof RGB) {
                this.color = lower_s;
                this.rgb = (RGB)obj;
            }
            if (obj instanceof RGBA) {
                this.color = lower_s;
                this.rgba = (RGBA)obj;
            } else if (obj instanceof String) {
                this.color = (String)obj;
                if (!obj.equals(s)) {
                    ac.getFrame().addWarning("color.mixed-capitalization", s);
                }
            }
            return;
        }
        if (deprecatedColors.get(lower_s) != null) {
            this.color = lower_s;
            ac.getFrame().addWarning("deprecated", s);
            return;
        }
        throw new InvalidParamException("value", s, "color", ac);
    }

    public boolean equals(Object cssColor) {
        return cssColor instanceof CssColor && (this.color != null && this.color.equals(((CssColor)cssColor).color) || this.color == null && this.rgb != null && ((CssColor)cssColor).rgb != null && this.rgb.r.equals(((CssColor)cssColor).rgb.r) && this.rgb.g.equals(((CssColor)cssColor).rgb.g) && this.rgb.b.equals(((CssColor)cssColor).rgb.b));
    }

    public void setRGBAColor(Vector exp, ApplContext ac) throws InvalidParamException {
        CssNumber number;
        this.color = null;
        this.rgba = new RGBA();
        CssValue val = (CssValue)exp.elementAt(0);
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            this.rgba.r = this.clippedIntValue(number.getInt(), ac);
            this.rgba.setPercent(false);
        } else if (val instanceof CssPercentage) {
            this.rgba.r = this.clippedPercentValue(((Float)val.get()).floatValue(), ac);
            this.rgba.setPercent(true);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        val = (CssValue)exp.elementAt(1);
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgba.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgba.g = this.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgba.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgba.g = this.clippedPercentValue(((Float)val.get()).floatValue(), ac);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        val = (CssValue)exp.elementAt(2);
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgba.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgba.b = this.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgba.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgba.b = this.clippedPercentValue(((Float)val.get()).floatValue(), ac);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        val = (CssValue)exp.elementAt(3);
        if (!(val instanceof CssNumber)) {
            throw new InvalidParamException("rgb", val, ac);
        }
        this.rgba.a = this.clippedAlphaValue(((Float)val.get()).floatValue(), ac);
    }

    public void setHSLColor(Vector exp, ApplContext ac) throws InvalidParamException {
        this.color = null;
        this.hsl = new HSL();
        CssNumber h = new CssNumber();
        CssPercentage s = new CssPercentage();
        CssPercentage l = new CssPercentage();
        h.set(exp.elementAt(0).toString(), ac);
        if (((Float)h.get()).intValue() > 360 || ((Float)h.get()).intValue() < 0) {
            throw new InvalidParamException("angle", exp.elementAt(0).toString(), ac);
        }
        s.set(exp.elementAt(1).toString(), ac);
        l.set(exp.elementAt(2).toString(), ac);
        this.hsl.h = h;
        this.hsl.s = s;
        this.hsl.l = l;
    }

    public void setHSLAColor(Vector exp, ApplContext ac) throws InvalidParamException {
        Float a;
        this.color = null;
        this.hsla = new HSLA();
        CssNumber h = new CssNumber();
        CssPercentage s = new CssPercentage();
        CssPercentage l = new CssPercentage();
        h.set(exp.elementAt(0).toString(), ac);
        if (((Float)h.get()).intValue() > 360 || ((Float)h.get()).intValue() < 0) {
            throw new InvalidParamException("angle", exp.elementAt(0).toString(), ac);
        }
        s.set(exp.elementAt(1).toString(), ac);
        l.set(exp.elementAt(2).toString(), ac);
        try {
            a = new Float(((CssValue)exp.elementAt(3)).toString());
        }
        catch (Exception e) {
            throw new InvalidParamException("rgb", exp.elementAt(3).toString(), ac);
        }
        if (a.floatValue() < 0.0f || a.floatValue() > 1.0f) {
            ac.getFrame().addWarning("out-of-range", Integer.toString(a.intValue()));
            a = this.clippedAlphaValue(a.floatValue(), ac);
        }
        this.hsla.h = h;
        this.hsla.s = s;
        this.hsla.l = l;
        this.hsla.a = a;
    }

    private Integer clippedIntValue(int rgb, ApplContext ac) {
        if (rgb < 0 || rgb > 255) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(rgb));
            return new Integer(rgb < 0 ? 0 : 255);
        }
        return new Integer(rgb);
    }

    private Float clippedPercentValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 100.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return new Float((double)p < 0.0 ? 0.0 : 100.0);
        }
        return new Float(p);
    }

    private Float clippedAlphaValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 1.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return new Float((double)p < 0.0 ? 0.0 : 1.0);
        }
        return new Float(p);
    }

    public Object getRed() {
        return this.rgb.r;
    }

    public Object getGreen() {
        return this.rgb.g;
    }

    public Object getBlue() {
        return this.rgb.b;
    }

    static {
        inherit = new CssIdent("inherit");
        definedColors = new Hashtable();
        deprecatedColors = new Hashtable();
        definedColors.put("aliceblue", new RGB(new Integer(240), new Integer(248), new Integer(255)));
        definedColors.put("antiquewhite", new RGB(new Integer(250), new Integer(235), new Integer(215)));
        definedColors.put("aqua", new RGB(new Integer(0), new Integer(255), new Integer(255)));
        definedColors.put("aquamarine", new RGB(new Integer(127), new Integer(255), new Integer(212)));
        definedColors.put("azure", new RGB(new Integer(240), new Integer(255), new Integer(255)));
        definedColors.put("beige", new RGB(new Integer(245), new Integer(245), new Integer(220)));
        definedColors.put("bisque", new RGB(new Integer(255), new Integer(228), new Integer(196)));
        definedColors.put("black", new RGB(new Integer(0), new Integer(0), new Integer(0)));
        definedColors.put("blanchedalmond", new RGB(new Integer(255), new Integer(235), new Integer(205)));
        definedColors.put("blue", new RGB(new Integer(0), new Integer(0), new Integer(255)));
        definedColors.put("blueviolet", new RGB(new Integer(138), new Integer(43), new Integer(226)));
        definedColors.put("brown", new RGB(new Integer(165), new Integer(42), new Integer(42)));
        definedColors.put("burlywood", new RGB(new Integer(222), new Integer(184), new Integer(135)));
        definedColors.put("cadetBlue", new RGB(new Integer(95), new Integer(158), new Integer(160)));
        definedColors.put("chartreuse", new RGB(new Integer(127), new Integer(255), new Integer(0)));
        definedColors.put("chocolate", new RGB(new Integer(210), new Integer(105), new Integer(30)));
        definedColors.put("coral", new RGB(new Integer(255), new Integer(127), new Integer(80)));
        definedColors.put("cornflowerblue", new RGB(new Integer(100), new Integer(149), new Integer(237)));
        definedColors.put("cornsilk", new RGB(new Integer(255), new Integer(248), new Integer(220)));
        definedColors.put("crimson", new RGB(new Integer(220), new Integer(20), new Integer(60)));
        definedColors.put("cyan", new RGB(new Integer(0), new Integer(255), new Integer(255)));
        definedColors.put("darkblue", new RGB(new Integer(0), new Integer(0), new Integer(139)));
        definedColors.put("darkcyan", new RGB(new Integer(0), new Integer(139), new Integer(139)));
        definedColors.put("darkgoldenrod", new RGB(new Integer(184), new Integer(134), new Integer(11)));
        definedColors.put("darkgray", new RGB(new Integer(169), new Integer(169), new Integer(169)));
        definedColors.put("darkgreen", new RGB(new Integer(0), new Integer(100), new Integer(0)));
        definedColors.put("darkkhaki", new RGB(new Integer(189), new Integer(183), new Integer(107)));
        definedColors.put("darkmagenta", new RGB(new Integer(139), new Integer(0), new Integer(139)));
        definedColors.put("darkolivegreen", new RGB(new Integer(85), new Integer(107), new Integer(47)));
        definedColors.put("darkorange", new RGB(new Integer(255), new Integer(140), new Integer(0)));
        definedColors.put("darkorchid", new RGB(new Integer(153), new Integer(50), new Integer(204)));
        definedColors.put("darkred", new RGB(new Integer(139), new Integer(0), new Integer(0)));
        definedColors.put("darksalmon", new RGB(new Integer(233), new Integer(150), new Integer(122)));
        definedColors.put("darkseagreen", new RGB(new Integer(143), new Integer(188), new Integer(143)));
        definedColors.put("darkslateblue", new RGB(new Integer(72), new Integer(61), new Integer(139)));
        definedColors.put("darkslategray", new RGB(new Integer(47), new Integer(79), new Integer(79)));
        definedColors.put("darkturquoise", new RGB(new Integer(0), new Integer(206), new Integer(209)));
        definedColors.put("darkviolet", new RGB(new Integer(148), new Integer(0), new Integer(211)));
        definedColors.put("deeppink", new RGB(new Integer(255), new Integer(20), new Integer(147)));
        definedColors.put("deepskyblue", new RGB(new Integer(0), new Integer(191), new Integer(255)));
        definedColors.put("dimgray", new RGB(new Integer(105), new Integer(105), new Integer(105)));
        definedColors.put("dodgerblue", new RGB(new Integer(30), new Integer(144), new Integer(255)));
        definedColors.put("firebrick", new RGB(new Integer(178), new Integer(34), new Integer(34)));
        definedColors.put("floralwhite", new RGB(new Integer(255), new Integer(250), new Integer(240)));
        definedColors.put("forestgreen", new RGB(new Integer(34), new Integer(139), new Integer(34)));
        definedColors.put("fuchsia", new RGB(new Integer(255), new Integer(0), new Integer(255)));
        definedColors.put("gainsboro", new RGB(new Integer(220), new Integer(220), new Integer(220)));
        definedColors.put("ghostwhite", new RGB(new Integer(248), new Integer(248), new Integer(255)));
        definedColors.put("gold", new RGB(new Integer(255), new Integer(215), new Integer(0)));
        definedColors.put("goldenrod", new RGB(new Integer(218), new Integer(165), new Integer(32)));
        definedColors.put("gray", new RGB(new Integer(128), new Integer(128), new Integer(128)));
        definedColors.put("green", new RGB(new Integer(0), new Integer(128), new Integer(0)));
        definedColors.put("greenyellow", new RGB(new Integer(173), new Integer(255), new Integer(47)));
        definedColors.put("honeydew", new RGB(new Integer(240), new Integer(255), new Integer(240)));
        definedColors.put("hotpink", new RGB(new Integer(255), new Integer(105), new Integer(180)));
        definedColors.put("indianred", new RGB(new Integer(205), new Integer(92), new Integer(92)));
        definedColors.put("indigo", new RGB(new Integer(75), new Integer(0), new Integer(130)));
        definedColors.put("ivory", new RGB(new Integer(255), new Integer(255), new Integer(240)));
        definedColors.put("khaki", new RGB(new Integer(240), new Integer(230), new Integer(140)));
        definedColors.put("lavender", new RGB(new Integer(230), new Integer(230), new Integer(250)));
        definedColors.put("lavenderblush", new RGB(new Integer(255), new Integer(240), new Integer(245)));
        definedColors.put("lawngreen", new RGB(new Integer(124), new Integer(252), new Integer(0)));
        definedColors.put("lemonchiffon", new RGB(new Integer(255), new Integer(250), new Integer(205)));
        definedColors.put("lightblue", new RGB(new Integer(173), new Integer(216), new Integer(230)));
        definedColors.put("lightcoral", new RGB(new Integer(240), new Integer(128), new Integer(128)));
        definedColors.put("lightcyan", new RGB(new Integer(224), new Integer(255), new Integer(255)));
        definedColors.put("lightgoldenrodyellow", new RGB(new Integer(250), new Integer(250), new Integer(210)));
        definedColors.put("lightgreen", new RGB(new Integer(144), new Integer(238), new Integer(144)));
        definedColors.put("lightgrey", new RGB(new Integer(211), new Integer(211), new Integer(211)));
        definedColors.put("lightpink", new RGB(new Integer(255), new Integer(182), new Integer(193)));
        definedColors.put("lightsalmon", new RGB(new Integer(255), new Integer(160), new Integer(122)));
        definedColors.put("lightseagreen", new RGB(new Integer(32), new Integer(178), new Integer(170)));
        definedColors.put("lightskyblue", new RGB(new Integer(135), new Integer(206), new Integer(250)));
        definedColors.put("lightslategray", new RGB(new Integer(119), new Integer(136), new Integer(153)));
        definedColors.put("lightsteelblue", new RGB(new Integer(176), new Integer(196), new Integer(222)));
        definedColors.put("lightyellow", new RGB(new Integer(255), new Integer(255), new Integer(224)));
        definedColors.put("lime", new RGB(new Integer(0), new Integer(255), new Integer(0)));
        definedColors.put("limegreen", new RGB(new Integer(50), new Integer(205), new Integer(50)));
        definedColors.put("linen", new RGB(new Integer(250), new Integer(240), new Integer(230)));
        definedColors.put("magenta", new RGB(new Integer(255), new Integer(0), new Integer(255)));
        definedColors.put("maroon", new RGB(new Integer(128), new Integer(0), new Integer(0)));
        definedColors.put("mediumaquamarine", new RGB(new Integer(102), new Integer(205), new Integer(170)));
        definedColors.put("mediumblue", new RGB(new Integer(0), new Integer(0), new Integer(205)));
        definedColors.put("mediumorchid", new RGB(new Integer(186), new Integer(85), new Integer(211)));
        definedColors.put("mediumpurple", new RGB(new Integer(147), new Integer(112), new Integer(219)));
        definedColors.put("mediumseagreen", new RGB(new Integer(60), new Integer(179), new Integer(113)));
        definedColors.put("mediumslateblue", new RGB(new Integer(123), new Integer(104), new Integer(238)));
        definedColors.put("mediumspringgreen", new RGB(new Integer(0), new Integer(250), new Integer(154)));
        definedColors.put("mediumturquoise", new RGB(new Integer(72), new Integer(209), new Integer(204)));
        definedColors.put("mediumvioletred", new RGB(new Integer(199), new Integer(21), new Integer(133)));
        definedColors.put("midnightblue", new RGB(new Integer(25), new Integer(25), new Integer(112)));
        definedColors.put("mintcream", new RGB(new Integer(245), new Integer(255), new Integer(250)));
        definedColors.put("mistyrose", new RGB(new Integer(255), new Integer(228), new Integer(225)));
        definedColors.put("moccasin", new RGB(new Integer(255), new Integer(228), new Integer(181)));
        definedColors.put("navajowhite", new RGB(new Integer(255), new Integer(222), new Integer(173)));
        definedColors.put("navy", new RGB(new Integer(0), new Integer(0), new Integer(128)));
        definedColors.put("oldlace", new RGB(new Integer(253), new Integer(245), new Integer(230)));
        definedColors.put("olive", new RGB(new Integer(128), new Integer(128), new Integer(0)));
        definedColors.put("olivedrab", new RGB(new Integer(107), new Integer(142), new Integer(35)));
        definedColors.put("orange", new RGB(new Integer(255), new Integer(165), new Integer(0)));
        definedColors.put("orangered", new RGB(new Integer(255), new Integer(69), new Integer(0)));
        definedColors.put("orchid", new RGB(new Integer(218), new Integer(112), new Integer(214)));
        definedColors.put("palegoldenrod", new RGB(new Integer(238), new Integer(232), new Integer(170)));
        definedColors.put("palegreen", new RGB(new Integer(152), new Integer(251), new Integer(152)));
        definedColors.put("paleturquoise", new RGB(new Integer(175), new Integer(238), new Integer(238)));
        definedColors.put("palevioletred", new RGB(new Integer(219), new Integer(112), new Integer(147)));
        definedColors.put("papayawhip", new RGB(new Integer(255), new Integer(239), new Integer(213)));
        definedColors.put("peachpuff", new RGB(new Integer(255), new Integer(218), new Integer(185)));
        definedColors.put("peru", new RGB(new Integer(205), new Integer(133), new Integer(63)));
        definedColors.put("pink", new RGB(new Integer(255), new Integer(192), new Integer(203)));
        definedColors.put("plum", new RGB(new Integer(221), new Integer(160), new Integer(221)));
        definedColors.put("powderBlue", new RGB(new Integer(176), new Integer(224), new Integer(230)));
        definedColors.put("purple", new RGB(new Integer(128), new Integer(0), new Integer(128)));
        definedColors.put("red", new RGB(new Integer(255), new Integer(0), new Integer(0)));
        definedColors.put("rosybrown", new RGB(new Integer(188), new Integer(143), new Integer(143)));
        definedColors.put("royalblue", new RGB(new Integer(65), new Integer(105), new Integer(225)));
        definedColors.put("saddlebrown", new RGB(new Integer(139), new Integer(69), new Integer(19)));
        definedColors.put("salmon", new RGB(new Integer(250), new Integer(128), new Integer(114)));
        definedColors.put("sandybrown", new RGB(new Integer(244), new Integer(164), new Integer(96)));
        definedColors.put("seagreen", new RGB(new Integer(46), new Integer(139), new Integer(87)));
        definedColors.put("seashell", new RGB(new Integer(255), new Integer(245), new Integer(238)));
        definedColors.put("sienna", new RGB(new Integer(160), new Integer(82), new Integer(45)));
        definedColors.put("silver", new RGB(new Integer(192), new Integer(192), new Integer(192)));
        definedColors.put("skyblue", new RGB(new Integer(135), new Integer(206), new Integer(235)));
        definedColors.put("slateblue", new RGB(new Integer(106), new Integer(90), new Integer(205)));
        definedColors.put("slategray", new RGB(new Integer(112), new Integer(128), new Integer(144)));
        definedColors.put("snow", new RGB(new Integer(255), new Integer(250), new Integer(250)));
        definedColors.put("springgreen", new RGB(new Integer(0), new Integer(255), new Integer(127)));
        definedColors.put("steelblue", new RGB(new Integer(70), new Integer(130), new Integer(180)));
        definedColors.put("tan", new RGB(new Integer(210), new Integer(180), new Integer(140)));
        definedColors.put("teal", new RGB(new Integer(0), new Integer(128), new Integer(128)));
        definedColors.put("thistle", new RGB(new Integer(216), new Integer(191), new Integer(216)));
        definedColors.put("tomato", new RGB(new Integer(255), new Integer(99), new Integer(71)));
        definedColors.put("turquoise", new RGB(new Integer(64), new Integer(224), new Integer(208)));
        definedColors.put("violet", new RGB(new Integer(238), new Integer(130), new Integer(238)));
        definedColors.put("wheat", new RGB(new Integer(245), new Integer(222), new Integer(179)));
        definedColors.put("white", new RGB(new Integer(255), new Integer(255), new Integer(255)));
        definedColors.put("whitesmoke", new RGB(new Integer(245), new Integer(245), new Integer(245)));
        definedColors.put("yellow", new RGB(new Integer(255), new Integer(255), new Integer(0)));
        definedColors.put("yellowgreen", new RGB(new Integer(154), new Integer(205), new Integer(50)));
        definedColors.put("grey", new RGB(new Integer(128), new Integer(128), new Integer(128)));
        definedColors.put("darkslategrey", new RGB(new Integer(47), new Integer(79), new Integer(79)));
        definedColors.put("dimgrey", new RGB(new Integer(105), new Integer(105), new Integer(105)));
        definedColors.put("lightgray", new RGB(new Integer(211), new Integer(211), new Integer(211)));
        definedColors.put("lightslategrey", new RGB(new Integer(119), new Integer(136), new Integer(153)));
        definedColors.put("slategrey", new RGB(new Integer(112), new Integer(128), new Integer(144)));
        definedColors.put("transparent", new RGBA(new Integer(0), new Integer(0), new Integer(0), new Float(0.0f)));
        deprecatedColors.put("activeborder", "ActiveBorder");
        deprecatedColors.put("activecaption", "ActiveCaption");
        deprecatedColors.put("appworkspace", "AppWorkspace");
        deprecatedColors.put("background", "Background");
        deprecatedColors.put("buttonface", "ButtonFace");
        deprecatedColors.put("buttonhighlight", "ButtonHighlight");
        deprecatedColors.put("buttonshadow", "ButtonShadow");
        deprecatedColors.put("buttontext", "ButtonText");
        deprecatedColors.put("captiontext", "CaptionText");
        deprecatedColors.put("graytext", "GrayText");
        deprecatedColors.put("highlight", "Highlight");
        deprecatedColors.put("highlighttext", "HighlightText");
        deprecatedColors.put("inactiveborder", "InactiveBorder");
        deprecatedColors.put("inactivecaption", "InactiveCaption");
        deprecatedColors.put("inactivecaptiontext", "InactiveCaptionText");
        deprecatedColors.put("infobackground", "InfoBackground");
        deprecatedColors.put("infotext", "InfoText");
        deprecatedColors.put("menu", "Menu");
        deprecatedColors.put("menutext", "MenuText");
        deprecatedColors.put("scrollbar", "Scrollbar");
        deprecatedColors.put("threeddarkshadow", "ThreeDDarkShadow");
        deprecatedColors.put("threedface", "ThreeDFace");
        deprecatedColors.put("threedhighlight", "ThreeDHighlight");
        deprecatedColors.put("threedlightshadow", "ThreeDLightShadow");
        deprecatedColors.put("threedshadow", "ThreeDShadow");
        deprecatedColors.put("window", "Window");
        deprecatedColors.put("windowframe", "WindowFrame");
        deprecatedColors.put("windowtext", "WindowText");
        definedColors.put("flavor", "flavor");
        definedColors.put("currentcolor", "currentColor");
    }
}

