/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class Utf8Properties
extends Properties {
    private static final long serialVersionUID = 5907218757225133892L;
    public static final String ENCODING = "UTF-8";
    private static final String COMMENT = "#!";
    private static final String keyValueSeparators = "=: \t\r\n\f";

    public Utf8Properties() {
        this((Properties)null);
    }

    public Utf8Properties(Properties defaults) {
        this.defaults = defaults;
    }

    public synchronized void load(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, ENCODING));
        String line = in.readLine();
        while (line != null) {
            if (!(line = Utf8Properties.removeWhiteSpaces(line)).equals("") && COMMENT.indexOf(line.charAt(0)) == -1) {
                String property = line;
                while (this.continueLine(line)) {
                    property = property.substring(0, property.length() - 1);
                    line = in.readLine();
                    property = property + line;
                }
                if (!property.equals("")) {
                    int endOfKey;
                    for (endOfKey = 0; endOfKey < property.length() && keyValueSeparators.indexOf(property.charAt(endOfKey)) == -1; ++endOfKey) {
                    }
                    String key = property.substring(0, endOfKey);
                    String value = property.substring(endOfKey + 1, property.length());
                    key = this.loadConversion(key);
                    value = this.loadConversion(Utf8Properties.removeWhiteSpaces(value));
                    this.put(key, value);
                }
            }
            line = in.readLine();
        }
    }

    public static String removeWhiteSpaces(String line) {
        int index;
        for (index = 0; index < line.length() && keyValueSeparators.indexOf(line.charAt(index)) != -1; ++index) {
        }
        return line.substring(index, line.length());
    }

    private String loadConversion(String line) {
        StringBuffer val = new StringBuffer(line.length());
        for (int index = 0; index < line.length(); ++index) {
            int currentChar = line.charAt(index);
            if (currentChar == 92) {
                currentChar = line.charAt(++index);
                switch (currentChar) {
                    case 116: {
                        currentChar = 9;
                        break;
                    }
                    case 114: {
                        currentChar = 13;
                        break;
                    }
                    case 110: {
                        currentChar = 10;
                        break;
                    }
                    case 102: {
                        currentChar = 12;
                        break;
                    }
                    case 117: {
                        ++index;
                        int value = 0;
                        block13: for (int i = 0; i < 4; ++i) {
                            currentChar = line.charAt(index++);
                            switch (currentChar) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    value = (value << 4) + currentChar - 48;
                                    continue block13;
                                }
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    value = (value << 4) + 10 + currentChar - 97;
                                    continue block13;
                                }
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: {
                                    value = (value << 4) + 10 + currentChar - 65;
                                    continue block13;
                                }
                                default: {
                                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                }
                            }
                        }
                        --index;
                        currentChar = (char)value;
                    }
                }
            }
            val.append((char)currentChar);
        }
        return val.toString();
    }

    private String storeConversion(String line) {
        int length = line.length();
        StringBuffer outBuffer = new StringBuffer(length * 2);
        block7: for (int i = 0; i < length; ++i) {
            char currentChar = line.charAt(i);
            switch (currentChar) {
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block7;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block7;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block7;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block7;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block7;
                }
                default: {
                    outBuffer.append(currentChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private boolean continueLine(String line) {
        if (line != null && !line.equals("")) {
            return line.charAt(line.length() - 1) == '\\';
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(OutputStream out, String header) throws IOException {
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
        if (header != null) {
            output.write("#" + header);
            output.newLine();
        }
        output.write("#" + new Date());
        output.newLine();
        Utf8Properties utf8Properties = this;
        synchronized (utf8Properties) {
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key = this.storeConversion((String)e.nextElement());
                String val = this.storeConversion((String)this.get(key));
                output.write(key + "=" + val);
                output.newLine();
            }
        }
        output.flush();
    }
}

