/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.lang.reflect.Method;
import org.w3c.css.parser.Frame;
import org.w3c.css.util.Messages;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptCharsetList;
import org.w3c.www.http.HttpFactory;

public class ApplContext {
    private static Method m = null;
    String credential = null;
    String lang;
    Messages msgs;
    Frame frame;
    String cssversion;
    String profile;
    String input;
    Class cssselectorstyle;
    int origin = -1;
    String medium;

    public ApplContext(String lang) {
        this.lang = lang;
        this.msgs = new Messages(lang);
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        frame.ac = this;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Class getCssSelectorsStyle() {
        return this.cssselectorstyle;
    }

    public void setCssSelectorsStyle(Class s) {
        this.cssselectorstyle = s;
    }

    public Messages getMsg() {
        return this.msgs;
    }

    public String getContentType() {
        return this.msgs != null ? this.msgs.getString("content-type") : null;
    }

    public String getContentLanguage() {
        return this.msgs != null ? this.msgs.getString("content-language") : null;
    }

    public String getContentEncoding() {
        String res = null;
        if (this.msgs != null) {
            res = this.msgs.getString("content-encoding");
            if (res == null) {
                res = this.msgs.getString("output-encoding-name");
            }
            if (res != null) {
                return res;
            }
        }
        return "UTF-8";
    }

    public String getLang() {
        return this.lang;
    }

    public void setCssVersion(String cssversion) {
        this.cssversion = cssversion;
    }

    public String getCssVersion() {
        if (this.cssversion == null) {
            this.cssversion = "css2";
        }
        return this.cssversion;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getProfile() {
        if (this.profile == null) {
            return "";
        }
        return this.profile;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getOrigin() {
        return this.origin;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getMedium() {
        return this.medium;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setContentEncoding(String acceptCharset) {
        if (acceptCharset != null) {
            HttpAcceptCharsetList charsetList = HttpFactory.parseAcceptCharsetList((String)acceptCharset);
            HttpAcceptCharset[] charsets = (HttpAcceptCharset[])charsetList.getValue();
            String encoding = null;
            double quality = 0.0;
            String biasedcharset = this.getMsg().getString("output-encoding-name");
            for (int i = 0; i < charsets.length && quality < 1.0; ++i) {
                HttpAcceptCharset charset = charsets[i];
                String currentCharset = charset.getCharset();
                if (!this.isCharsetSupported(currentCharset)) continue;
                double currentQuality = charset.getQuality();
                if (biasedcharset != null && !biasedcharset.equalsIgnoreCase(currentCharset)) {
                    currentQuality *= 0.5;
                }
                if (!(currentQuality > quality)) continue;
                quality = currentQuality;
                encoding = charset.getCharset();
            }
            if (encoding != null) {
                this.getMsg().properties.setProperty("content-encoding", encoding);
            } else {
                this.getMsg().properties.remove("content-encoding");
            }
        } else {
            this.getMsg().properties.remove("content-encoding");
        }
    }

    private boolean isCharsetSupported(String charset) {
        if (m == null) {
            return true;
        }
        try {
            Object[] p = new String[]{charset};
            Boolean b = (Boolean)m.invoke(null, p);
            return b;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        try {
            Class<?> c = Class.forName("java.nio.charset.Charset");
            Class[] cp = new Class[]{String.class};
            m = c.getDeclaredMethod("isSupported", cp);
        }
        catch (ClassNotFoundException ex) {
            m = null;
        }
        catch (NoSuchMethodException ex) {
            m = null;
        }
    }
}

