/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors.attributes;

import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.util.ApplContext;

public class AttributeExact
extends AttributeSelector {
    private String value;

    public AttributeExact(String name, String value) {
        this.setName(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean canApply(Selector other) {
        if (other instanceof AttributeAny) {
            return true;
        }
        if (other instanceof AttributeExact || other instanceof AttributeOneOf || other instanceof AttributeBegin) {
            return this.value.equals(((AttributeExact)other).getValue());
        }
        return false;
    }

    public void applyAttribute(ApplContext ac, AttributeSelector attr) {
        if (attr instanceof AttributeExact) {
            if (!this.value.equals(((AttributeExact)attr).getValue())) {
                ac.getFrame().addWarning("incompatible", this.toString(), attr.toString());
            }
        } else if (attr instanceof AttributeOneOf) {
            if (!this.value.equals(((AttributeOneOf)attr).getValue())) {
                ac.getFrame().addWarning("incompatible", this.toString(), attr.toString());
            }
        } else if (attr instanceof AttributeBegin && !this.value.equals(((AttributeBegin)attr).getValue())) {
            ac.getFrame().addWarning("incompatible", this.toString(), attr.toString());
        }
    }

    public String toString() {
        return "[" + this.getName() + "=\"" + this.value + "\"]";
    }
}

