/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.css.css.HTMLStyleSheetParser;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleReportFactory;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.Util;
import org.w3c.tools.resources.ProtocolException;

public class CssValidator {
    ApplContext ac;
    PrintWriter out;
    Vector uris = new Vector();
    Hashtable params = new Hashtable();
    static boolean showCSS = false;
    private Exception exception;

    public CssValidator() {
        this.params.put("profile", "css2");
        this.params.put("medium", "all");
        this.params.put("output", "text");
        this.params.put("lang", "en");
        this.params.put("warning", "2");
    }

    public static void main(String[] args) throws IOException, MalformedURLException {
        Object selector = null;
        CssValidator style = new CssValidator();
        try {
            style.getParams(args);
            style.ac = new ApplContext((String)style.params.get("lang"));
            System.out.println(style.params);
        }
        catch (Exception e) {
            System.out.println("Usage: java org.w3c.css.css.CssValidator  [OPTIONS] | [URL]*");
            System.out.println("OPTIONS");
            System.out.println("\t-p, --printCSS");
            System.out.println("\t\tPrints the validated CSS (only with text output, the CSS is printed with other outputs)");
            System.out.println("\t-profile PROFILE, --profile=PROFILE");
            System.out.println("\t\tChecks the Stylesheet against PROFILE");
            System.out.println("\t\tPossible values for PROFILE are css1, css2 (default), css21, css3, svg, svgbasic, svgtiny, atsc-tv, mobile, tv");
            System.out.println("\t-medium MEDIUM, --medium=MEDIUM");
            System.out.println("\t\tChecks the Stylesheet using the medium MEDIUM");
            System.out.println("\t\tPossible values for MEDIUM are all (default), aural, braille, embossed, handheld, print, projection, screen, tty, tv, presentation");
            System.out.println("\t-output OUTPUT, --output=OUTPUT");
            System.out.println("\t\tPrints the result in the selected format");
            System.out.println("\t\tPossible values for OUTPUT are text (default), xhtml, html (same result as xhtml), soap12");
            System.out.println("\t-lang LANG, --lang=LANG");
            System.out.println("\t\tPrints the result in the specified language");
            System.out.println("\t\tPossible values for LANG are de, en (default), es, fr, ja, nl, zh-cn");
            System.out.println("\t-warning WARN, --warning=WARN");
            System.out.println("\t\tWarnings verbosity level");
            System.out.println("\t\tPossible values for WARN are -1 (no warning), 0, 1, 2 (default, all the warnings");
            System.out.println();
            System.out.println("URL");
            System.out.println("\tURL can either represent a distant web resource (http://) or a local file (file:/)");
            System.exit(1);
        }
        String profile = (String)style.params.get("profile");
        if (profile != null && !"none".equals(profile)) {
            if ("css1".equals(profile) || "css2".equals(profile) || "css3".equals(profile) || "svg".equals(profile) || "svgbasic".equals(profile) || "svgtiny".equals(profile)) {
                style.ac.setCssVersion(profile);
            } else {
                style.ac.setProfile(profile);
                style.ac.setCssVersion("css2");
            }
        } else {
            style.ac.setCssVersion("css2");
        }
        style.ac.setMedium((String)style.params.get("medium"));
        String encoding = style.ac.getMsg().getString("output-encoding-name");
        style.out = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
        for (int i = 0; i < style.uris.size(); ++i) {
            String uri = (String)style.uris.get(i);
            if (uri == null) continue;
            try {
                uri = HTTPURL.getURL(uri).toString();
                HTMLStyleSheetParser URLparser = new HTMLStyleSheetParser(style.ac, uri);
                style.handleRequest(style.ac, uri, URLparser.getStyleSheet(), (String)style.params.get("output"), Integer.parseInt((String)style.params.get("warning")), true);
                continue;
            }
            catch (ProtocolException pex) {
                if (!Util.onDebug) continue;
                pex.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handleRequest(ApplContext ac, String title, StyleSheet styleSheet, String output, int warningLevel, boolean errorReport) throws Exception {
        if (styleSheet == null) {
            throw new IOException(ac.getMsg().getServletString("process") + " " + title);
        }
        styleSheet.findConflicts(ac);
        StyleReport style = StyleReportFactory.getStyleReport(ac, title, styleSheet, output, warningLevel);
        if (!errorReport) {
            style.desactivateError();
        }
        style.print(this.out);
    }

    private void getParams(String[] args) throws Exception {
        Vector<String> v = new Vector<String>(Arrays.asList(args));
        Enumeration<String> e = v.elements();
        while (e.hasMoreElements()) {
            String paramName = "";
            String paramValue = "";
            String param = e.nextElement();
            if (param.equals("--printCSS") || param.equals("-p")) {
                showCSS = true;
            } else if (param.startsWith("--")) {
                int separator = param.indexOf("=");
                paramName = param.substring(2, separator);
                paramValue = param.substring(separator + 1);
            } else if (param.startsWith("-")) {
                paramName = param.substring(1);
                paramValue = e.hasMoreElements() ? e.nextElement() : "";
            } else {
                this.uris.add(param);
            }
            if (paramName.equals("") || !this.params.containsKey(paramName)) continue;
            if (paramValue.equals("")) {
                throw new Exception("You must specify a value for the parameter " + paramName);
            }
            this.params.put(paramName, paramValue);
        }
    }
}

